/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.w3c.dom.Node;

public class RMIServerInfo
implements XMLizable {
    protected InetAddress address;
    protected int port;
    protected int sslPort;
    protected String username;
    protected String password;
    protected String application;
    protected String httpTunnelPath;
    protected boolean secure;

    public RMIServerInfo(Node parent) throws InstantiationException {
        this.username = XMLUtils.getNodeAttribute(parent, "username");
        this.password = XMLUtils.getNodeAttribute(parent, "password");
        this.httpTunnelPath = XMLUtils.getNodeAttribute(parent, "http-path");
        this.secure = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "secure"));
        String serverName = XMLUtils.getNodeAttribute(parent, "host");
        if (serverName == null) {
            throw new InstantiationException("No host attribute set for <server> tag");
        }
        try {
            this.address = InetAddress.getByName(serverName);
        }
        catch (UnknownHostException e) {
            throw new InstantiationException("Unknown Host in server tag: " + serverName);
        }
        String port = XMLUtils.getNodeAttribute(parent, "port");
        this.port = 23791;
        if (port != null) {
            try {
                this.port = Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String sslPort = XMLUtils.getNodeAttribute(parent, "ssl-port");
        this.sslPort = -1;
        if (sslPort != null) {
            try {
                this.sslPort = Integer.parseInt(sslPort);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.print(indention + "<server");
        if (this.username != null) {
            out.print(" username=\"" + XMLUtils.encode(this.username) + "\"");
        }
        if (this.password != null) {
            out.print(" password=\"" + XMLUtils.encode(this.password) + "\"");
        }
        if (this.address != null) {
            out.print(" host=\"" + XMLUtils.encode(this.address.getHostName()) + "\"");
        }
        if (this.httpTunnelPath != null) {
            out.print(" http-path=\"" + XMLUtils.encode(this.httpTunnelPath) + "\"");
            if (this.secure) {
                out.print(" secure=\"true\"");
            }
        }
        out.println(" />");
    }

    protected String getOrmiUrl() {
        return "ormi://" + this.address + ':' + this.port + '/' + (this.application == null ? "" : this.application);
    }
}

