/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import com.evermind.io.FilePostParser;
import com.evermind.io.PostEntry;
import com.evermind.io.PostFileInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class FilePostServlet
extends HttpServlet {
    private String username;
    private String password;
    private String root;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.username = config.getInitParameter("username");
        this.password = config.getInitParameter("password");
        this.root = config.getInitParameter("root");
        if (this.root != null && !this.root.endsWith(File.separator)) {
            this.root = this.root + File.separator;
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        if (this.password == null || this.username == null) {
            ServletOutputStream out = response.getOutputStream();
            out.println("<HTML><HEAD><TITLE>File Upload</TITLE></HEAD>");
            out.println("<BODY>One or more of these parameters are not specified in the initArgs:<BR>");
            out.println("<B>username</B><BR>");
            out.println("<B>password</B><BR>");
            out.println("<B>root</B> - the root for the uploaded files<BR>");
            out.println("</BODY></HTML>");
            out.flush();
            out.close();
            return;
        }
        String incomingPassword = null;
        String incomingUsername = null;
        String incomingDirectory = null;
        String contentType = request.getContentType();
        if (contentType.indexOf("multipart/form-data") != -1) {
            String filename = null;
            FilePostParser parser = new FilePostParser((InputStream)request.getInputStream(), request.getContentLength(), request.getCharacterEncoding());
            while (parser.hasMoreElements()) {
                Object object = parser.nextElement();
                if (object instanceof PostFileInputStream) {
                    int i;
                    if (!this.username.equals(incomingUsername) || !this.password.equals(incomingPassword)) {
                        ServletOutputStream out = response.getOutputStream();
                        out.println("<HTML><HEAD><TITLE>File Upload</TITLE></HEAD>");
                        out.println("<BODY>Incorrect username or password, try again.<BR>");
                        out.println("</BODY></HTML>");
                        out.flush();
                        out.close();
                        return;
                    }
                    filename = this.root == null ? this.getServletContext().getRealPath("/") : this.root;
                    if (incomingDirectory != null) {
                        if (incomingDirectory.indexOf("..") >= 0) {
                            throw new IOException("Illegal request");
                        }
                        if (!(filename = filename + incomingDirectory).endsWith(File.separator)) {
                            filename = filename + File.separator;
                        }
                    }
                    PostFileInputStream stream = (PostFileInputStream)object;
                    String incomingFilename = stream.getFileName();
                    incomingFilename = incomingFilename.substring(incomingFilename.lastIndexOf(92) + 1);
                    incomingFilename = incomingFilename.substring(incomingFilename.lastIndexOf(47) + 1);
                    incomingFilename = incomingFilename.substring(incomingFilename.lastIndexOf(File.separatorChar) + 1);
                    filename = filename + incomingFilename;
                    FileOutputStream fileOut = new FileOutputStream(filename);
                    byte[] buffer = new byte[64000];
                    while ((i = stream.read(buffer, 0, 64000)) != -1) {
                        fileOut.write(buffer, 0, i);
                    }
                    fileOut.close();
                    continue;
                }
                if (!(object instanceof PostEntry)) continue;
                Map.Entry entry = (Map.Entry)object;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.equals("username")) {
                    incomingUsername = value;
                    continue;
                }
                if (key.equals("password")) {
                    incomingPassword = value;
                    continue;
                }
                if (!key.equals("directory")) continue;
                incomingDirectory = value;
            }
            ServletOutputStream out = response.getOutputStream();
            out.println("<HTML><HEAD><TITLE>File Upload</TITLE></HEAD>");
            out.print("<BODY>The file has been stored in ");
            out.println(filename);
            out.println("</BODY></HTML>");
            out.flush();
            out.close();
            return;
        }
        response.getOutputStream().println("Bad request");
        response.getOutputStream().flush();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        out.println("<HTML><HEAD><TITLE>File Poster</TITLE></HEAD><BODY><FORM ACTION=\"" + HttpUtils.getRequestURL((HttpServletRequest)request) + "\" ENCTYPE=\"multipart/form-data\" METHOD=POST>" + "What is your username?<BR><INPUT TYPE=TEXT NAME=\"username\"><BR><BR>" + "What is your password?<BR><INPUT TYPE=PASSWORD NAME=\"password\"><BR><BR>" + "What directory do you want the file to appear in?<BR><INPUT TYPE=TEXT NAME=\"directory\"><BR><BR>" + "Which file are you sending?<BR><INPUT TYPE=FILE NAME=\"file\"><BR><BR>" + "<INPUT TYPE=SUBMIT VALUE=\"Transfer\">" + "</FORM>" + "</BODY>" + "</HTML>");
        out.flush();
        out.close();
    }
}

