/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JMSServlet
extends HttpServlet {
    private QueueConnection connection;
    private QueueSession session;
    private Queue queue;

    public void init() throws ServletException {
        try {
            QueueConnectionFactory factory = (QueueConnectionFactory)new InitialContext().lookup("java:comp/QueueConnectionFactory");
            this.queue = (Queue)new InitialContext().lookup("jms/DemoQueue");
            this.connection = factory.createQueueConnection();
            this.session = this.connection.createQueueSession(false, -1);
        }
        catch (NamingException e) {
            throw new ServletException("Naming error", (Throwable)e);
        }
        catch (JMSException e) {
            throw new ServletException("JMS error", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String messageString = request.getParameter("message");
            if (messageString == null) {
                messageString = "No message";
            }
            Message message = this.session.createMessage();
            message.setStringProperty("content", messageString);
            this.session.createSender(this.queue).send(message);
        }
        catch (JMSException e) {
            throw new ServletException("JMS error", (Throwable)e);
        }
    }
}

