/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.ssl;

import com.evermind.security.SecuritySensitive;
import com.evermind.ssl.JSSESSLServerSocketFactory;
import com.evermind.ssl.SSLServerSocketFactory;
import com.evermind.util.ConfigUtils;
import com.evermind.util.StringUtils;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.security.SSLMessages;
import oracle.oc4j.security.SSLUtilValues;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SSLConfig
implements XMLizable,
SSLUtilValues {
    private static Logger s_logger = TraceLogger.getLogger(SSLConfig.class);
    public static final String WALLET_FILE_EXT = ".p12";
    private static final String DEFAULT_FACTORY = JSSESSLServerSocketFactory.class.getName();
    public static final String KEYSTORE_LOC_PROP = "ssl-config.keystore";
    public static final String KEYSTORE_PASS_PROP = "ssl-config.keystore-password";
    public static final String TRUSTSTORE_LOC_PROP = "ssl-config.truststore";
    public static final String TRUSTSTORE_PASS_PROP = "ssl-config.truststore-password";
    private final Properties m_properties = new Properties();
    private final Properties m_securityProperties = new Properties();
    private final Properties m_obfuscatedProperties = new Properties();
    private final Properties m_obfuscatedSecurityProperties = new Properties();
    private String m_factoryName;
    private String m_provider;
    private String m_keyStoreType;
    private String m_keyStorePath;
    private URL m_url;
    private String m_trustStorePath;
    private String m_keyStorePassword;
    private String m_keyStorePassword_orig;
    private String m_trustStorePassword;
    private String m_trustStorePassword_orig;
    private boolean m_needClientAuth = false;
    private boolean m_wantClientAuth = false;
    private String[] m_cipherSuites;
    private boolean m_hasDecoded = false;

    public SSLConfig() {
        this.init();
    }

    public SSLConfig(URL url, Properties props) {
        this.m_factoryName = props.getProperty("ssl-config.factory");
        this.m_provider = props.getProperty("ssl-config.provider");
        this.m_keyStorePassword = props.getProperty(KEYSTORE_PASS_PROP);
        this.m_keyStorePath = props.getProperty(KEYSTORE_LOC_PROP);
        this.m_trustStorePath = props.getProperty(TRUSTSTORE_LOC_PROP);
        this.m_trustStorePassword = props.getProperty(TRUSTSTORE_PASS_PROP);
        this.m_needClientAuth = "true".equalsIgnoreCase(props.getProperty("ssl-config.needs-client-auth"));
        this.m_wantClientAuth = "true".equalsIgnoreCase(props.getProperty("ssl-config.wants-client-auth"));
        this.m_url = url;
        this.init();
    }

    public SSLConfig(String provider, String factory, String keyStorePath, String keyStorePassword, String needClientAuth) {
        this(provider, factory, keyStorePath, keyStorePassword, needClientAuth, null);
    }

    public SSLConfig(String provider, String factory, String keyStorePath, String keyStorePassword, String needClientAuth, String[] cipherSuites) {
        this.m_provider = provider;
        this.m_factoryName = factory;
        this.m_keyStorePath = keyStorePath;
        this.m_keyStorePassword = keyStorePassword;
        this.m_needClientAuth = "true".equalsIgnoreCase(needClientAuth);
        this.m_cipherSuites = cipherSuites;
        this.init();
    }

    public SSLConfig(URL url, SSLUtilValues values) {
        this.m_factoryName = values.getSocketFactory();
        this.m_provider = values.getProvider();
        this.m_keyStorePassword = values.getKeyStorePassword();
        this.m_keyStorePath = values.getKeyStoreLocation();
        this.m_trustStorePath = values.getTrustStoreLocation();
        this.m_trustStorePassword = values.getTrustStorePassword();
        this.m_needClientAuth = "true".equalsIgnoreCase(values.getNeedsClientAuth());
        this.m_url = url;
        this.init();
    }

    public SSLConfig(Node parent, URL url) throws InstantiationException {
        this.m_factoryName = XMLUtils.getNodeAttribute(parent, "factory");
        this.m_provider = XMLUtils.getNodeAttribute(parent, "provider");
        this.m_keyStorePassword = XMLUtils.getNodeAttribute(parent, "keystore-password");
        this.m_keyStorePath = XMLUtils.getNodeAttribute(parent, "keystore");
        this.m_trustStorePath = XMLUtils.getNodeAttribute(parent, "truststore");
        this.m_trustStorePassword = XMLUtils.getNodeAttribute(parent, "truststore-password");
        this.m_needClientAuth = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "needs-client-auth"));
        this.m_wantClientAuth = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "wants-client-auth"));
        this.m_cipherSuites = SSLConfig.parse(XMLUtils.getNodeAttribute(parent, "cipher-suites"));
        this.m_url = url;
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                String paramValue;
                boolean obfuscate;
                String obfuscatedValue;
                String paramName;
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("factory")) {
                    this.m_factoryName = XMLUtils.getStringValue(node);
                    continue;
                }
                if (name.equals("property")) {
                    paramName = XMLUtils.getNodeAttribute(node, "name");
                    obfuscatedValue = XMLUtils.getNodeAttribute(node, "value");
                    obfuscate = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "obfuscate"));
                    String string = paramValue = obfuscate ? SecuritySensitive.global().decode(obfuscatedValue, obfuscatedValue) : obfuscatedValue;
                    if (paramName == null) continue;
                    this.m_properties.setProperty(paramName, paramValue);
                    if (!obfuscate) continue;
                    this.m_obfuscatedProperties.setProperty(paramName, obfuscatedValue);
                    continue;
                }
                if (!name.equals("security-property")) continue;
                paramName = XMLUtils.getNodeAttribute(node, "name");
                obfuscatedValue = XMLUtils.getNodeAttribute(node, "value");
                obfuscate = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(node, "obfuscate"));
                String string = paramValue = obfuscate ? SecuritySensitive.global().decode(obfuscatedValue, obfuscatedValue) : obfuscatedValue;
                if (paramName == null) continue;
                this.m_securityProperties.setProperty(paramName, paramValue);
                if (!obfuscate) continue;
                this.m_obfuscatedSecurityProperties.setProperty(paramName, obfuscatedValue);
            }
        }
        this.init();
    }

    private void init() {
        this.establishFactoryName();
        this.establishSensitiveValues();
        this.establishKeyStoreTypeAndProviderNames();
    }

    private static String[] parse(String commaDelimArr) {
        if (null == commaDelimArr) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(commaDelimArr, ", ");
        if (t.countTokens() <= 0) {
            return null;
        }
        String[] result = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            result[i] = t.nextToken();
            ++i;
        }
        return result;
    }

    public static String concat(String[] arr) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            if (buff.length() > 0) {
                buff.append(",");
            }
            buff.append(arr[i]);
        }
        return buff.toString();
    }

    private void establishKeyStoreTypeAndProviderNames() {
        if (null != this.m_keyStoreType) {
            return;
        }
        if (OC4JSSLSocketFactory.isWalletFileType(this.m_keyStorePath, this.m_trustStorePath)) {
            this.m_keyStoreType = "PKCS12";
            if (null == this.m_provider) {
                this.m_provider = "oracle.security.pki.OraclePKIProvider";
            }
            try {
                this.m_provider = OC4JSSLSocketFactory.createSecurityProvider(this.m_provider).getName();
            }
            catch (IOException e) {
                SSLConfig.getTraceLogger().throwing(this.getClass().getName(), "establishKeyStoreTypeAndProviderNames", e);
            }
        } else {
            this.m_keyStoreType = KeyStore.getDefaultType();
        }
    }

    boolean hasDecoded() {
        return this.m_hasDecoded;
    }

    void verifyCanEstablishSensitiveValues() throws IOException {
        if (!this.hasDecoded() && null == SecuritySensitive.global()) {
            throw new IOException("invalid state");
        }
        if (!this.hasDecoded()) {
            this.establishSensitiveValues();
        }
    }

    private synchronized void establishSensitiveValues() {
        if (!this.hasDecoded() && null != SecuritySensitive.global()) {
            if (null != this.m_keyStorePassword) {
                this.m_keyStorePassword_orig = this.m_keyStorePassword;
                this.m_keyStorePassword = SecuritySensitive.global().decode(this.m_keyStorePassword, this.m_keyStorePassword);
            }
            if (null != this.m_trustStorePassword) {
                this.m_trustStorePassword_orig = this.m_trustStorePassword;
                this.m_trustStorePassword = SecuritySensitive.global().decode(this.m_trustStorePassword, this.m_trustStorePassword);
            }
            this.m_hasDecoded = true;
        }
    }

    private void establishFactoryName() {
        if (this.m_factoryName == null || this.m_factoryName.length() == 0) {
            this.m_factoryName = DEFAULT_FACTORY;
        }
    }

    public static Logger getTraceLogger() {
        return s_logger;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.print(indention + "<ssl-config");
        if (this.m_factoryName != null) {
            out.print(" factory=\"" + SSLConfig.encode(this.m_factoryName) + "\"");
        }
        if (this.m_provider != null) {
            out.print(" provider=\"" + SSLConfig.encode(this.m_provider) + "\"");
        }
        if (this.m_keyStorePath != null) {
            out.print(" keystore=\"" + SSLConfig.encode(this.m_keyStorePath) + "\"");
        }
        if (this.m_keyStorePassword != null || this.m_keyStorePassword_orig != null) {
            out.print(" keystore-password=\"" + SSLConfig.encode(null == this.m_keyStorePassword_orig ? this.m_keyStorePassword : this.m_keyStorePassword_orig) + "\"");
        }
        if (this.m_trustStorePath != null) {
            out.print(" truststore=\"" + SSLConfig.encode(this.m_trustStorePath) + "\"");
        }
        if (this.m_keyStorePassword != null || this.m_trustStorePassword_orig != null) {
            out.print(" truststore-password=\"" + SSLConfig.encode(null == this.m_trustStorePassword_orig ? this.m_trustStorePassword : this.m_trustStorePassword_orig) + "\"");
        }
        if (this.m_needClientAuth) {
            out.print(" needs-client-auth=\"true\"");
        }
        if (this.m_wantClientAuth) {
            out.print(" wants-client-auth=\"true\"");
        }
        if (null != this.m_cipherSuites && this.m_cipherSuites.length > 0) {
            out.print(" cipher-suites=\"" + SSLConfig.encode(SSLConfig.concat(this.m_cipherSuites)) + "\"");
        }
        if (this.m_properties.isEmpty() && this.m_securityProperties.isEmpty()) {
            out.println("/>");
            return;
        }
        out.println(">");
        this.writeProperties(out, indention, "property", this.m_properties, this.m_obfuscatedProperties);
        this.writeProperties(out, indention, "security-property", this.m_securityProperties, this.m_obfuscatedSecurityProperties);
        out.println(indention + "</ssl-config>");
    }

    protected static String encode(String val) {
        val = XMLUtils.encode(val);
        val = StringUtils.replace(val, "-&gt;", "->");
        return val;
    }

    private void writeProperties(PrintWriter out, String indention, String tag, Properties properties, Properties obfuscatedProperties) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String paramName = (String)entry.getKey();
            String obfuscatedValue = obfuscatedProperties.getProperty(paramName);
            String paramValue = obfuscatedValue == null ? properties.getProperty(paramName) : obfuscatedValue;
            paramValue = (String)entry.getValue();
            out.println(indention + "\t<" + tag + " name=\"" + SSLConfig.encode(paramName) + "\" value=\"" + SSLConfig.encode(paramValue) + "\"");
            if (obfuscatedValue != null) {
                out.print(" obfuscate=\"true\"");
            }
            out.println("/>");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerSocket createServerSocket(ClassLoader loader, InetAddress address, int port, int backlog) throws IOException {
        ServerSocket serverSocket;
        SSLMessages.logGetSecureSocket(address, port, backlog);
        InputStream keyStoreIn = this.getStoreIn(this.m_keyStorePath);
        InputStream trustStoreIn = this.getStoreIn(this.m_trustStorePath);
        try {
            try {
                serverSocket = this.createServerSocket(loader, address, port, backlog, keyStoreIn, trustStoreIn);
                Object var9_9 = null;
            }
            catch (Throwable e) {
                SSLConfig.getTraceLogger().throwing(this.getClass().getName(), "createServerSocket", e);
                throw new IOException("Unable to intialize SSLConfig '" + this.getSocketFactory() + "': " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (keyStoreIn != null) {
                    keyStoreIn.close();
                }
                if (trustStoreIn == null) throw throwable;
                trustStoreIn.close();
                throw throwable;
            }
            catch (IOException e2) {
                SSLConfig.getTraceLogger().log(Level.WARNING, "Failed to close keystore: {0}", e2.getMessage());
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            SSLConfig.getTraceLogger().log(Level.WARNING, "Failed to close keystore: {0}", e2.getMessage());
            return serverSocket;
        }
        if (keyStoreIn != null) {
            keyStoreIn.close();
        }
        if (trustStoreIn == null) return serverSocket;
        trustStoreIn.close();
        return serverSocket;
    }

    private InputStream getStoreIn(String fileName) throws IOException {
        if (null == fileName) {
            return null;
        }
        if (null != this.m_url) {
            URL url = ConfigUtils.getURL(this.m_url, fileName);
            SSLMessages.logReadingKeystore(url.toString());
            return new FileInputStream(url.getFile());
        }
        return OC4JSSLSocketFactory.getStoreIn(fileName);
    }

    private ServerSocket createServerSocket(ClassLoader loader, InetAddress address, int port, int backlog, InputStream keyStoreIn, InputStream trustStoreIn) throws IOException {
        this.verifyCanEstablishSensitiveValues();
        try {
            SSLServerSocketFactory factory = this.loadFactory(loader);
            return factory.createServerSocket(port, backlog, address, this.m_provider, this.m_keyStoreType, null, this.m_securityProperties, this.m_properties, keyStoreIn, null == this.m_keyStorePassword ? null : this.m_keyStorePassword.toCharArray(), trustStoreIn, null == this.m_trustStorePassword ? null : this.m_trustStorePassword.toCharArray(), this.m_needClientAuth, this.m_wantClientAuth, this.m_cipherSuites);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new IOException(iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IOException(ie.getMessage());
        }
    }

    private SSLServerSocketFactory loadFactory(ClassLoader loader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        SSLServerSocketFactory factory = null == loader ? (SSLServerSocketFactory)Class.forName(this.getSocketFactory()).newInstance() : (SSLServerSocketFactory)Class.forName(this.getSocketFactory(), true, loader).newInstance();
        return factory;
    }

    public String getRealKeyStorePath() throws IOException {
        if (this.m_keyStorePath != null) {
            if (this.m_url != null) {
                URL url;
                try {
                    url = ConfigUtils.getURL(this.m_url, this.m_keyStorePath);
                }
                catch (MalformedURLException e) {
                    IOException ioe = new IOException("SSL setup failure");
                    ioe.initCause(e);
                    throw ioe;
                }
                SSLMessages.logReadingKeystore(url.toString());
                return url.getFile();
            }
            return this.m_keyStorePath;
        }
        throw new IOException("SSL setup failure: empty key store path");
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void setKeyStorePath(String p_szKSPath) {
        this.m_keyStorePath = p_szKSPath;
    }

    public void setFactoryName(String p_szFact) {
        this.m_factoryName = p_szFact;
    }

    public String getKeyStorePath() {
        return this.m_keyStorePath;
    }

    public String[] getCipherSuites() {
        return this.m_cipherSuites;
    }

    public String getStoreType() {
        return this.m_keyStoreType;
    }

    public String getKeyStoreLocation() {
        return this.m_keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.m_keyStorePassword;
    }

    public String getTrustStoreLocation() {
        return this.m_trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.m_trustStorePassword;
    }

    public String getNeedsClientAuth() {
        return String.valueOf(this.m_needClientAuth);
    }

    public String getProvider() {
        return this.m_provider;
    }

    public String getSocketFactory() {
        return this.m_factoryName;
    }
}

