/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ArrayUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class CharString
implements Serializable,
Comparable,
Cloneable {
    public char[] data;
    public int offset;
    public int length;

    public CharString() {
    }

    public CharString(byte[] data, int offset, int length, String encoding) throws UnsupportedEncodingException {
        if (encoding == null || encoding.equalsIgnoreCase("iso-8859-1")) {
            this.data = new char[length];
            for (int i = 0; i < length; ++i) {
                this.data[i] = (char)((char)data[offset + i] & 0xFF);
            }
            this.offset = 0;
            this.length = length;
        } else {
            String string = new String(data, offset, length, encoding);
            this.data = string.toCharArray();
            this.length = this.data.length;
        }
    }

    public CharString(int size) {
        this.data = new char[size];
    }

    public CharString(char b) {
        this.data = new char[1];
        this.data[0] = b;
        this.length = 1;
    }

    public char[] toCharArray() {
        if (this.offset == 0 && this.length == this.data.length) {
            return this.data;
        }
        char[] chars = new char[this.length];
        System.arraycopy(this.data, this.offset, chars, 0, this.length);
        return chars;
    }

    public CharString(char[] data) {
        this.data = data;
        this.length = data.length;
    }

    public CharString(char[] data, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > data.length) {
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException("offset was below zero: " + offset);
            }
            if (length < 0) {
                throw new StringIndexOutOfBoundsException("length was below zero: " + length);
            }
            if (offset + length < 0) {
                throw new StringIndexOutOfBoundsException(String.valueOf(offset + length));
            }
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public CharString(String string) {
        this(string.toCharArray());
    }

    public int compareTo(CharString other) {
        int length = other.length > this.length ? this.length : other.length;
        for (int i = 0; i < length; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            return this.data[this.offset + i] - other.data[other.offset + i];
        }
        if (this.length == other.length) {
            return 0;
        }
        return this.length - other.length;
    }

    public int compareTo(Object object) {
        if (object instanceof CharString) {
            return this.compareTo((CharString)object);
        }
        return this.compareTo(new CharString((String)object));
    }

    public CharString substring(int index) {
        if (index == 0) {
            return this;
        }
        if (index > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        return new CharString(this.data, this.offset + index, this.length - index);
    }

    public CharString substring(int index, int endIndex) {
        if (index == 0 && endIndex == this.length) {
            return this;
        }
        if (index > this.length || endIndex > this.length || index > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        return new CharString(this.data, this.offset + index, endIndex - index);
    }

    public CharString concat(CharString other) {
        char[] newData = new char[this.length + other.length];
        System.arraycopy(this.data, this.offset, newData, 0, this.length);
        System.arraycopy(other.data, other.offset, newData, this.length, other.length);
        return new CharString(newData);
    }

    public boolean equals(String other) {
        if (other.length() == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (this.data[this.offset + i] == other.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(String other) {
        if (other.length() == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (Character.toLowerCase(this.data[this.offset + i]) == Character.toLowerCase(other.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object otherGeneric) {
        if (!(otherGeneric instanceof CharString)) {
            return false;
        }
        CharString other = (CharString)otherGeneric;
        int length = this.length;
        if (length != other.length) {
            return false;
        }
        char[] data = this.data;
        char[] otherData = other.data;
        int offset = this.offset;
        int otherOffset = other.offset - offset;
        length += offset;
        for (int i = offset; i < length; ++i) {
            if (data[i] == otherData[otherOffset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Object otherGeneric) {
        if (!(otherGeneric instanceof CharString)) {
            return false;
        }
        CharString other = (CharString)otherGeneric;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            char a = this.data[this.offset + i];
            char b = other.data[other.offset + i];
            if (a >= 'A' && a <= 'Z') {
                a = (char)(a + 32);
            }
            if (b >= 'A' && b <= 'Z') {
                b = (char)(b + 32);
            }
            if (a == b) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        char[] newData = new char[this.length];
        System.arraycopy(this.data, this.offset, newData, 0, this.length);
        return new CharString(newData);
    }

    public int hashCode() {
        int hashCode = 0;
        int offset = this.offset;
        char[] data = this.data;
        int length = this.length;
        for (int i = 0; i < length; i += 3) {
            hashCode = 31 * hashCode + data[offset++];
        }
        return hashCode;
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.length; ++i) {
            if (this.data[this.offset + i] != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char c, int startIndex) {
        while (startIndex < this.length) {
            if (this.data[this.offset + startIndex] == c) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.data[this.offset + i] != c) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c, int startIndex) {
        while (startIndex >= 0) {
            if (this.data[this.offset + startIndex] == c) {
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    public int indexOf(CharString other) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return 0;
        }
        for (int i = 0; i < length; ++i) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + i + x] != other.data[other.offset + x]) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(CharString other, int startIndex) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return 0;
        }
        while (startIndex < length) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + startIndex + x] != other.data[other.offset + x]) continue;
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public int lastIndexOf(CharString other) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return this.length - 1;
        }
        for (int i = length; i >= 0; --i) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + i + x] != other.data[other.offset + x]) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(CharString other, int startIndex) {
        int length = this.length - other.length;
        if (length < 0) {
            return -1;
        }
        if (other.length == 0) {
            return startIndex;
        }
        while (startIndex >= 0) {
            for (int x = 0; x < other.length; ++x) {
                if (this.data[this.offset + startIndex + x] != other.data[other.offset + x]) continue;
                return startIndex;
            }
            --startIndex;
        }
        return -1;
    }

    public CharString replace(char c, char newC) {
        if (c == newC) {
            return this;
        }
        int length = this.length;
        char[] data = this.data;
        char[] newData = new char[length];
        int offset = this.offset;
        int i = 0;
        while (i < length) {
            newData[i] = data[offset] == c ? newC : data[offset];
            ++i;
            ++offset;
        }
        return new CharString(newData);
    }

    public int length() {
        return this.length;
    }

    public CharString toLowerCase() {
        return ((CharString)this.clone()).makeLowerCase();
    }

    public CharString makeLowerCase() {
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] < 'A' || this.data[i] > 'Z') continue;
            int n = i;
            this.data[n] = (char)(this.data[n] + 32);
        }
        return this;
    }

    public CharString toUpperCase() {
        return ((CharString)this.clone()).makeUpperCase();
    }

    public CharString makeUpperCase() {
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (this.data[i] < 'a' || this.data[i] > 'z') continue;
            int n = i;
            this.data[n] = (char)(this.data[n] + -32);
        }
        return this;
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.length) {
            throw new StringIndexOutOfBoundsException(i);
        }
        return this.data[this.offset + i];
    }

    public boolean startsWith(CharString other) {
        if (other.length > this.length) {
            return false;
        }
        for (int i = 0; i < other.length; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String other) {
        int otherLength = other.length();
        if (otherLength > this.length) {
            return false;
        }
        for (int i = 0; i < otherLength; ++i) {
            if (this.data[this.offset + i] == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(CharString other) {
        if (other.length > this.length) {
            return false;
        }
        int diff = this.length - other.length + this.offset;
        for (int i = 0; i < other.length; ++i) {
            if (this.data[diff + i] == other.data[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public CharString concat(char c) {
        char[] newData = new char[this.length + 1];
        System.arraycopy(this.data, this.offset, newData, 0, this.length);
        newData[this.length] = 47;
        return new CharString(newData, 0, newData.length);
    }

    public CharString trim() {
        int length;
        int offset = this.offset;
        for (length = this.length; length > 0 && this.data[offset] == ' '; --length) {
            ++offset;
        }
        while (length > 0 && this.data[offset + length - 1] == ' ') {
            --length;
        }
        if (offset == this.offset && length == this.length) {
            return this;
        }
        return new CharString(this.data, offset, length);
    }

    public String toString() {
        return new String(this.data, this.offset, this.length);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEnd() {
        return this.offset + this.length;
    }

    public void append(CharString other) {
        this.assureSize(this.offset + this.length + other.length);
        System.arraycopy(other.data, other.offset, this.data, this.offset + this.length, other.length);
        this.length += other.length;
    }

    public void append(String other) {
        int otherLength = other.length();
        this.assureSize(this.offset + this.length + otherLength);
        int pos = this.offset + this.length;
        for (int i = 0; i < otherLength; ++i) {
            this.data[pos++] = other.charAt(i);
        }
        this.length += otherLength;
    }

    public void append(char c) {
        this.assureSize(this.offset + this.length + 1);
        this.data[this.offset + this.length++] = c;
    }

    public void append(int i) {
        this.assureSize(this.offset + this.length + 20);
        this.length = ArrayUtils.writeInt(this.data, this.offset + this.length, i) - this.offset;
    }

    private void assureSize(int size) {
        while (this.data.length < size) {
            char[] newData = new char[this.data.length * 4];
            System.arraycopy(this.data, this.offset, newData, 0, this.length);
            this.data = newData;
            this.offset = 0;
        }
    }

    public void replace(int pos, int end, CharString newContent) {
        int diff = newContent.length - (end - pos);
        if (diff > 0) {
            this.assureSize(this.offset + this.length + diff);
        }
        System.arraycopy(this.data, this.offset + end, this.data, this.offset + pos + newContent.length, this.length - end);
        System.arraycopy(newContent.data, newContent.offset, this.data, this.offset + pos, newContent.length);
        this.length += diff;
    }

    public void insert(int pos, CharString value) {
        this.assureSize(this.offset + this.length + value.length);
        System.arraycopy(this.data, this.offset + pos, this.data, this.offset + pos + value.length, this.length - pos);
        System.arraycopy(value.data, value.offset, this.data, this.offset + pos, value.length);
        this.length += value.length;
    }
}

