/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ExternalComparator;
import com.evermind.util.LinkedEntry;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ExternalHashMap
extends AbstractMap
implements Serializable {
    private LinkedEntry[] entries;
    private ExternalComparator comparator;
    private int size;
    private final float loadFactor = 2.0f;

    public ExternalHashMap() {
        this(ExternalComparator.DEFAULT_COMPARATOR);
    }

    public ExternalHashMap(ExternalComparator comparator) {
        this.comparator = comparator;
        this.entries = new LinkedEntry[100];
    }

    public Set entrySet() {
        return new ExternalHashMapEntrySet();
    }

    public Object get(Object key) {
        int hashCode = this.comparator.hashCode(key);
        int pos = (hashCode & Integer.MAX_VALUE) % this.entries.length;
        LinkedEntry entry = this.entries[pos];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.comparator.equals(key, entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int hashCode = this.comparator.hashCode(key);
        int pos = (hashCode & Integer.MAX_VALUE) % this.entries.length;
        LinkedEntry entry = this.entries[pos];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.comparator.equals(entry.key, key)) {
                Object previousValue = entry.value;
                entry.value = value;
                return previousValue;
            }
            entry = entry.next;
        }
        ++this.size;
        this.entries[pos] = new LinkedEntry(key, value, hashCode, this.entries[pos]);
        if (this.size > this.entries.length) {
            this.setHashSize((int)((float)this.size * 2.0f));
        }
        return null;
    }

    public Object remove(Object key) {
        int hashCode = this.comparator.hashCode(key);
        int pos = (hashCode & Integer.MAX_VALUE) % this.entries.length;
        if (this.entries[pos] != null) {
            LinkedEntry previousEntry = null;
            LinkedEntry entry = this.entries[pos];
            do {
                if (entry.hashCode == hashCode && this.comparator.equals(entry.key, key)) {
                    --this.size;
                    if (previousEntry != null) {
                        previousEntry.next = entry.next;
                    } else {
                        this.entries[pos] = entry.next;
                    }
                    return entry.value;
                }
                previousEntry = entry;
            } while ((entry = entry.next) != null);
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void setHashSize(int length) {
        if (length == this.entries.length) {
            return;
        }
        if (length < 1) {
            throw new IllegalArgumentException("Invalid length");
        }
        LinkedEntry[] entries = this.entries;
        LinkedEntry[] newEntries = new LinkedEntry[length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            LinkedEntry next = entries[i];
            while (next != null) {
                LinkedEntry entry = next;
                next = entry.next;
                int pos = (entry.hashCode & Integer.MAX_VALUE) % length;
                entry.next = newEntries[pos];
                newEntries[pos] = entry;
            }
        }
        this.entries = newEntries;
    }

    public class ExternalHashMapEntrySet
    extends AbstractSet {
        public Iterator iterator() {
            return new ExternalHashMapEntrySetIterator();
        }

        public int size() {
            return ExternalHashMap.this.size;
        }
    }

    public class ExternalHashMapEntrySetIterator
    implements Iterator {
        private int pos;
        private LinkedEntry previousEntry;
        private LinkedEntry entry;

        public ExternalHashMapEntrySetIterator() {
            if (ExternalHashMap.this.entries[0] != null) {
                this.entry = ExternalHashMap.this.entries[0];
            } else {
                this.getNextEntry();
            }
        }

        public Object next() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            LinkedEntry entry = this.entry;
            this.getNextEntry();
            return entry;
        }

        public void remove() {
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            if (this.previousEntry != null && this.previousEntry.next == this.entry) {
                this.previousEntry.next = this.entry.next;
                this.entry = this.previousEntry;
                this.getNextEntry();
            } else {
                ((ExternalHashMap)ExternalHashMap.this).entries[this.pos] = null;
                this.getNextEntry();
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        private void getNextEntry() {
            this.previousEntry = this.entry;
            if (this.entry != null && this.entry.next != null) {
                this.entry = this.entry.next;
                return;
            }
            do {
                if (++this.pos < ExternalHashMap.this.entries.length) continue;
                this.entry = null;
                return;
            } while (ExternalHashMap.this.entries[this.pos] == null);
            this.entry = ExternalHashMap.this.entries[this.pos];
        }
    }
}

