/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class FallbackResourceBundle {
    private ResourceBundle bundle;
    private ResourceBundle fallback;
    private Set bundleKeys;
    private boolean returnResourceNameIfNotFound;

    public FallbackResourceBundle(ResourceBundle bundle, ResourceBundle fallback) {
        this(bundle, fallback, false);
    }

    public FallbackResourceBundle(ResourceBundle bundle, ResourceBundle fallback, boolean returnResourceNameIfNotFound) {
        this.bundle = bundle;
        this.fallback = fallback;
        this.returnResourceNameIfNotFound = returnResourceNameIfNotFound;
    }

    public String getString(String name) {
        return this.getResource(name);
    }

    public String getResource(String name) {
        if (this.bundle == this.fallback) {
            try {
                return this.bundle.getString(name);
            }
            catch (MissingResourceException e) {
                if (this.returnResourceNameIfNotFound) {
                    return name;
                }
                throw e;
            }
        }
        if (this.bundleKeys == null) {
            HashSet<String> bundleKeys = new HashSet<String>();
            Enumeration<String> enumeration = this.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                bundleKeys.add(enumeration.nextElement());
            }
            this.bundleKeys = bundleKeys;
        }
        if (this.bundleKeys.contains(name)) {
            return this.bundle.getString(name);
        }
        try {
            return this.fallback.getString(name);
        }
        catch (MissingResourceException e) {
            if (this.returnResourceNameIfNotFound) {
                return name;
            }
            throw e;
        }
    }

    public static FallbackResourceBundle getBundle(String name) {
        return FallbackResourceBundle.getBundle(name, false);
    }

    public static FallbackResourceBundle getBundle(String name, boolean returnNameIfNotFound) {
        ResourceBundle bundle = ResourceBundle.getBundle(name);
        ResourceBundle fallback = ResourceBundle.getBundle(name, new Locale("zz", "ZZ"));
        return new FallbackResourceBundle(bundle, fallback, returnNameIfNotFound);
    }

    public static FallbackResourceBundle getBundle(String name, ClassLoader loader) {
        return FallbackResourceBundle.getBundle(name, loader, false);
    }

    public static FallbackResourceBundle getBundle(String name, ClassLoader loader, boolean returnNameIfNotFound) {
        ResourceBundle bundle = ResourceBundle.getBundle(name, Locale.getDefault(), loader);
        ResourceBundle fallback = ResourceBundle.getBundle(name, new Locale("zz", "ZZ"), loader);
        return new FallbackResourceBundle(bundle, fallback, returnNameIfNotFound);
    }
}

