/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.server.ApplicationServer;
import com.evermind.util.RotatedFile;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class SystemStreamRotater {
    private static boolean isShared = false;
    private static RotatedFile outFile;
    private static RotatedFile errFile;
    private static PrintStream currentOutPS;
    private static PrintStream currentErrPS;
    public static final boolean isRotatable;

    public static void rotate() {
        if (outFile != null && outFile.isLimit()) {
            SystemStreamRotater.resetStream(true, false);
        }
        if (!isShared && errFile != null && errFile.isLimit()) {
            SystemStreamRotater.resetStream(false, true);
        }
    }

    private static void resetStream(boolean isOut, boolean isErr) {
        PrintStream out = null;
        PrintStream err = null;
        PrintStream oldOut = currentOutPS;
        PrintStream oldErr = currentErrPS;
        if (isOut) {
            try {
                out = SystemStreamRotater.getNewOutPS();
            }
            catch (IOException e) {
                System.err.println("[stdout/err rotation] Error on getting new stdout file : " + outFile != null ? outFile.getBaseFile().getPath() : " : " + e.getMessage());
            }
        }
        if (isErr) {
            try {
                err = SystemStreamRotater.getNewErrPS();
            }
            catch (IOException e) {
                System.err.println("[stdout/err rotation] Error on getting new stderr file : " + errFile != null ? errFile.getBaseFile().getPath() : " : " + e.getMessage());
            }
        }
        if (isShared) {
            ApplicationServer.resetCoreSystemStream(out, out);
        } else {
            ApplicationServer.resetCoreSystemStream(out, err);
        }
        if (out != null && oldOut != null) {
            oldOut.close();
        }
        if (err != null && oldErr != null) {
            oldErr.close();
        }
    }

    public static void setOutFile(String filePath) {
        outFile = new RotatedFile(filePath);
    }

    public static void setErrFile(String filePath) {
        errFile = new RotatedFile(filePath);
    }

    private static String getNewOutFile() throws IOException {
        if (outFile != null) {
            return outFile.getNewFile().getCanonicalPath();
        }
        return null;
    }

    private static String getNewErrFile() throws IOException {
        if (errFile != null) {
            return errFile.getNewFile().getCanonicalPath();
        }
        return null;
    }

    public static PrintStream getNewOutPS() throws IOException {
        currentOutPS = new PrintStream(new FileOutputStream(SystemStreamRotater.getNewOutFile(), true));
        return currentOutPS;
    }

    public static PrintStream getNewErrPS() throws IOException {
        currentErrPS = new PrintStream(new FileOutputStream(SystemStreamRotater.getNewErrFile(), true));
        return currentErrPS;
    }

    public static boolean isShared() {
        return isShared;
    }

    public static void setShared(boolean b) {
        isShared = b;
    }

    static {
        isRotatable = RotatedFile.isRotatable();
    }
}

