/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.oc4j.common.CommonThreadState;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class JavaxXMLUtils {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    JavaxXMLUtils() {
    }

    static Document getJavaxDocument(InputSource source, ErrorHandler handler, EntityResolver resolver, boolean validate) throws InstantiationException, IOException, SAXException {
        try {
            DocumentBuilderFactory factory = JavaxXMLUtils.getFactory();
            factory.setValidating(validate);
            factory.setNamespaceAware(true);
            factory.setIgnoringElementContentWhitespace(true);
            if (validate) {
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (resolver != null) {
                builder.setEntityResolver(resolver);
            }
            if (handler != null) {
                builder.setErrorHandler(handler);
            }
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new InstantiationException("Invalid parser configuration: " + e.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new InstantiationException("Underlying parser implementation doesn't recognize the attribute to support w3 schemas");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilderFactory getFactory() {
        try {
            return DocumentBuilderFactory.newInstance();
        }
        catch (FactoryConfigurationError e) {
            Object context;
            CommonThreadState state = CommonThreadState.getCurrent();
            if (state != null && (context = state.setSystemContext()) != null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    return documentBuilderFactory;
                }
                finally {
                    state.restoreContext(context);
                }
            }
            throw e;
        }
    }
}

