/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks;

import com.oracle.bricks.Local;
import com.oracle.bricks.Manager;
import com.oracle.bricks.Replica;
import com.oracle.jgroups.ChannelAdapter;
import com.oracle.jgroups.ObjectMarshaller;
import com.oracle.jgroups.TestAndWaitLock;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.util.Promise;

public abstract class LocalObject
implements Local {
    private Address owner;
    protected final Serializable id;
    private List replicas;
    protected final TestAndWaitLock stateChangeSync = new TestAndWaitLock();
    protected ChannelAdapter adapter;
    protected Promise dropPromise = new Promise();
    private static Logger m_logger = ClusteringTraceLogger.getTraceLogger(LocalObject.class);

    protected LocalObject(Serializable id) {
        this.id = id;
        this.stateChangeSync.setName("State Change Sync " + id);
    }

    protected LocalObject(Replica replica) {
        this(replica.getId());
        this.replicas = replica.getReplicas();
        this.owner = replica.getOwner();
    }

    protected final void initialize(Address owner, List replicaWriteSet, ChannelAdapter adapter) throws Exception {
        this.owner = owner;
        this.replicas = replicaWriteSet;
        this.adapter = adapter;
        adapter.broadcast(this.replicas, new Manager.AddReplica(this.getReplica(owner)), false);
    }

    public Serializable getId() {
        return this.id;
    }

    public Address getOwner() {
        return this.owner;
    }

    protected void ownedBy(Address newOwner, ChannelAdapter adapter) throws ChannelException {
        this.ownedBy(newOwner, adapter, -1L);
    }

    protected void ownedBy(Address newOwner, ChannelAdapter adapter, long timeout) throws ChannelException {
        Address oldOwner = this.owner;
        this.owner = newOwner;
        this.adapter = adapter;
        this.replicas.remove(newOwner);
        if (oldOwner != null) {
            this.sendDropLocalMessage(adapter, oldOwner, newOwner, timeout);
        } else if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "oldOwner is null for id: " + this.id, new Throwable().fillInStackTrace());
        }
    }

    Address sendDropLocalMessage(ChannelAdapter adapter, Address oldOwner, Address newOwner, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        Address previousOwner = null;
        adapter.send(oldOwner, new Manager.DropLocal(this.id, newOwner));
        if (timeout >= 0L) {
            previousOwner = (Address)this.dropPromise.getResult(timeout);
        }
        return previousOwner;
    }

    protected void handleDropResponse(Address oldOwner) {
        this.dropPromise.setResult((Object)oldOwner);
    }

    protected void remove() throws InterruptedException {
        this.broadcastRemoveReplicaMessage(this.replicas);
        this.disconnect();
    }

    protected void broadcastRemoveReplicaMessage(List recipients) throws InterruptedException {
        this.adapter.broadcast(recipients, new Manager.RemoveReplica(this.id), true);
    }

    protected void disconnect() {
        this.adapter = null;
        this.owner = null;
    }

    protected List getReplicas() {
        return this.replicas;
    }

    protected boolean hasReplicas() {
        return this.replicas.isEmpty();
    }

    protected void send(Replica.Message message) throws InterruptedException {
        if (this.adapter != null) {
            this.adapter.broadcast(this.replicas, message, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void rebalance(List newMembers, List previousMembers) {
        try {
            Object object = this.stateChangeSync.freeze();
            synchronized (object) {
                try {
                    if (newMembers.size() != 0) {
                        this.adapter.broadcast(newMembers, new Manager.AddReplica(this.getReplica(this.owner)), false);
                    }
                    this.adapter.broadcast(previousMembers, new Replica.UpdateWriteSet(this.id, this.replicas, this.owner), false);
                }
                finally {
                    this.stateChangeSync.thaw();
                }
            }
        }
        catch (Exception e) {
            if (m_logger.isLoggable(Level.WARNING)) {
                m_logger.log(Level.WARNING, "Cannot replicate state: ", e);
            }
            throw new IllegalStateException("Cannot replicate state: " + e);
        }
    }

    public boolean isDisconnected() {
        return this.adapter == null;
    }

    protected abstract Replica getReplica(Address var1) throws Exception;

    public abstract void dropped();

    public abstract Local getFacade();

    protected void acknowledgeUpdate(int ackSeqNo, Address sender) {
    }

    protected Serializable deSerializeAttribute(Object obj) throws Exception {
        return (Serializable)this.adapter.getMarshaller().bytesToSerializable((byte[])obj);
    }

    protected void deSerializeMap(HashMap hMap) {
        Iterator i = hMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object o = entry.getValue();
            if (!ObjectMarshaller.isMarshalled(o)) continue;
            try {
                Serializable v = this.deSerializeAttribute(o);
                entry.setValue(v);
            }
            catch (Throwable t) {
                if (!m_logger.isLoggable(Level.FINEST)) continue;
                m_logger.log(Level.FINEST, "Cannot deserialize attribute: " + entry.getKey(), t);
            }
        }
    }
}

