/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks;

import com.evermind.server.ApplicationConfig;
import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.rmi.RMIServer;
import com.evermind.server.rmi.RMIServerConfig;
import com.oracle.bricks.Manager;
import com.oracle.bricks.ManagerPrototypeIntf;
import com.oracle.bricks.ManagerPrototypeNotFoundException;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.bricks.j2ee.SessionManager;
import com.oracle.bricks.j2ee.SessionManagerPrototypeImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.ChannelException;

public class SessionManagerFactory {
    private static final Logger m_logger = ClusteringTraceLogger.getTraceLogger(SessionManagerFactory.class);
    private static final WeakHashMap namedManagers = new WeakHashMap(5);
    protected static Hashtable localRmiInfo = null;
    private static final Hashtable factories = new Hashtable();

    private static void initDefaultPrototypes() {
        SessionManagerPrototypeImpl j2eePrototype = SessionManagerPrototypeImpl.getInstance();
        SessionManagerFactory.register("j2ee", j2eePrototype);
    }

    public static ManagerPrototypeIntf register(String type, ManagerPrototypeIntf prototype) {
        ManagerPrototypeIntf mProto = factories.put(type, prototype);
        if (mProto != null && m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Previous " + mProto + " replaced by: " + prototype + " for type: " + type);
        }
        return mProto;
    }

    public static ManagerPrototypeIntf unregister(String type) {
        return (ManagerPrototypeIntf)factories.remove(type);
    }

    public static SessionManager create(ApplicationConfig config) throws ChannelException {
        JGroupConfig jConfig = config.getClusterConfig();
        return SessionManagerFactory.create(jConfig);
    }

    public static SessionManager create(HttpApplicationConfig config) throws ChannelException {
        JGroupConfig jConfig = config.getClusterConfig();
        return SessionManagerFactory.create(jConfig);
    }

    public static SessionManager create(JGroupConfig jConfig) throws ChannelException {
        try {
            return (SessionManager)SessionManagerFactory.getManager("j2ee", jConfig);
        }
        catch (ManagerPrototypeNotFoundException e) {
            return null;
        }
    }

    public static Manager create(String type, JGroupConfig jConfig) throws ChannelException, ManagerPrototypeNotFoundException {
        return SessionManagerFactory.getManager(type, jConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manager getManager(String type, JGroupConfig jConfig) throws ChannelException, ManagerPrototypeNotFoundException {
        Manager manager = null;
        WeakHashMap weakHashMap = namedManagers;
        synchronized (weakHashMap) {
            manager = (Manager)namedManagers.get(jConfig.getGroupName());
            if (manager != null) {
                if (!manager.isStarted()) {
                    manager.start();
                }
                return manager;
            }
            manager = SessionManagerFactory.createManager(type, jConfig);
            manager.setColocated(jConfig.allowColocation());
            SessionManagerFactory.initLocalRmiInfo(manager);
            namedManagers.put(jConfig.getGroupName(), manager);
        }
        return manager;
    }

    private static Manager createManager(String type, JGroupConfig jConfig) throws ChannelException, ManagerPrototypeNotFoundException {
        ManagerPrototypeIntf prototype = SessionManagerFactory.getManagerPrototype(type);
        if (prototype == null) {
            throw new ManagerPrototypeNotFoundException(type + " not registered");
        }
        return prototype.create(jConfig);
    }

    protected static ManagerPrototypeIntf getManagerPrototype(String type) {
        ManagerPrototypeIntf prototype = (ManagerPrototypeIntf)factories.get(type);
        return prototype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager getManager(String groupName) {
        Object obj = null;
        WeakHashMap weakHashMap = namedManagers;
        synchronized (weakHashMap) {
            obj = namedManagers.get(groupName);
        }
        if (obj != null) {
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager[] getAllManagers() {
        WeakHashMap weakHashMap = namedManagers;
        synchronized (weakHashMap) {
            if (namedManagers.isEmpty()) {
                return new Manager[0];
            }
            Manager[] ret = new Manager[namedManagers.size()];
            return namedManagers.values().toArray(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager removeManager(JGroupConfig jConfig) {
        Manager mgr = null;
        String groupName = jConfig.getGroupName();
        if (namedManagers.containsKey(groupName)) {
            WeakHashMap weakHashMap = namedManagers;
            synchronized (weakHashMap) {
                mgr = (Manager)namedManagers.remove(groupName);
            }
            mgr.stop();
        }
        return mgr;
    }

    private static void initLocalRmiInfo(Manager sManager) {
        RMIServer server;
        RMIServerConfig config;
        if (localRmiInfo == null && (config = (server = RMIServer.getInstance(null)).getConfig()) != null) {
            String addr = null;
            try {
                addr = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                addr = server.getAddress().getHostAddress();
            }
            localRmiInfo = new Hashtable();
            localRmiInfo.put("NON_SECURE_LOCATION", new ServerIdentification(addr, config.getPort()));
            if (config.getSslPort() != -1) {
                localRmiInfo.put("SECURE_LOCATION", new ServerIdentification(addr, config.getSslPort()));
            }
        }
        sManager.setLocalRMIInfo(localRmiInfo);
    }

    protected static Hashtable getLocalRmiInfo() {
        return localRmiInfo;
    }

    static {
        SessionManagerFactory.initDefaultPrototypes();
    }
}

