/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Manager;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.AckEJBLiveSession;
import com.oracle.bricks.j2ee.EJBSessionReplica;
import com.oracle.jgroups.AbstractGroup;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.logging.Level;
import oracle.j2ee.clustering.ClusteringMessages;
import org.jgroups.Address;

public class AckEJBSessionReplica
extends EJBSessionReplica {
    protected long m_timeout;

    public AckEJBSessionReplica() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckEJBSessionReplica no args");
        }
    }

    protected AckEJBSessionReplica(AckEJBLiveSession session) throws Exception {
        super(session);
        this.m_timeout = session.getAcknowledgementTimeout();
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "creating AckEJBSessionReplica with args");
        }
    }

    protected LocalObject reify(ObjectMarshaller marshaller) {
        ClusteringMessages.fineEjbSessionFailover(this.getId());
        return new AckEJBLiveSession(this, this.m_timeout);
    }

    public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
        super.readExternal(in, marshaller);
        this.m_timeout = in.readLong();
    }

    public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
        super.writeExternal(out, marshaller);
        out.writeLong(this.m_timeout);
    }

    protected void applyBroadcastStateWithAck(EJBSessionReplica.BroadcastState state, int ackSeqNo, Address owner, Manager mgr) {
        this.applyBroadcast(state);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "AckEJBSessionReplica::applyBroadcastStateWithAck: id: " + this.getId() + ", ackSeqNo: " + ackSeqNo + ", owner: " + owner);
        }
        mgr.sendAckApplyDeltaMessage(this.getId(), ackSeqNo, owner);
    }

    protected void applyDeltaWithAck(EJBSessionReplica.ApplyDelta applyDelta, int ackSeqNo, Address owner, Manager mgr) {
        this.applyDelta(applyDelta);
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "AckEJBSessionReplica::applyDeltaWithAck: id: " + this.getId() + ", ackSeqNo: " + ackSeqNo + ", owner: " + owner);
        }
        mgr.sendAckApplyDeltaMessage(this.getId(), ackSeqNo, owner);
    }

    public static class ApplyDeltaWithAck
    extends EJBSessionReplica.ApplyDelta
    implements AckSeqNo {
        private int ackSeqNo = -1;
        private Address owner;

        public ApplyDeltaWithAck() {
        }

        public ApplyDeltaWithAck(Serializable id, String name, Serializable value, int ackSeqNo, Address owner) {
            super(id, name, value);
            this.ackSeqNo = ackSeqNo;
            this.owner = owner;
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            super.writeExternal(out, marshaller);
            out.writeInt(this.ackSeqNo);
            marshaller.writeExternal(out, (Externalizable)this.owner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws ClassNotFoundException, IOException {
            super.readExternal(in, marshaller);
            this.ackSeqNo = in.readInt();
            this.owner = (Address)marshaller.readExternal(in);
        }

        public final void dispatch(AbstractGroup manager) {
            Replica replica = ((Manager)manager).getReplica(this.id);
            this.applyTo(replica, (Manager)manager);
        }

        protected void applyTo(Replica replicated, Manager mgr) {
            if (replicated == null) {
                return;
            }
            ((AckEJBSessionReplica)replicated).applyDeltaWithAck(this, this.ackSeqNo, this.owner, mgr);
        }

        public int getAckSeqNo() {
            return this.ackSeqNo;
        }
    }

    public static class BroadcastStateWithAck
    extends EJBSessionReplica.BroadcastState
    implements AckSeqNo {
        private int ackSeqNo = -1;
        private Address owner;

        public BroadcastStateWithAck() {
        }

        public BroadcastStateWithAck(AckEJBLiveSession ackEJBLiveSession, int ackSeqNo, Address owner) {
            super(ackEJBLiveSession);
            this.ackSeqNo = ackSeqNo;
            this.owner = owner;
        }

        public String toString() {
            if (this.liveSession == null) {
                return "BroadcastStateWithAck session: ackSeqNo: " + this.ackSeqNo + ", owner: " + this.owner;
            }
            return "BroadcastStateWithAck session: id: " + this.liveSession.getId() + ", ackSeqNo:" + this.ackSeqNo + ", owner: " + this.owner;
        }

        public final void dispatch(AbstractGroup manager) {
            Replica replica = ((Manager)manager).getReplica(new Long(this.id));
            this.applyTo(replica, (Manager)manager);
        }

        protected void applyTo(Replica replicated, Manager mgr) {
            if (replicated == null) {
                return;
            }
            ((AckEJBSessionReplica)replicated).applyBroadcastStateWithAck(this, this.ackSeqNo, this.owner, mgr);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            super.writeExternal(out, marshaller);
            out.writeInt(this.ackSeqNo);
            marshaller.writeExternal(out, (Externalizable)this.owner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            super.readExternal(in, marshaller);
            this.ackSeqNo = in.readInt();
            this.owner = (Address)marshaller.readExternal(in);
        }

        public int getAckSeqNo() {
            return this.ackSeqNo;
        }
    }

    public static interface AckSeqNo {
        public int getAckSeqNo();
    }
}

