/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.j2ee.Session;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;

public interface SessionEventListener {
    public void attributeAdded(Serializable var1, Serializable var2);

    public void attributeRemoved(Serializable var1, Serializable var2);

    public void attributeModified(Serializable var1, Serializable var2, Serializable var3);

    public void sessionReaped(Session var1);

    public void sessionMigrated(Session var1);

    public void sessionDropped(Session var1);

    static class 1 {
        static /* synthetic */ Class class$com$oracle$bricks$j2ee$SessionEventListener$NullListener;
    }

    public static class NullListener
    implements SessionEventListener {
        private static final SessionEventListener singleton = new NullListener();
        static Logger m_logger = ClusteringTraceLogger.getHttpTraceLogger(1.class$com$oracle$bricks$j2ee$SessionEventListener$NullListener == null ? (1.class$com$oracle$bricks$j2ee$SessionEventListener$NullListener = 1.class$("com.oracle.bricks.j2ee.SessionEventListener$NullListener")) : 1.class$com$oracle$bricks$j2ee$SessionEventListener$NullListener);

        static SessionEventListener getSingleton() {
            return singleton;
        }

        private NullListener() {
        }

        public void attributeAdded(Serializable key, Serializable value) {
            if (this.isDebugEnabled()) {
                m_logger.log(Level.FINEST, "attributeAdded -- " + key + " - " + value);
            }
        }

        public void attributeRemoved(Serializable key, Serializable value) {
            if (this.isDebugEnabled()) {
                m_logger.log(Level.FINEST, "attributeRemoved -- " + key);
            }
        }

        public void attributeModified(Serializable key, Serializable newValue, Serializable oldValue) {
            if (this.isDebugEnabled()) {
                m_logger.log(Level.FINEST, "attributeModified -- " + key + " newValue: " + newValue + " oldValue " + oldValue);
            }
        }

        public void sessionReaped(Session session) {
            if (this.isDebugEnabled()) {
                m_logger.log(Level.FINEST, "sessionReaped -- " + session.getId());
            }
        }

        public void sessionMigrated(Session session) {
            if (this.isDebugEnabled()) {
                m_logger.log(Level.FINEST, "sessionMigrated -- " + session.getId());
            }
        }

        public void sessionDropped(Session session) {
            if (this.isDebugEnabled()) {
                m_logger.log(Level.FINEST, "sessionDropped -- " + session.getId());
            }
        }

        private boolean isDebugEnabled() {
            return m_logger.isLoggable(Level.FINEST);
        }
    }
}

