/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jgroups;

import com.oracle.jgroups.ChannelAdapter;
import com.oracle.jgroups.ClusterMemberIpAddress;
import com.oracle.jgroups.ControlMessage;
import com.oracle.jgroups.InterruptableTestAndWaitLock;
import com.oracle.jgroups.ObjectMarshaller;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;

public abstract class AbstractGroup {
    protected final String group;
    protected final ChannelAdapter adapter;
    protected Address address;
    protected final InterruptableTestAndWaitLock viewChangeSync = new InterruptableTestAndWaitLock("View Change");
    private List oldMembers = new ArrayList();
    private ClusterMemberIpAddress localIpAddress = null;
    private static final Logger m_logger = ClusteringTraceLogger.getTraceLogger(AbstractGroup.class);

    public AbstractGroup(String group, ChannelFactory channelFactory, Object properties) throws ChannelException {
        this.group = group;
        JChannel channel = channelFactory != null ? channelFactory.createChannel(properties) : new JChannel(properties);
        this.setOptions((Channel)channel);
        this.adapter = this.getAdapter((Channel)channel);
        this.address = channel.getLocalAddress();
    }

    protected void setOptions(Channel channel) {
    }

    protected ObjectMarshaller getMarshaller() {
        return new ObjectMarshaller();
    }

    public String getGroup() {
        return this.group;
    }

    public Address getAddress() {
        return this.address;
    }

    public ChannelAdapter getChannelAdapter() {
        return this.adapter;
    }

    public void start() throws ChannelClosedException, ChannelException {
        if (this.isStarted()) {
            return;
        }
        this.adapter.start(this.group, false, 0);
        this.address = this.adapter.getLocalAddress();
    }

    public void stop() {
        this.adapter.stop();
        this.viewChangeSync.interrupt();
        this.localIpAddress = null;
    }

    public boolean isStarted() {
        return this.adapter.isStarted();
    }

    protected void squelch() throws InterruptedException {
        this.viewChangeSync.freeze();
        this.adapter.pauseOutbound();
    }

    protected void resume() {
        this.adapter.resumeOutbound();
        this.viewChangeSync.thaw();
    }

    protected ChannelAdapter getAdapter(Channel channel) {
        return new ChannelAdapter(channel, this.getMarshaller(), this.getMembershipListener(), this.getMessageListener());
    }

    protected MessageListener getMessageListener() {
        return new MessageListener(){

            public void receive(Message msg) {
                ControlMessage message;
                try {
                    try {
                        message = (ControlMessage)AbstractGroup.this.adapter.getMarshaller().bytesToMarshalled(msg.getBuffer());
                    }
                    catch (Throwable t) {
                        if (m_logger.isLoggable(Level.FINEST)) {
                            m_logger.log(Level.FINEST, "Exception during deserialization of incoming message", t);
                        }
                        return;
                    }
                }
                catch (ClassCastException e) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "Inbound message is not instanceof ControlMessage: " + msg.getObject().getClass());
                    }
                    return;
                }
                AbstractGroup.this.dispatch(message);
            }

            public byte[] getState() {
                return new byte[0];
            }

            public void setState(byte[] state) {
            }
        };
    }

    protected abstract void newView(Set var1, Set var2);

    protected void dispatch(ControlMessage message) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "dispatching message: " + message);
        }
        message.dispatch(this);
    }

    protected MembershipListener getMembershipListener() {
        return new MembershipListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void viewAccepted(View new_view) {
                block6: {
                    try {
                        AbstractGroup.this.squelch();
                        try {
                            if (m_logger.isLoggable(Level.FINEST)) {
                                m_logger.log(Level.FINEST, "accepting view: " + new_view);
                            }
                            HashSet newMembers = new HashSet(AbstractGroup.this.adapter.getMembers());
                            newMembers.removeAll(AbstractGroup.this.oldMembers);
                            newMembers.remove(AbstractGroup.this.address);
                            HashSet failedMembers = new HashSet(AbstractGroup.this.oldMembers);
                            failedMembers.removeAll(AbstractGroup.this.adapter.getMembers());
                            AbstractGroup.this.oldMembers = AbstractGroup.this.adapter.getMembers();
                            AbstractGroup.this.newView(newMembers, failedMembers);
                        }
                        finally {
                            AbstractGroup.this.resume();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!m_logger.isLoggable(Level.FINEST)) break block6;
                        m_logger.log(Level.FINEST, "sync error in view acceptance", e);
                    }
                }
            }

            public void suspect(Address suspected_mbr) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Suspected: " + suspected_mbr);
                }
            }

            public void block() {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Block message received");
                }
            }
        };
    }

    public ClusterMemberIpAddress getLocalAddress() {
        Address addr;
        if (this.localIpAddress == null && (addr = this.getAddress()) instanceof IpAddress) {
            this.localIpAddress = new ClusterMemberIpAddress((IpAddress)addr);
        }
        return this.localIpAddress;
    }

    public View getCurrentView() {
        return this.adapter.getView();
    }
}

