/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.StringTokenizer;

public class RmicCompiler {
    private static final String DEFAULT_COLOC_JAR = "oc4j.jar";
    private String m_colocJar;
    private Method m_comp;
    private Object m_compObj;
    private static URLClassLoader rmicLoader = null;
    private static final String OC4J_TOOLS_JAR_PATH = "oc4j.tools.jar.path";
    private static final String JAVA_HOME = "java.home";
    private static final String IIOP_RMIC_JAR = "iiop_rmic.jar";
    private static final String USER_DIR = "user.dir";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String TOOLS_JAR = "tools.jar";
    private static final String RMIC_MAIN_CLASS = "sun.rmi.rmic.Main";

    public RmicCompiler() throws CompilationException {
        this(DEFAULT_COLOC_JAR);
    }

    public RmicCompiler(String colocJar) throws CompilationException {
        this.m_colocJar = colocJar;
        this.initCompiler();
    }

    private void initCompiler() throws CompilationException {
        try {
            this.m_compObj = this.getRmicCompilerObject();
            this.m_comp = this.m_compObj.getClass().getMethod("compile", new String[0].getClass());
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("Could not initialize rmic compiler.");
            throw new CompilationException("Could not invoke rmic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRmicCompilerObject() throws MalformedURLException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, CompilationException {
        Class clazz = RmicCompiler.class;
        synchronized (clazz) {
            if (rmicLoader == null) {
                rmicLoader = new URLClassLoader(new URL[]{this.getIIOPRmicJarPathURL(), this.getToolsJarPathURL()}, this.getClass().getClassLoader());
            }
        }
        Class<?> rmicMainClass = Class.forName(RMIC_MAIN_CLASS, true, rmicLoader);
        Constructor<?> rmicConstructor = rmicMainClass.getConstructor(OutputStream.class, String.class);
        return rmicConstructor.newInstance(System.err, "rmic");
    }

    private URL getToolsJarPathURL() throws MalformedURLException, CompilationException {
        File toolsJarDir;
        String toolsPath = OC4JRuntimeProperties.getOc4jToolsJarPath();
        if (toolsPath == null && this.isJarFound(toolsJarDir = new File(System.getProperty(JAVA_HOME) + File.separator + ".." + File.separator + "lib"), TOOLS_JAR)) {
            toolsPath = toolsJarDir.getAbsolutePath() + File.separator + TOOLS_JAR;
        }
        if (toolsPath == null) {
            throw new CompilationException("Unable to find tools.jar.  Please make sure you are using a full JDK installation.  You may specify the path to the tools.jar file with the -Doc4j.tools.jar.path option.");
        }
        return new URL("file:" + toolsPath);
    }

    private URL getIIOPRmicJarPathURL() throws MalformedURLException, CompilationException {
        String homeDir = OC4JRuntimeProperties.getOracleJ2eeHome();
        if (!this.isJarFound(homeDir, IIOP_RMIC_JAR)) {
            homeDir = OC4JRuntimeProperties.getOracleOnsOraclehome();
            if (homeDir == null) {
                homeDir = OC4JRuntimeProperties.getOracleHome();
            }
            homeDir = homeDir != null ? homeDir + File.separator + "j2ee" + File.separator + "home" : System.getProperty(USER_DIR);
            if (!this.isJarFound(homeDir, IIOP_RMIC_JAR) && !this.isJarFound(homeDir = this.getHomeDirFromClasspath(), IIOP_RMIC_JAR)) {
                throw new CompilationException("Can not find iiop_rmic.jar file in " + homeDir);
            }
        }
        return new URL("file:" + homeDir + "/" + IIOP_RMIC_JAR);
    }

    private String getHomeDirFromClasspath() {
        String resultDir = null;
        StringTokenizer st = new StringTokenizer(System.getProperty(JAVA_CLASS_PATH), File.pathSeparator);
        String pathElement = null;
        File cpFile = null;
        while (st.hasMoreTokens() && resultDir == null) {
            pathElement = st.nextToken();
            if (pathElement == null || pathElement.indexOf(this.m_colocJar) < 0 || !(cpFile = new File(pathElement)).exists()) continue;
            resultDir = cpFile.getParent();
        }
        return resultDir;
    }

    private boolean isJarFound(String dir, String jarName) {
        return dir != null && jarName != null ? this.isJarFound(new File(dir), jarName) : false;
    }

    private boolean isJarFound(File dir, String jarName) {
        return dir != null && dir.isDirectory() ? Arrays.asList(dir.list()).contains(jarName) : false;
    }

    public void compile(String[] rmicArgs) throws CompilationException {
        try {
            if (this.m_comp.invoke(this.m_compObj, new Object[]{rmicArgs}) == Boolean.FALSE) {
                System.err.println("rmic compilation failed...");
                throw new CompilationException("rmic compilation failed.");
            }
        }
        catch (IllegalAccessException e) {
            throw new CompilationException(e.toString());
        }
        catch (IllegalArgumentException e) {
            throw new CompilationException(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new CompilationException(e.toString());
        }
        catch (CompilationException e) {
            throw e;
        }
    }
}

