/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.Symbol;
import com.sun.ejb.ejbql.Visitor;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import java.util.Iterator;
import java.util.Vector;

public abstract class CmrField
extends ExpressionBase
implements Symbol {
    private String name_;
    private RelationRoleDescriptor sourceRoleDescriptor_;
    private PersistenceDescriptor sinkPersistenceDescriptor_;
    private PersistenceDescriptor sourcePersistenceDescriptor_;
    private CMRFieldInfo cmrFieldInfo_;
    private Vector fields = null;

    public CmrField(String name, RelationRoleDescriptor sourceRoleDescriptor) {
        this.name_ = name;
        this.sourceRoleDescriptor_ = sourceRoleDescriptor;
        EjbCMPEntityDescriptor owner = this.sourceRoleDescriptor_.getOwner();
        this.sourcePersistenceDescriptor_ = owner.getPersistenceDescriptor();
        EjbCMPEntityDescriptor partnerOwner = sourceRoleDescriptor.getPartner().getOwner();
        this.sinkPersistenceDescriptor_ = partnerOwner.getPersistenceDescriptor();
        try {
            this.cmrFieldInfo_ = this.sourcePersistenceDescriptor_.getCMRFieldInfoByName(this.name_);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't find cmr field : " + this.name_);
        }
    }

    public boolean requiresJoining() {
        return this.hasJoinTable() || !this.sourceRoleDescriptor_.getIsMany() && this.sourceRoleDescriptor_.getPartner().getIsMany();
    }

    public boolean hasJoinTable() {
        return this.getRelationshipDescriptor().getJoinDescriptor() != null;
    }

    public RelationshipDescriptor getRelationshipDescriptor() {
        return this.sourceRoleDescriptor_.getRelationshipDescriptor();
    }

    public RelationRoleDescriptor getSourceRoleDescriptor() {
        return this.sourceRoleDescriptor_;
    }

    public PersistenceDescriptor getSourcePersistenceDescriptor() {
        return this.sourcePersistenceDescriptor_;
    }

    public PersistenceDescriptor getSinkPersistenceDescriptor() {
        return this.sinkPersistenceDescriptor_;
    }

    public CMRFieldInfo getCMRFieldInfo() {
        return this.cmrFieldInfo_;
    }

    public String toSql() {
        return this.name_;
    }

    public String getTableName() {
        return this.sinkPersistenceDescriptor_.getTableName();
    }

    public Iterator getFieldNames() {
        if (this.fields == null) {
            this.computeFieldNames();
        }
        return this.fields.iterator();
    }

    private void computeFieldNames() {
        this.fields = new Vector();
        if (this.requiresJoining()) {
            if (this.hasJoinTable()) {
                PersistenceDescriptor joinTablePersistenceDesc = this.getRelationshipDescriptor().getJoinDescriptor().getPersistenceDescriptor();
                PersistentFieldInfo[] joinTableFields = joinTablePersistenceDesc.getPersistentFieldInfo();
                for (int i = 0; i < joinTableFields.length; ++i) {
                    PersistentFieldInfo next = joinTableFields[i];
                    if (next.relatedObj == null) {
                        this.fields.add(next.columnName);
                        continue;
                    }
                    if (this.sinkPersistenceDescriptor_ == null || !next.relatedObj.getTableName().equals(this.sinkPersistenceDescriptor_.getTableName())) continue;
                    this.fields.add(next.columnName);
                }
            } else {
                PersistenceDescriptor sinkPersistenceDesc = this.getSinkPersistenceDescriptor();
                PersistentFieldInfo[] sinkPkeyFields = sinkPersistenceDesc.getPkeyFieldInfo();
                for (int i = 0; i < sinkPkeyFields.length; ++i) {
                    PersistentFieldInfo pkeyInfo = sinkPkeyFields[i];
                    this.fields.add(pkeyInfo.columnName);
                }
            }
        } else {
            for (int i = 0; i < this.cmrFieldInfo_.fkeyFields.length; ++i) {
                PersistentFieldInfo next = this.cmrFieldInfo_.fkeyFields[i];
                this.fields.add(next.columnName);
            }
        }
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        String s = "{CmrField " + this.hashCode() + " name: " + this.getName();
        s = s + "\n  sourceRoleDescriptor_: " + this.sourceRoleDescriptor_;
        s = s + "\n  sourceRoleDescriptor_.getPartner: " + this.sourceRoleDescriptor_.getPartner();
        s = s + "\n  sinkPersistenceDescriptor_: " + this.sinkPersistenceDescriptor_;
        s = s + "\n  sourcePersistenceDescriptor_: " + this.sourcePersistenceDescriptor_;
        s = s + "\n  requiresJoining(): " + this.requiresJoining();
        s = s + "\n  tableName: " + this.getTableName();
        s = s + "\n  collection?: " + this.isCollectionValued();
        return s;
    }

    public void accept(Visitor visitor) {
        visitor.visitSymbol(this);
    }

    public boolean isCmrField() {
        return true;
    }

    public boolean isSingleValued() {
        return !this.isCollectionValued();
    }

    public boolean isCollectionValued() {
        return this.sourceRoleDescriptor_.getPartner().getIsMany();
    }

    public abstract String getTargetName();

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof CmrField) {
            CmrField otherCmr = (CmrField)other;
            equal = this.getTargetName().equals(otherCmr.getTargetName()) && this.getName().equals(otherCmr.getName());
        }
        return equal;
    }
}

