/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.OperatorBase;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.Visitor;
import java.util.Iterator;
import java.util.Vector;

public abstract class UnaryOperator
extends OperatorBase {
    public static final UnaryOperator ESCAPE = new Escape();
    public static final UnaryOperator NOT = new Not();
    public static final UnaryOperator PLUS = new Plus();
    public static final UnaryOperator MINUS = new Minus();
    public static final UnaryOperator IS_NULL = new IsNull(false);
    public static final UnaryOperator IS_NOT_NULL = new IsNull(true);
    public static final UnaryOperator IS_EMPTY = new IsEmpty(false);
    public static final UnaryOperator IS_NOT_EMPTY = new IsEmpty(true);
    public static final UnaryOperator LENGTH = new Length();
    public static final UnaryOperator ABS = new Abs();
    public static final UnaryOperator SQRT = new Sqrt();
    public static final UnaryOperator SELECT_ALL = new SelectAll();
    private boolean preOperator_;

    public boolean isUnary() {
        return true;
    }

    public boolean operatesOn(Vector expressions) {
        if (expressions.size() != 1) {
            throw new IllegalArgumentException("Wrong arity " + expressions.size());
        }
        return this.operatesOn((Expression)expressions.firstElement());
    }

    public abstract boolean operatesOn(Expression var1);

    public String getResultType(Vector expressions) {
        if (!this.operatesOn(expressions)) {
            throw new IllegalArgumentException("Wrong expr type");
        }
        return this.getResultType((Expression)expressions.firstElement());
    }

    public abstract String getResultType(Expression var1);

    public boolean isPreOperator() {
        return this.preOperator_;
    }

    public boolean isPostOperator() {
        return !this.isPreOperator();
    }

    protected UnaryOperator(boolean preOperator) {
        this.preOperator_ = preOperator;
    }

    protected UnaryOperator() {
        this(true);
    }

    public Iterator getPrintStrings(Vector expressions) {
        Vector<String> printStrings = new Vector<String>();
        printStrings.add(this.getPrintString());
        return printStrings.iterator();
    }

    public abstract String getPrintString();

    private static class SelectAll
    extends UnaryOperator {
        private SelectAll() {
        }

        public boolean operatesOn(Expression expression) {
            return false;
        }

        public String getResultType(Expression expression) {
            return expression.getJavaType();
        }

        public String getPrintString() {
            return "*";
        }
    }

    private static class Sqrt
    extends UnaryOperator {
        private Sqrt() {
        }

        public boolean operatesOn(Expression expression) {
            String exprType = expression.getJavaType();
            return exprType.equals(DOUBLE_PRIMITIVE_TYPE_NAME) || exprType.equals(DOUBLE_OBJECT_TYPE_NAME);
        }

        public String getResultType(Expression expression) {
            return DOUBLE_PRIMITIVE_TYPE_NAME;
        }

        public String getPrintString() {
            return "SQRT";
        }

        public boolean isFunction() {
            return true;
        }
    }

    private static class Abs
    extends UnaryOperator {
        private Abs() {
        }

        public boolean operatesOn(Expression expression) {
            String exprType = expression.getJavaType();
            return exprType.equals(INTEGER_PRIMITIVE_TYPE_NAME) || exprType.equals(FLOAT_PRIMITIVE_TYPE_NAME) || exprType.equals(DOUBLE_PRIMITIVE_TYPE_NAME);
        }

        public String getResultType(Expression expression) {
            return expression.getJavaType();
        }

        public boolean isFunction() {
            return true;
        }

        public String getPrintString() {
            return "ABS";
        }
    }

    private static class Length
    extends UnaryOperator {
        private Length() {
        }

        public boolean operatesOn(Expression expression) {
            return Length.hasStringType(expression);
        }

        public String getResultType(Expression expression) {
            return INTEGER_PRIMITIVE_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public String getPrintString() {
            return "LENGTH";
        }
    }

    private static class IsEmpty
    extends UnaryOperator {
        private boolean not_;

        public IsEmpty(boolean not) {
            super(false);
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitEmptyCollectionExpression(operatorExpr);
        }

        public boolean operatesOn(Expression expression) {
            return true;
        }

        public String getResultType(Expression expression) {
            return BOOLEAN_OBJECT_TYPE_NAME;
        }

        public String getPrintString() {
            return this.not_ ? "IS NOT EMPTY" : "IS EMPTY";
        }
    }

    private static class IsNull
    extends UnaryOperator {
        private boolean not_;

        public IsNull(boolean not) {
            super(false);
            this.not_ = not;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
            visitor.visitNullComparisonExpression(operatorExpr);
        }

        public boolean operatesOn(Expression expression) {
            return true;
        }

        public String getResultType(Expression expression) {
            return BOOLEAN_OBJECT_TYPE_NAME;
        }

        public String getPrintString() {
            return this.not_ ? "IS NOT NULL" : "IS NULL";
        }
    }

    private static class Escape
    extends UnaryOperator {
        private Escape() {
        }

        public boolean operatesOn(Expression expression) {
            return Escape.hasStringType(expression);
        }

        public String getResultType(Expression expression) {
            return STRING_TYPE_NAME;
        }

        public String getPrintString() {
            return "ESCAPE";
        }
    }

    private static class Not
    extends UnaryOperator {
        private Not() {
        }

        public boolean operatesOn(Expression expression) {
            return Not.hasBooleanType(expression);
        }

        public String getResultType(Expression expression) {
            return BOOLEAN_OBJECT_TYPE_NAME;
        }

        public String getPrintString() {
            return "NOT";
        }
    }

    private static class Minus
    extends UnaryOperator {
        private Minus() {
        }

        public boolean operatesOn(Expression expression) {
            return Minus.hasNumericType(expression);
        }

        public String getResultType(Expression expression) {
            if (Minus.hasSmallerNumericType(expression, INTEGER_PRIMITIVE_TYPE_NAME)) {
                return INTEGER_PRIMITIVE_TYPE_NAME;
            }
            return expression.getJavaType();
        }

        public String getPrintString() {
            return "-";
        }
    }

    private static class Plus
    extends UnaryOperator {
        private Plus() {
        }

        public boolean operatesOn(Expression expression) {
            return Plus.hasNumericType(expression);
        }

        public String getResultType(Expression expression) {
            if (Plus.hasSmallerNumericType(expression, INTEGER_PRIMITIVE_TYPE_NAME)) {
                return INTEGER_PRIMITIVE_TYPE_NAME;
            }
            return expression.getJavaType();
        }

        public String getPrintString() {
            return "+";
        }
    }
}

