/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;

public class ConnectorDescriptor
extends BundleDescriptor {
    private String connectionFactoryInterface;
    private String connectionFactoryImpl;
    private String connectionInterface;
    private String connectionImpl;
    private Set configProperties = new OrderedSet();
    private Set authMechanisms = new OrderedSet();
    private Set securityPermissions = new OrderedSet();
    private String managedConnectionFactoryImpl;
    private boolean reauthenticationSupport;
    private int transactionSupport = 1;
    private String displayName = "";
    private String connectorDescription;
    private String licenseDescription;
    private String eisType = "";
    private String largeIcon;
    private String smallIcon;
    private Boolean licenseRequired;
    private String specVersion = "";
    private String vendorName = "";
    private String version = "";
    private boolean isDirty = false;

    public String getDeployName() {
        File rarfile = new File(this.getArchivist().getArchiveUri());
        return rarfile.getName();
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        this.connectionFactoryInterface = connectionFactoryInterface;
        this.setDirty();
        this.changed();
    }

    public String getConnectionFactoryImpl() {
        return this.connectionFactoryImpl;
    }

    public void setConnectionFactoryImpl(String connectionFactoryImpl) {
        this.connectionFactoryImpl = connectionFactoryImpl;
        this.setDirty();
        this.changed();
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String connectionInterface) {
        this.connectionInterface = connectionInterface;
        this.setDirty();
        this.changed();
    }

    public String getConnectionImpl() {
        return this.connectionImpl;
    }

    public void setConnectionImpl(String connectionImpl) {
        this.connectionImpl = connectionImpl;
        this.setDirty();
        this.changed();
    }

    public String getManagedConnectionFactoryImpl() {
        return this.managedConnectionFactoryImpl;
    }

    private static void printEntry(ZipEntry e) throws IOException {
        System.out.println(e.getName());
    }

    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) {
        this.managedConnectionFactoryImpl = managedConnectionFactoryImpl;
        this.setDirty();
        this.changed();
    }

    public boolean supportsReauthentication() {
        return this.reauthenticationSupport;
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupport = reauthenticationSupport;
        this.setDirty();
        this.changed();
    }

    public String getTransSupport() {
        if (this.transactionSupport == 0) {
            return ConnectorNode.DD_NO_TRANSACTION;
        }
        if (this.transactionSupport == 1) {
            return ConnectorNode.DD_LOCAL_TRANSACTION;
        }
        return ConnectorNode.DD_XA_TRANSACTION;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport = transactionSupport;
        this.setDirty();
        this.changed();
    }

    public Set getConfigProperties() {
        if (this.configProperties == null) {
            this.configProperties = new OrderedSet();
        }
        return this.configProperties;
    }

    public Set getAuthMechanisms() {
        if (this.authMechanisms == null) {
            this.authMechanisms = new OrderedSet();
        }
        return this.authMechanisms;
    }

    public Set getSecurityPermissions() {
        if (this.securityPermissions == null) {
            this.securityPermissions = new OrderedSet();
        }
        return this.securityPermissions;
    }

    public void addConfigProperty(EnvironmentProperty configProperty) {
        this.configProperties.add(configProperty);
        this.setDirty();
        this.changed();
    }

    public void removeConfigProperty(EnvironmentProperty configProperty) {
        this.configProperties.remove(configProperty);
        this.setDirty();
        this.changed();
    }

    public boolean addAuthMechanism(AuthMechanism mech) {
        boolean flag = false;
        Iterator itr = this.authMechanisms.iterator();
        while (itr.hasNext()) {
            AuthMechanism next = (AuthMechanism)itr.next();
            if (next.getAuthMechVal() != mech.getAuthMechVal()) continue;
            return flag;
        }
        flag = this.authMechanisms.add(mech);
        this.setDirty();
        this.changed();
        return flag;
    }

    public boolean removeAuthMechanism(AuthMechanism mech) {
        boolean flag = false;
        Iterator itr = this.authMechanisms.iterator();
        while (itr.hasNext()) {
            AuthMechanism next = (AuthMechanism)itr.next();
            if (!next.equals(mech)) continue;
            flag = this.authMechanisms.remove(mech);
            this.setDirty();
            this.changed();
            return flag;
        }
        return flag;
    }

    public boolean addAuthMechanism(int mech) {
        boolean flag = false;
        Iterator itr = this.authMechanisms.iterator();
        while (itr.hasNext()) {
            AuthMechanism next = (AuthMechanism)itr.next();
            if (next.getAuthMechVal() != mech) continue;
            return flag;
        }
        String credInf = null;
        credInf = mech == 0 ? "javax.resource.spi.security.PasswordCredential" : "javax.resource.spi.security.GenericCredential";
        AuthMechanism auth = new AuthMechanism("", mech, credInf);
        flag = this.authMechanisms.add(auth);
        this.setDirty();
        this.changed();
        return flag;
    }

    public boolean removeAuthMechanism(int mech) {
        boolean flag = false;
        Iterator itr = this.authMechanisms.iterator();
        while (itr.hasNext()) {
            AuthMechanism next = (AuthMechanism)itr.next();
            if (next.getAuthMechVal() != mech) continue;
            flag = this.authMechanisms.remove(next);
            this.setDirty();
            this.changed();
            return flag;
        }
        return flag;
    }

    public void addSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.add(permission);
        this.setDirty();
        this.changed();
    }

    public void removeSecurityPermission(SecurityPermission permission) {
        this.securityPermissions.remove(permission);
        this.setDirty();
        this.changed();
    }

    public void setLicenseDescription(String description) {
        this.licenseDescription = description;
        this.setDirty();
        this.changed();
    }

    public String getLicenseDescription() {
        return this.licenseDescription;
    }

    public String getConnectorDescription() {
        return this.connectorDescription;
    }

    public void setConnectorDescription(String description) {
        this.connectorDescription = description;
        this.setDirty();
        this.changed();
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        this.eisType = eisType;
        this.setDirty();
        this.changed();
    }

    public Boolean getLicenseRequired() {
        return this.licenseRequired;
    }

    public void setLicenseRequired(boolean licenseRequired) {
        this.licenseRequired = licenseRequired ? Boolean.TRUE : (!licenseRequired ? Boolean.FALSE : null);
        this.setDirty();
        this.changed();
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
        this.setDirty();
        this.changed();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.setDirty();
        this.changed();
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
        this.setDirty();
        this.changed();
    }

    protected Archivist getDefaultArchivist() {
        return new ConnectorArchivist("", this);
    }

    public String toString() {
        String s = super.toString();
        s = s + "\n connectionFactoryInterface " + this.connectionFactoryInterface;
        s = s + "\n connectionFactoryImpl " + this.connectionFactoryImpl;
        s = s + "\n connectionInterface " + this.connectionInterface;
        s = s + "\n connectionImpl " + this.connectionImpl;
        s = s + "\n managedConnectionFactoryImpl " + this.managedConnectionFactoryImpl;
        s = s + "\n reauthenticationSupport " + this.reauthenticationSupport;
        s = s + "\n transactionSupport " + this.transactionSupport;
        s = s + "\n configProperties " + this.configProperties;
        s = s + "\n authMechanisms " + this.authMechanisms;
        s = s + "\n securityPermissions " + this.securityPermissions;
        s = s + "\n displayName " + this.displayName;
        s = s + "\n connector_description " + this.connectorDescription;
        s = s + "\n license_description " + this.licenseDescription;
        s = s + "\n eisType " + this.eisType;
        s = s + "\n smallIcon " + this.smallIcon;
        s = s + "\n largeIcon " + this.largeIcon;
        s = s + "\n licenseRequired " + this.licenseRequired;
        s = s + "\n specVersion " + this.specVersion;
        s = s + "\n vendorName " + this.vendorName;
        s = s + "\n version " + this.version;
        return s;
    }

    public void changed() {
        super.changed();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty() {
        this.isDirty = true;
    }

    void doneOpening() {
        this.isDirty = false;
        this.changed();
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed();
    }

    public void setName(String name) {
        if (!this.getName().equals(name)) {
            this.setDirty();
            super.setName(name);
        }
    }

    public void setDescription(String description) {
        this.setDirty();
        super.setDescription(description);
    }

    public void setSmallIconUri(String smallIconUri) {
        this.setDirty();
        super.setSmallIconUri(smallIconUri);
    }

    public void setLargeIconUri(String largeIconUri) {
        this.setDirty();
        super.setLargeIconUri(largeIconUri);
    }
}

