/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.BeanMethodCalculator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class EjbDescriptor
extends EjbAbstractDescriptor
implements WritableJndiNameEnvironment {
    public static String BEAN_TRANSACTION_TYPE = "Bean";
    public static String CONTAINER_TRANSACTION_TYPE = "Container";
    public static String LOCAL_TRANSACTION_SCOPE = "Local";
    public static String DISTRIBUTED_TRANSACTION_SCOPE = "Distributed";
    protected String transactionType = null;
    private Hashtable methodContainerTransactions = null;
    private ContainerTransaction containerTransaction = null;
    private Hashtable permissionedMethodsByPermission = null;
    private Set environmentProperties;
    private Set ejbReferences = new HashSet();
    private Set jmsDestReferences = new HashSet();
    private Set resourceReferences = new HashSet();
    private Set roleReferences = new HashSet();
    private EjbBundleDescriptor bundleDescriptor;
    private Set iorConfigDescriptors = new OrderedSet();
    private String ejbClassName;
    private Set ejbReferencersPointingToMe = new HashSet();
    protected boolean usesCallerIdentity = true;
    protected String securityIdentityDescription;
    protected boolean isDistributedTxScope = true;
    protected RunAsIdentityDescriptor runAsIdentity = null;
    private Map styledMethodDescriptors = new HashMap();
    private long uniqueId;
    private String remoteHomeImplClassName;
    private String ejbObjectImplClassName;
    private String localHomeImplClassName;
    private String ejbLocalObjectImplClassName;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbDescriptor == null ? (class$com$sun$enterprise$deployment$EjbDescriptor = EjbDescriptor.class$("com.sun.enterprise.deployment.EjbDescriptor")) : class$com$sun$enterprise$deployment$EjbDescriptor);
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbDescriptor;

    protected EjbDescriptor() {
    }

    public EjbDescriptor(EjbDescriptor other) {
        super(other);
        this.transactionType = other.transactionType;
        this.methodContainerTransactions = new Hashtable(other.getMethodContainerTransactions());
        this.permissionedMethodsByPermission = new Hashtable(other.getPermissionedMethodsByPermission());
        this.getEnvironmentProperties().addAll(other.getEnvironmentProperties());
        this.getEjbReferenceDescriptors().addAll(other.getEjbReferenceDescriptors());
        this.getJmsDestinationReferenceDescriptors().addAll(other.getJmsDestinationReferenceDescriptors());
        this.getResourceReferenceDescriptors().addAll(other.getResourceReferenceDescriptors());
        this.getRoleReferences().addAll(other.getRoleReferences());
        this.getIORConfigurationDescriptors().addAll(other.getIORConfigurationDescriptors());
        this.transactionType = other.transactionType;
        this.ejbClassName = other.ejbClassName;
    }

    public boolean classesChanged() {
        MethodDescriptor methodDescriptor;
        Iterator itr;
        boolean iChanged = false;
        if (this instanceof EjbMessageBeanDescriptor) {
            return false;
        }
        Set newMethodDescriptors = this.getMethodDescriptors();
        if (this.getTransactionType().equals(CONTAINER_TRANSACTION_TYPE)) {
            HashSet<MethodDescriptor> methodDescToRemove = new HashSet<MethodDescriptor>();
            Enumeration e = this.getMethodContainerTransactions().keys();
            while (e.hasMoreElements()) {
                MethodDescriptor methodDescriptor2 = (MethodDescriptor)e.nextElement();
                if (newMethodDescriptors.contains(methodDescriptor2)) continue;
                methodDescToRemove.add(methodDescriptor2);
                iChanged = true;
            }
            itr = methodDescToRemove.iterator();
            while (itr.hasNext()) {
                methodDescriptor = (MethodDescriptor)itr.next();
                this.removeContainerTransactionFor(methodDescriptor);
            }
        }
        Iterator e = this.getPermissionedMethodsByPermission().values().iterator();
        while (e.hasNext()) {
            Set methodDescriptors = (Set)e.next();
            itr = methodDescriptors.iterator();
            while (itr.hasNext()) {
                methodDescriptor = (MethodDescriptor)itr.next();
                if (newMethodDescriptors.contains(methodDescriptor)) continue;
                itr.remove();
                iChanged = true;
            }
        }
        if (iChanged) {
            this.changed();
        }
        return iChanged;
    }

    public void setEjbClassName(String ejbClassName) {
        this.ejbClassName = ejbClassName;
    }

    public String getEjbClassName() {
        return this.ejbClassName;
    }

    public void setRemoteHomeImplClassName(String name) {
        this.remoteHomeImplClassName = name;
    }

    public String getRemoteHomeImplClassName() {
        return this.remoteHomeImplClassName;
    }

    public void setLocalHomeImplClassName(String name) {
        this.localHomeImplClassName = name;
    }

    public String getLocalHomeImplClassName() {
        return this.localHomeImplClassName;
    }

    public void setEJBLocalObjectImplClassName(String name) {
        this.ejbLocalObjectImplClassName = name;
    }

    public String getEJBLocalObjectImplClassName() {
        return this.ejbLocalObjectImplClassName;
    }

    public void setEJBObjectImplClassName(String name) {
        this.ejbObjectImplClassName = name;
    }

    public String getEJBObjectImplClassName() {
        return this.ejbObjectImplClassName;
    }

    public String getTransactionType() {
        if (this.transactionType == null) {
            this.transactionType = BEAN_TRANSACTION_TYPE;
        }
        return this.transactionType;
    }

    public abstract void setTransactionType(String var1);

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = new Vector<ContainerTransaction>();
        txAttributes.add(new ContainerTransaction(ContainerTransaction.MANDATORY, ""));
        txAttributes.add(new ContainerTransaction(ContainerTransaction.NEVER, ""));
        txAttributes.add(new ContainerTransaction(ContainerTransaction.NOT_SUPPORTED, ""));
        txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRED, ""));
        txAttributes.add(new ContainerTransaction(ContainerTransaction.REQUIRES_NEW, ""));
        txAttributes.add(new ContainerTransaction(ContainerTransaction.SUPPORTS, ""));
        return txAttributes;
    }

    public boolean isDistributedTransactionScope() {
        return this.isDistributedTxScope;
    }

    public void setDistributedTransactionScope(boolean scope) {
        this.isDistributedTxScope = scope;
    }

    public void setUsesCallerIdentity(boolean flag) {
        if (flag && this instanceof EjbMessageBeanDescriptor) {
            throw new IllegalArgumentException("Cannot set use-caller-identity for Message Driven beans");
        }
        this.usesCallerIdentity = flag;
    }

    public boolean getUsesCallerIdentity() {
        return this.usesCallerIdentity;
    }

    public String getSecurityIdentityDescription() {
        if (this.securityIdentityDescription == null) {
            this.securityIdentityDescription = "";
        }
        return this.securityIdentityDescription;
    }

    public void setSecurityIdentityDescription(String s) {
        this.securityIdentityDescription = s;
    }

    public void setRunAsIdentity(RunAsIdentityDescriptor desc) {
        if (this.usesCallerIdentity) {
            throw new IllegalStateException("Cannot set RunAs identity when using caller identity");
        }
        this.runAsIdentity = desc;
    }

    public RunAsIdentityDescriptor getRunAsIdentity() {
        if (this.usesCallerIdentity) {
            throw new IllegalStateException("Cannot get RunAs identity when using caller identity");
        }
        return this.runAsIdentity;
    }

    public Hashtable getMethodContainerTransactions() {
        if (this.methodContainerTransactions == null) {
            this.methodContainerTransactions = new Hashtable();
        }
        return this.methodContainerTransactions;
    }

    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        if (this._setContainerTransactionFor(methodDescriptor, containerTransaction)) {
            this.changed();
        }
    }

    public void setContainerTransactionFor(Method method, ContainerTransaction containerTransaction) {
        this.setContainerTransactionFor(new MethodDescriptor(method), containerTransaction);
    }

    private boolean _setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        ContainerTransaction oldValue = this.getContainerTransactionFor(methodDescriptor);
        if (oldValue == null || oldValue != null && !oldValue.equals(containerTransaction)) {
            if (this.getTransactionType().equals(BEAN_TRANSACTION_TYPE)) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontxattrbtnotspecifiedinbeanwithtxtype", "Method level transaction attributes may not be specified on a bean with transaction type {0}", new Object[]{BEAN_TRANSACTION_TYPE}));
            }
            this.getMethodContainerTransactions().put(methodDescriptor, containerTransaction);
            return true;
        }
        return false;
    }

    private void removeContainerTransactionFor(MethodDescriptor methodDescriptor) {
        this.getMethodContainerTransactions().remove(methodDescriptor);
    }

    public void setMethodContainerTransactions(Hashtable methodContainerTransactions) {
        boolean wasThereAChange = false;
        if (methodContainerTransactions == null || methodContainerTransactions.isEmpty()) {
            this.methodContainerTransactions = null;
            wasThereAChange = true;
        } else {
            Enumeration e = methodContainerTransactions.keys();
            while (e.hasMoreElements()) {
                ContainerTransaction containerTransaction;
                MethodDescriptor methodDescriptor = (MethodDescriptor)e.nextElement();
                if (!this._setContainerTransactionFor(methodDescriptor, containerTransaction = (ContainerTransaction)methodContainerTransactions.get(methodDescriptor))) continue;
                wasThereAChange = true;
            }
        }
        if (wasThereAChange) {
            this.changed();
        }
    }

    Set getAllMethodDescriptors() {
        HashSet<Object> allMethodDescriptors = new HashSet<Object>();
        Enumeration e = this.getMethodContainerTransactions().keys();
        while (e.hasMoreElements()) {
            allMethodDescriptors.add(e.nextElement());
        }
        Iterator e2 = this.getPermissionedMethodsByPermission().keySet().iterator();
        while (e2.hasNext()) {
            MethodPermission nextPermission = (MethodPermission)e2.next();
            Set permissionedMethods = (Set)this.getPermissionedMethodsByPermission().get(nextPermission);
            Iterator itr = permissionedMethods.iterator();
            while (itr.hasNext()) {
                allMethodDescriptors.add(itr.next());
            }
        }
        return allMethodDescriptors;
    }

    public ContainerTransaction getContainerTransactionFor(MethodDescriptor methodDescriptor) {
        ContainerTransaction containerTransaction = null;
        if (this.needToConvertMethodContainerTransactions()) {
            this.convertMethodContainerTransactions();
        }
        if ((containerTransaction = (ContainerTransaction)this.getMethodContainerTransactions().get(methodDescriptor)) == null) {
            if (Descriptor.isBoundsChecking()) {
                containerTransaction = new ContainerTransaction(ContainerTransaction.REQUIRED, "");
                this.getMethodContainerTransactions().put(methodDescriptor, containerTransaction);
                this.changed();
            } else {
                containerTransaction = null;
            }
        }
        return containerTransaction;
    }

    private boolean needToConvertMethodContainerTransactions() {
        if (this.getEjbBundleDescriptor() != null) {
            Enumeration e = this.getMethodContainerTransactions().keys();
            while (e.hasMoreElements()) {
                MethodDescriptor md = (MethodDescriptor)e.nextElement();
                if (md.isExact()) continue;
                return true;
            }
        }
        return false;
    }

    private void convertMethodContainerTransactions() {
        Hashtable convertedTransactions = new Hashtable();
        this.convertMethodContainerTransactionsOfStyle(1, convertedTransactions);
        this.convertMethodContainerTransactionsOfStyle(2, convertedTransactions);
        this.convertMethodContainerTransactionsOfStyle(3, convertedTransactions);
        this.methodContainerTransactions = convertedTransactions;
    }

    private void convertMethodContainerTransactionsOfStyle(int requestedStyleForConversion, Hashtable convertedMethods) {
        Set transactionMethods = this.getTransactionMethodDescriptors();
        Hashtable transactions = this.getMethodContainerTransactions();
        Enumeration e = transactions.keys();
        while (e.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e.nextElement();
            if (md.getStyle() != requestedStyleForConversion) continue;
            ContainerTransaction ct = (ContainerTransaction)this.getMethodContainerTransactions().get(md);
            Enumeration mds = md.doStyleConversion(this, transactionMethods).elements();
            while (mds.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)mds.nextElement();
                convertedMethods.put(next, new ContainerTransaction(ct));
            }
        }
    }

    public ContainerTransaction getContainerTransactionFor(Method method) {
        MethodDescriptor md = new MethodDescriptor(method, this, ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader());
        return this.getContainerTransactionFor(md);
    }

    public ContainerTransaction getContainerTransaction() {
        Vector transactionalMethods = new Vector(this.getTransactionMethodDescriptors());
        MethodDescriptor md = (MethodDescriptor)transactionalMethods.firstElement();
        if (md != null) {
            ContainerTransaction first = this.getContainerTransactionFor(md);
            Enumeration e = transactionalMethods.elements();
            while (e.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)e.nextElement();
                ContainerTransaction nextCt = this.getContainerTransactionFor(next);
                if (nextCt == null || nextCt.equals(first)) continue;
                return null;
            }
            return first;
        }
        return null;
    }

    public Set getIORConfigurationDescriptors() {
        return this.iorConfigDescriptors;
    }

    public void addIORConfigurationDescriptor(EjbIORConfigurationDescriptor val) {
        this.iorConfigDescriptors.add(val);
        this.changed();
    }

    public Set getPermissionedRoles() {
        HashSet<Role> allPermissionedRoles = new HashSet<Role>();
        Iterator i = this.getPermissionedMethodsByPermission().keySet().iterator();
        while (i.hasNext()) {
            MethodPermission pm = (MethodPermission)i.next();
            if (!pm.isRoleBased()) continue;
            allPermissionedRoles.add(pm.getRole());
        }
        return allPermissionedRoles;
    }

    public Map getPermissionedMethodsByPermission() {
        if (this.permissionedMethodsByPermission == null) {
            this.permissionedMethodsByPermission = new Hashtable();
        }
        return this.permissionedMethodsByPermission;
    }

    public void addPermissionedMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesdescriptor", "Cannot add roles when the descriptor is not part of a bundle"));
        }
        if (mp.isRoleBased() && !this.getEjbBundleDescriptor().getRoles().contains(mp.getRole())) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesbundle", "Cannot add roles when the bundle does not have them"));
        }
        if (md.isExact()) {
            this.updateMethodPermissionForMethod(mp, md);
        } else {
            this.addMethodPermissionForStyledMethodDescriptor(mp, md);
        }
    }

    private void addMethodPermissionForMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getPermissionedMethodsByPermission().containsKey(mp)) {
            Set alreadyPermissionedMethodsForThisRole = (Set)this.getPermissionedMethodsByPermission().get(mp);
            alreadyPermissionedMethodsForThisRole.add(md);
            this.getPermissionedMethodsByPermission().put(mp, alreadyPermissionedMethodsForThisRole);
        } else {
            HashSet<MethodDescriptor> permissionedMethodsForThisRole = new HashSet<MethodDescriptor>();
            permissionedMethodsForThisRole.add(md);
            this.getPermissionedMethodsByPermission().put(mp, permissionedMethodsForThisRole);
        }
        this.changed();
    }

    public void removePermissionedMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncanotaddrolesdescriptor", "Cannot add roles when the descriptor is not part of a bundle"));
        }
        if (mp.isRoleBased() && !this.getEjbBundleDescriptor().getRoles().contains(mp.getRole())) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesbndledoesnothave", "Cannot add roles when the bundle does not have them"));
        }
        if (this.getPermissionedMethodsByPermission().containsKey(mp)) {
            Set alreadyPermissionedMethodsForThisRole = (Set)this.getPermissionedMethodsByPermission().get(mp);
            alreadyPermissionedMethodsForThisRole.remove(md);
            this.getPermissionedMethodsByPermission().put(mp, alreadyPermissionedMethodsForThisRole);
        }
        this.changed();
    }

    private void addMethodPermissionForStyledMethodDescriptor(MethodPermission mp, MethodDescriptor md) {
        HashSet<MethodPermission> permissions;
        if (this.styledMethodDescriptors == null) {
            this.styledMethodDescriptors = new HashMap();
        }
        if ((permissions = (HashSet<MethodPermission>)this.styledMethodDescriptors.get(md)) == null) {
            permissions = new HashSet<MethodPermission>();
        }
        permissions.add(mp);
        this.styledMethodDescriptors.put(md, permissions);
    }

    public Map getStyledPermissionedMethodsByPermission() {
        if (this.styledMethodDescriptors == null) {
            return null;
        }
        HashMap<MethodPermission, HashSet<MethodDescriptor>> styledMethodDescriptorsByPermission = new HashMap<MethodPermission, HashSet<MethodDescriptor>>();
        Iterator mdIterator = this.styledMethodDescriptors.keySet().iterator();
        while (mdIterator.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)mdIterator.next();
            Set methodPermissions = (Set)this.styledMethodDescriptors.get(md);
            Iterator mpIterator = methodPermissions.iterator();
            while (mpIterator.hasNext()) {
                MethodPermission mp = (MethodPermission)mpIterator.next();
                HashSet<MethodDescriptor> methodDescriptors = (HashSet<MethodDescriptor>)styledMethodDescriptorsByPermission.get(mp);
                if (methodDescriptors == null) {
                    methodDescriptors = new HashSet<MethodDescriptor>();
                }
                methodDescriptors.add(md);
                styledMethodDescriptorsByPermission.put(mp, methodDescriptors);
            }
        }
        return styledMethodDescriptorsByPermission;
    }

    public Set getUncheckedMethodDescriptors() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return (Set)this.getPermissionedMethodsByPermission().get(MethodPermission.getUncheckedMethodPermission());
    }

    public Set getExcludedMethodDescriptors() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return (Set)this.getPermissionedMethodsByPermission().get(MethodPermission.getExcludedMethodPermission());
    }

    private void convertMethodPermissions() {
        if (this.styledMethodDescriptors == null) {
            return;
        }
        Set allMethods = this.getMethodDescriptors();
        Set unpermissionedMethods = this.getMethodDescriptors();
        Set methodDescriptors = this.styledMethodDescriptors.keySet();
        Iterator styledMdItr = methodDescriptors.iterator();
        while (styledMdItr.hasNext()) {
            MethodDescriptor styledMd = (MethodDescriptor)styledMdItr.next();
            Set newPermissions = (Set)this.styledMethodDescriptors.get(styledMd);
            Vector mds = styledMd.doStyleConversion(this, allMethods);
            Iterator mdItr = ((AbstractList)mds).iterator();
            while (mdItr.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)mdItr.next();
                unpermissionedMethods.remove(md);
                Iterator newPermissionsItr = newPermissions.iterator();
                while (newPermissionsItr.hasNext()) {
                    MethodPermission newMp = (MethodPermission)newPermissionsItr.next();
                    this.updateMethodPermissionForMethod(newMp, md);
                }
            }
        }
        MethodPermission mp = MethodPermission.getUncheckedMethodPermission();
        Iterator iterator = unpermissionedMethods.iterator();
        while (iterator.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)iterator.next();
            if (!this.getMethodPermissions(md).isEmpty()) continue;
            this.addMethodPermissionForMethod(mp, md);
        }
        this.styledMethodDescriptors = null;
    }

    private void dumpMethodPermissions() {
        System.out.println("For Bean " + this.getName());
        Map allPermissions = this.getPermissionedMethodsByPermission();
        Set permissions = allPermissions.keySet();
        Iterator permissionsIterator = permissions.iterator();
        while (permissionsIterator.hasNext()) {
            MethodPermission mp = (MethodPermission)permissionsIterator.next();
            System.out.println(" Method Permission : " + mp);
            Set allMethods = (Set)this.getPermissionedMethodsByPermission().get(mp);
            Iterator methodIterator = allMethods.iterator();
            while (methodIterator.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)methodIterator.next();
                System.out.println(" -> " + md);
            }
        }
    }

    private void updateMethodPermissionForMethod(MethodPermission mp, MethodDescriptor md) {
        Set oldPermissions = this.getMethodPermissions(md);
        if (oldPermissions.isEmpty()) {
            this.addMethodPermissionForMethod(mp, md);
            return;
        }
        if (mp.isExcluded()) {
            Iterator oldPermissionsItr = oldPermissions.iterator();
            while (oldPermissionsItr.hasNext()) {
                MethodPermission oldMp = (MethodPermission)oldPermissionsItr.next();
                this.removePermissionedMethod(oldMp, md);
            }
            this.addMethodPermissionForMethod(mp, md);
        } else if (mp.isUnchecked()) {
            Iterator oldPermissionsItr = oldPermissions.iterator();
            while (oldPermissionsItr.hasNext()) {
                MethodPermission oldMp = (MethodPermission)oldPermissionsItr.next();
                if (oldMp.isExcluded()) continue;
                this.removePermissionedMethod(oldMp, md);
                this.addMethodPermissionForMethod(mp, md);
            }
        } else {
            Iterator oldPermissionsItr = oldPermissions.iterator();
            while (oldPermissionsItr.hasNext()) {
                MethodPermission oldMp = (MethodPermission)oldPermissionsItr.next();
                if (oldMp.isExcluded() || oldMp.isUnchecked()) continue;
                this.addMethodPermissionForMethod(mp, md);
            }
        }
    }

    private boolean needToConvertMethodPermissions() {
        return this.styledMethodDescriptors != null;
    }

    public Set getMethodPermissionsFor(Method method) {
        return this.getMethodPermissionsFor(new MethodDescriptor(method, this, ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader()));
    }

    public Set getMethodPermissionsFor(MethodDescriptor methodDescriptor) {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return this.getMethodPermissions(methodDescriptor);
    }

    private Set getMethodPermissions(MethodDescriptor methodDescriptor) {
        HashSet<MethodPermission> methodPermissionsForMethod = new HashSet<MethodPermission>();
        Iterator e = this.getPermissionedMethodsByPermission().keySet().iterator();
        while (e.hasNext()) {
            MethodPermission nextPermission = (MethodPermission)e.next();
            Set permissionedMethods = (Set)this.getPermissionedMethodsByPermission().get(nextPermission);
            Iterator itr = permissionedMethods.iterator();
            while (itr.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)itr.next();
                if (!md.equals(methodDescriptor)) continue;
                methodPermissionsForMethod.add(nextPermission);
            }
        }
        return methodPermissionsForMethod;
    }

    public Set getEjbReferenceDescriptors() {
        if (this.ejbReferences == null) {
            this.ejbReferences = new OrderedSet();
        }
        this.ejbReferences = new OrderedSet((Collection)this.ejbReferences);
        return this.ejbReferences;
    }

    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.getEjbReferenceDescriptors().add(ejbReference);
        ejbReference.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
        this.changed();
    }

    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.getEjbReferenceDescriptors().remove(ejbReference);
        ejbReference.setReferringBundleDescriptor(null);
        this.changed();
    }

    public Set getJmsDestinationReferenceDescriptors() {
        if (this.jmsDestReferences == null) {
            this.jmsDestReferences = new OrderedSet();
        }
        this.jmsDestReferences = new OrderedSet((Collection)this.jmsDestReferences);
        return this.jmsDestReferences;
    }

    public void addJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.getJmsDestinationReferenceDescriptors().add(jmsDestReference);
        this.changed();
    }

    public void removeJmsDestinationReferenceDescriptor(JmsDestinationReferenceDescriptor jmsDestReference) {
        this.getJmsDestinationReferenceDescriptors().remove(jmsDestReference);
        this.changed();
    }

    public Set getResourceReferenceDescriptors() {
        if (this.resourceReferences == null) {
            this.resourceReferences = new OrderedSet();
        }
        this.resourceReferences = new OrderedSet((Collection)this.resourceReferences);
        return this.resourceReferences;
    }

    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().add(resourceReference);
        this.changed();
    }

    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.getResourceReferenceDescriptors().remove(resourceReference);
        this.changed();
    }

    public Set getResourceReferenceDescriptors(boolean resolved) {
        HashSet<ResourceReferenceDescriptor> toReturn = new HashSet<ResourceReferenceDescriptor>();
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr.next();
            if (next.isResolved() != resolved) continue;
            toReturn.add(next);
        }
        return toReturn;
    }

    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        Iterator itr = this.getEnvironmentProperties().iterator();
        while (itr.hasNext()) {
            EnvironmentProperty ev = (EnvironmentProperty)itr.next();
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoenvpropertybyname", "This bean has no environment property by the name of {0}", new Object[]{name}));
    }

    public EjbReferenceDescriptor getEjbReferenceByName(String name) {
        Iterator itr = this.getEjbReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            EjbReferenceDescriptor er = (EjbReferenceDescriptor)itr.next();
            if (!er.getName().equals(name)) continue;
            return er;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoejbrefbyname", "This bean has no ejb reference by the name of {0}", new Object[]{name}));
    }

    public JmsDestinationReferenceDescriptor getJmsDestinationReferenceByName(String name) {
        Iterator itr = this.getJmsDestinationReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            JmsDestinationReferenceDescriptor jdr = (JmsDestinationReferenceDescriptor)itr.next();
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnojmsdestrefbyname", "This bean has no JMS destination reference by the name of {0}", new Object[]{name}));
    }

    public void replaceEnvironmentProperty(EnvironmentProperty oldOne, EnvironmentProperty newOne) {
        this.getEnvironmentProperties().remove(oldOne);
        this.getEnvironmentProperties().add(newOne);
        this.changed();
    }

    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
        this.changed();
    }

    void removeRole(Role role) {
        this.getPermissionedMethodsByPermission().remove(new MethodPermission(role));
        HashSet roleReferences = new HashSet(this.getRoleReferences());
        Iterator itr = roleReferences.iterator();
        while (itr.hasNext()) {
            RoleReference roleReference = (RoleReference)itr.next();
            if (!roleReference.getRole().equals(role)) continue;
            roleReference.setValue("");
        }
    }

    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoresourcerefbyname", "This bean has no resource reference by the name of {0}", new Object[]{name}));
    }

    public boolean hasResolvedResourceReferences() {
        if (!this.getResourceReferenceDescriptors().isEmpty()) {
            return false;
        }
        Iterator itr = this.getResourceReferenceDescriptors().iterator();
        while (itr.hasNext()) {
            ResourceReferenceDescriptor resourceReference = (ResourceReferenceDescriptor)itr.next();
            if (!resourceReference.isResolved()) continue;
            return true;
        }
        return false;
    }

    public Set getEnvironmentProperties() {
        if (this.environmentProperties == null) {
            this.environmentProperties = new OrderedSet();
        }
        this.environmentProperties = new OrderedSet((Collection)this.environmentProperties);
        return this.environmentProperties;
    }

    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (this.getEnvironmentProperties().contains(environmentProperty)) {
            this.replaceEnvironmentProperty(environmentProperty, environmentProperty);
        } else {
            this.getEnvironmentProperties().add(environmentProperty);
        }
        this.changed();
    }

    public Set getRoleReferences() {
        if (this.roleReferences == null) {
            this.roleReferences = new HashSet();
        }
        this.roleReferences = new HashSet(this.roleReferences);
        return this.roleReferences;
    }

    public void addRoleReference(RoleReference roleReference) {
        this.getRoleReferences().add(roleReference);
        this.changed();
    }

    public void removeRoleReference(RoleReference roleReference) {
        this.getRoleReferences().remove(roleReference);
        this.changed();
    }

    public RoleReference getRoleReferenceByName(String roleReferenceName) {
        Iterator itr = this.getRoleReferences().iterator();
        while (itr.hasNext()) {
            RoleReference nextRR = (RoleReference)itr.next();
            if (!nextRR.getName().equals(roleReferenceName)) continue;
            return nextRR;
        }
        return null;
    }

    public EjbBundleDescriptor getEjbBundleDescriptor() {
        return this.bundleDescriptor;
    }

    void setEjbBundleDescriptor(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
    }

    public Application getApplication() {
        if (this.getEjbBundleDescriptor() != null) {
            return this.getEjbBundleDescriptor().getApplication();
        }
        return null;
    }

    public Set getMethodDescriptors() {
        ClassLoader classLoader = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        HashSet methods = new HashSet();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getHomeClassName()), MethodDescriptor.EJB_HOME);
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getRemoteClassName()), MethodDescriptor.EJB_REMOTE);
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getLocalHomeClassName()), MethodDescriptor.EJB_LOCALHOME);
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getLocalClassName()), MethodDescriptor.EJB_LOCAL);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingclass", "Error loading class {0}", new Object[]{"(EjbDesciptor.getMethods())"}));
            throw new RuntimeException(t.getMessage());
        }
        return methods;
    }

    private void addAllInterfaceMethodsIn(Collection methodDescriptors, Class c, String methodIntf) {
        Method[] methods = c.getMethods();
        int i = 0;
        while (i < methods.length) {
            methodDescriptors.add(new MethodDescriptor(methods[i], methodIntf));
            ++i;
        }
    }

    public Set getTransactionMethodDescriptors() {
        HashSet<MethodDescriptor> s = new HashSet<MethodDescriptor>();
        ClassLoader classLoader = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
        Iterator iterator = this.getTransactionMethods(classLoader).iterator();
        while (iterator.hasNext()) {
            Method m = (Method)iterator.next();
            s.add(new MethodDescriptor(m, this, classLoader));
        }
        return s;
    }

    protected Collection getTransactionMethods(ClassLoader classLoader) {
        try {
            return BeanMethodCalculator.getTransactionalMethodsFor((EjbDescriptor)this, (ClassLoader)classLoader);
        }
        catch (Throwable t) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingclass", "Error loading class {0}", new Object[]{"(EjbDesciptor.getMethods())"}));
            throw new RuntimeException(t.getMessage());
        }
    }

    public Vector getMethods() {
        return this.getMethods(((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader());
    }

    public Vector getMethods(ClassLoader classLoader) {
        try {
            return BeanMethodCalculator.getMethodsFor((EjbDescriptor)this, (ClassLoader)classLoader);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingclass", "Error loading class {0}", new Object[]{"(EjbDesciptor.getMethods())"}));
            throw new RuntimeException(t.getMessage());
        }
    }

    private Method getMethodForName(String methodName, ClassLoader classLoader) {
        Enumeration e = this.getMethods(classLoader).elements();
        while (e.hasMoreElements()) {
            Method m = (Method)e.nextElement();
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public Method getMethodFor(MethodDescriptor methodDescriptor, ClassLoader classLoader) {
        return this.getMethodForName(methodDescriptor.getName(), classLoader);
    }

    public Vector getFields() {
        Vector<Field> fieldsVector = new Vector<Field>();
        Class<?> ejb = null;
        try {
            ClassLoader cl = ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader();
            ejb = cl.loadClass(this.getEjbClassName());
        }
        catch (Throwable t) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingejbclass", "error loading the ejb class {0} in getFields on EjbDescriptor\n {1}", new Object[]{this.getEjbClassName(), t.toString()}));
            return fieldsVector;
        }
        Field[] fields = ejb.getFields();
        int i = 0;
        while (i < fields.length) {
            fieldsVector.addElement(fields[i]);
            ++i;
        }
        return fieldsVector;
    }

    public Vector getFieldDescriptors() {
        Vector fields = this.getFields();
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        int fieldIndex = 0;
        while (fieldIndex < fields.size()) {
            Field field = (Field)fields.elementAt(fieldIndex);
            fieldDescriptors.insertElementAt(new FieldDescriptor(field), fieldIndex);
            ++fieldIndex;
        }
        return fieldDescriptors;
    }

    public Field getFieldFor(FieldDescriptor fieldDescriptor) {
        return this.getFieldForName(fieldDescriptor.getName());
    }

    public Field getFieldForName(String fieldName) {
        Class<?> ejb = null;
        try {
            ClassLoader cl = this.getApplication().getApplicationArchivist().getClassLoader();
            ejb = cl.loadClass(this.getEjbClassName());
        }
        catch (Throwable t) {
            System.out.println(localStrings.getLocalString("enterprise.deployment.errorloadingejbclassingetfieldname", "error loading the ejb class in getFieldForName on EjbDescriptor {0}", new Object[]{this.getApplication().getApplicationArchivist().getClassLoader()}));
            return null;
        }
        Field[] fields = ejb.getFields();
        int i = 0;
        while (i < fields.length) {
            Field nextField = fields[i];
            if (nextField.getName().equals(fieldName)) {
                return nextField;
            }
            ++i;
        }
        return null;
    }

    void doMethodDescriptorConversions() throws Exception {
        Hashtable transactions = this.getMethodContainerTransactions();
        Hashtable<MethodDescriptor, ContainerTransaction> convertedTransactions = new Hashtable<MethodDescriptor, ContainerTransaction>();
        Set transactionMethods = this.getTransactionMethodDescriptors();
        Enumeration e = transactions.keys();
        while (e.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e.nextElement();
            ContainerTransaction ct = (ContainerTransaction)transactions.get(md);
            Enumeration mds = md.doStyleConversion(this, transactionMethods).elements();
            while (mds.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)mds.nextElement();
                convertedTransactions.put(next, new ContainerTransaction(ct));
            }
        }
        this.setMethodContainerTransactions(convertedTransactions);
        this.convertMethodPermissions();
    }

    public void removeEjbReferencer(EjbReferenceDescriptor ref) {
        this.ejbReferencersPointingToMe.remove(ref);
    }

    void addEjbReferencer(EjbReferenceDescriptor ref) {
        this.ejbReferencersPointingToMe.add(ref);
    }

    public Set getAllEjbReferencers() {
        return this.ejbReferencersPointingToMe;
    }

    void setUniqueId(long id) {
        this.uniqueId = id;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public String getLocalJndiName() {
        if (this.getApplication() != null) {
            return "localejbs/" + this.getApplication().getName() + "/" + this.getName() + this.getUniqueId();
        }
        return null;
    }

    public void changed() {
        if (this.getEjbBundleDescriptor() != null) {
            this.getEjbBundleDescriptor().changed();
        } else {
            super.changed();
        }
    }

    public String toString() {
        String s = super.toString();
        s = s + "\n ejbClassName " + this.ejbClassName;
        s = s + "\n containerTransaction " + this.containerTransaction;
        s = s + "\n transactionType " + this.transactionType;
        s = s + "\n methodContainerTransactions " + this.getMethodContainerTransactions();
        s = s + "\n environmentProperties " + this.environmentProperties;
        s = s + "\n ejbReferences " + this.ejbReferences;
        s = s + "\n jmsDestReferences " + this.jmsDestReferences;
        s = s + "\n resourceReferences " + this.resourceReferences;
        s = s + "\n roleReferences " + this.roleReferences;
        Iterator e = this.getPermissionedMethodsByPermission().keySet().iterator();
        while (e.hasNext()) {
            MethodPermission nextPermission = (MethodPermission)e.next();
            s = s + "\n method-permission->method: " + nextPermission + " -> " + this.getPermissionedMethodsByPermission().get(nextPermission);
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

