/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.EjbNode;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.acl.Role;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import org.apache.crimson.tree.ElementNode;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class EjbBundleNode
extends ElementNode {
    public static String PUBLIC_DTD_ID_12 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static String SYSTEM_ID = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";

    public EjbBundleNode() {
        this.setTag("ejb-jar");
    }

    public void setDescriptor(EjbBundleDescriptor bundleDescriptor) {
        Document doc = this.getOwnerDocument();
        if (doc == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(factory, bundleDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        ElementNode ejbsNode = factory.getNode("enterprise-beans");
        this.appendChild((Node)ejbsNode);
        Iterator itr = bundleDescriptor.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            EjbNode ejbNode = new EjbNode();
            ejbsNode.appendChild((Node)((Object)ejbNode));
            ejbNode.setDescriptor(nextEjbDescriptor);
        }
        if (bundleDescriptor.hasRelationships()) {
            this.setRelationships(factory, bundleDescriptor);
        }
        if (bundleDescriptor.hasAssemblyInformation()) {
            Map styledPermissionedMethodsByPermission;
            Map permissionedMethodsByPermission;
            EjbDescriptor ejbDescriptor;
            ElementNode assemblyDescriptorNode = factory.getNode("assembly-descriptor");
            this.appendChild((Node)assemblyDescriptorNode);
            Iterator itr2 = bundleDescriptor.getRoles().iterator();
            while (itr2.hasNext()) {
                Role nextRole = (Role)itr2.next();
                ElementNode roleNode = factory.getNode("security-role");
                assemblyDescriptorNode.appendChild((Node)roleNode);
                if (!nextRole.getDescription().equals("")) {
                    roleNode.appendChild((Node)factory.getTextNode("description", nextRole.getDescription()));
                }
                roleNode.appendChild((Node)factory.getTextNode("role-name", nextRole.getName()));
            }
            itr2 = bundleDescriptor.getEjbs().iterator();
            while (itr2.hasNext()) {
                ejbDescriptor = (EjbDescriptor)itr2.next();
                permissionedMethodsByPermission = ejbDescriptor.getPermissionedMethodsByPermission();
                this.setMethodDescriptor(factory, permissionedMethodsByPermission, assemblyDescriptorNode, ejbDescriptor);
                styledPermissionedMethodsByPermission = ejbDescriptor.getStyledPermissionedMethodsByPermission();
                this.setMethodDescriptor(factory, styledPermissionedMethodsByPermission, assemblyDescriptorNode, ejbDescriptor);
            }
            Iterator ejbs = bundleDescriptor.getEjbs().iterator();
            while (ejbs.hasNext()) {
                ejbDescriptor = (EjbDescriptor)ejbs.next();
                if (ejbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
                Enumeration e = ejbDescriptor.getMethodContainerTransactions().keys();
                while (e.hasMoreElements()) {
                    MethodDescriptor nextMethodDescriptor = (MethodDescriptor)e.nextElement();
                    ContainerTransaction methodContainerTransaction = (ContainerTransaction)ejbDescriptor.getMethodContainerTransactions().get(nextMethodDescriptor);
                    ElementNode containerTransactionNode = factory.getNode("container-transaction");
                    assemblyDescriptorNode.appendChild((Node)containerTransactionNode);
                    if (!methodContainerTransaction.getDescription().equals("")) {
                        containerTransactionNode.appendChild((Node)factory.getTextNode("description", methodContainerTransaction.getDescription()));
                    }
                    MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
                    containerTransactionNode.appendChild((Node)((Object)methodDescriptorNode));
                    methodDescriptorNode.setDescriptor(nextMethodDescriptor, ejbDescriptor);
                    containerTransactionNode.appendChild((Node)factory.getTextNode("trans-attribute", methodContainerTransaction.getTransactionAttribute()));
                }
            }
            itr2 = bundleDescriptor.getEjbs().iterator();
            while (itr2.hasNext()) {
                Collection excludedStyledMethodDescriptors;
                ejbDescriptor = (EjbDescriptor)itr2.next();
                permissionedMethodsByPermission = ejbDescriptor.getPermissionedMethodsByPermission();
                styledPermissionedMethodsByPermission = ejbDescriptor.getStyledPermissionedMethodsByPermission();
                Vector excludedMethodDescriptors = (Vector)permissionedMethodsByPermission.get(MethodPermission.getExcludedMethodPermission());
                if (styledPermissionedMethodsByPermission != null && (excludedStyledMethodDescriptors = (Collection)styledPermissionedMethodsByPermission.get(MethodPermission.getExcludedMethodPermission())) != null) {
                    if (excludedMethodDescriptors == null) {
                        excludedMethodDescriptors = new Vector();
                    }
                    excludedMethodDescriptors.addAll(excludedStyledMethodDescriptors);
                }
                if (excludedMethodDescriptors == null || excludedMethodDescriptors.isEmpty()) continue;
                ElementNode excludedMethodNode = factory.getNode("exclude-list");
                assemblyDescriptorNode.appendChild((Node)excludedMethodNode);
                this.addMethodsTags(excludedMethodNode, excludedMethodDescriptors, ejbDescriptor);
            }
        }
        if (!"".equals(bundleDescriptor.getEjbClientJarUri())) {
            this.appendChild((Node)factory.getTextNode("ejb-client-jar", bundleDescriptor.getEjbClientJarUri()));
        }
    }

    private void setMethodDescriptor(XMLUtils factory, Map permissionedMethodsByPermission, ElementNode assemblyDescriptorNode, EjbDescriptor ejbDescriptor) {
        if (permissionedMethodsByPermission == null) {
            return;
        }
        Iterator e = permissionedMethodsByPermission.keySet().iterator();
        while (e.hasNext()) {
            Set permissionedMethods;
            MethodPermission permission = (MethodPermission)e.next();
            if (permission.isExcluded() || (permissionedMethods = (Set)permissionedMethodsByPermission.get(permission)).isEmpty()) continue;
            ElementNode methodPermissionNode = factory.getNode("method-permission");
            assemblyDescriptorNode.appendChild((Node)methodPermissionNode);
            if (permission.isRoleBased()) {
                methodPermissionNode.appendChild((Node)factory.getTextNode("role-name", permission.getRole().getName()));
            } else {
                methodPermissionNode.appendChild((Node)factory.getNode("unchecked"));
            }
            this.addMethodsTags(methodPermissionNode, permissionedMethods, ejbDescriptor);
        }
    }

    public EjbBundleDescriptor getDescriptor() throws ContentTransformationException {
        EjbBundleNode currentNode = this;
        try {
            EjbBundleDescriptor ejbBundleDescriptor = new EjbBundleDescriptor();
            ejbBundleDescriptor.setEJBVersion("EJB 2.x");
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbBundleDescriptor, DescriptorNodeUtils.EJB_STYLE);
            HashSet<EjbNode> ejbNodes = new HashSet<EjbNode>();
            Enumeration e = XMLUtils.getNodesUnder((Node)((Object)this), EjbNode.getTags());
            while (e.hasMoreElements()) {
                EjbNode nextEjbNode = (EjbNode)((Object)e.nextElement());
                nextEjbNode.setEjbBundleDescriptor(ejbBundleDescriptor);
                EjbDescriptor ejbDescriptor = nextEjbNode.getDescriptor();
                if (ejbDescriptor == null) continue;
                ejbNodes.add(nextEjbNode);
                ejbBundleDescriptor.addEjb(ejbDescriptor);
            }
            this.getRelationships(ejbBundleDescriptor);
            return ejbBundleDescriptor;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new ContentTransformationException(iae.getMessage(), currentNode.toString());
        }
    }

    private void addMethodTag(ElementNode elementNode, MethodDescriptor md, EjbDescriptor ejbDescriptor) {
        MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
        elementNode.appendChild((Node)((Object)methodDescriptorNode));
        methodDescriptorNode.setDescriptor(md, ejbDescriptor);
    }

    private void addMethodsTags(ElementNode elementNode, Collection mds, EjbDescriptor ejbDescriptor) {
        Iterator iterator = mds.iterator();
        while (iterator.hasNext()) {
            this.addMethodTag(elementNode, (MethodDescriptor)iterator.next(), ejbDescriptor);
        }
    }

    private void addEJBReference(EjbBundleDescriptor ejbBundleDescriptor, EjbDescriptor referingBean, ElementNode ejbReferenceNode, boolean isLocal) {
        String interfaceClassName;
        String homeClassName;
        String description = "";
        if (XMLUtils.getFirstNodeUnder((Node)ejbReferenceNode, "description") != null) {
            description = XMLUtils.getTextFor(ejbReferenceNode, "description");
        }
        String ejbReferenceName = XMLUtils.getTextFor(ejbReferenceNode, "ejb-ref-name");
        if (isLocal) {
            homeClassName = XMLUtils.getTextFor(ejbReferenceNode, "local-home");
            interfaceClassName = XMLUtils.getTextFor(ejbReferenceNode, "local");
        } else {
            homeClassName = XMLUtils.getTextFor(ejbReferenceNode, "home");
            interfaceClassName = XMLUtils.getTextFor(ejbReferenceNode, "remote");
        }
        String referenceType = XMLUtils.getTextFor(ejbReferenceNode, "ejb-ref-type");
        if (XMLUtils.hasNodesUnder((Node)ejbReferenceNode, "ejb-link")) {
            String ejbRefereeName = XMLUtils.getTextFor(ejbReferenceNode, "ejb-link");
            if (!ejbBundleDescriptor.hasEjbByName(ejbRefereeName)) {
                EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
                ejbExternalDescriptor.setName(ejbRefereeName);
                if (isLocal) {
                    ejbExternalDescriptor.setLocalHomeClassName(homeClassName);
                    ejbExternalDescriptor.setLocalClassName(interfaceClassName);
                } else {
                    ejbExternalDescriptor.setHomeClassName(homeClassName);
                    ejbExternalDescriptor.setRemoteClassName(interfaceClassName);
                }
                ejbExternalDescriptor.setType(referenceType);
                ejbExternalDescriptor.setLinkName(ejbRefereeName);
                EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, ejbExternalDescriptor, isLocal);
                referingBean.addEjbReferenceDescriptor(ejbRef);
            } else {
                EjbDescriptor refereeBean = ejbBundleDescriptor.getEjbByName(ejbRefereeName);
                if (isLocal) {
                    DescriptorNodeUtils.checkEjbLocalReference(refereeBean, referenceType, homeClassName, interfaceClassName, ejbRefereeName);
                } else {
                    DescriptorNodeUtils.checkEjbReference(refereeBean, referenceType, homeClassName, interfaceClassName, ejbRefereeName);
                }
                EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, refereeBean, isLocal);
                referingBean.addEjbReferenceDescriptor(ejbRef);
            }
        } else {
            String uniqueName = EjbReferenceDescriptor.createUniqueNameAmongstNamedDescriptors("ExternalRef", referingBean.getEjbReferenceDescriptors());
            EjbExternalDescriptor ejbExternalDescriptor = new EjbExternalDescriptor();
            ejbExternalDescriptor.setName(uniqueName);
            if (isLocal) {
                ejbExternalDescriptor.setLocalHomeClassName(homeClassName);
                ejbExternalDescriptor.setLocalClassName(interfaceClassName);
            } else {
                ejbExternalDescriptor.setHomeClassName(homeClassName);
                ejbExternalDescriptor.setRemoteClassName(interfaceClassName);
            }
            ejbExternalDescriptor.setType(referenceType);
            EjbReferenceDescriptor ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, ejbExternalDescriptor, isLocal);
            referingBean.addEjbReferenceDescriptor(ejbRef);
        }
    }

    public void completeLoadingDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        Enumeration e = XMLUtils.getNodesUnder((Node)((Object)this), "entity");
        while (e.hasMoreElements()) {
            EjbNode nextEjbNode = (EjbNode)((Object)e.nextElement());
            String ejbName = XMLUtils.getTextFor(nextEjbNode, "ejb-name");
            EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
            nextEjbNode.completeLoadingDescriptor(ejbDescriptor);
        }
    }

    private void setRelationships(XMLUtils factory, EjbBundleDescriptor bundleDescriptor) {
        if (bundleDescriptor.getRelationships().size() == 0) {
            return;
        }
        ElementNode relsNode = factory.getNode("relationships");
        this.appendChild((Node)relsNode);
        if (!bundleDescriptor.getRelationshipsDescription().equals("")) {
            relsNode.appendChild((Node)factory.getTextNode("description", bundleDescriptor.getRelationshipsDescription()));
        }
        Iterator itr = bundleDescriptor.getRelationships().iterator();
        while (itr.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
            ElementNode rNode = factory.getNode("ejb-relation");
            relsNode.appendChild((Node)rNode);
            if (!rd.getDescription().equals("")) {
                rNode.appendChild((Node)factory.getTextNode("description", rd.getDescription()));
            }
            rNode.appendChild((Node)factory.getTextNode("ejb-relation-name", rd.getName()));
            this.storeEjbRelationRole(rNode, rd.getSource(), factory);
            this.storeEjbRelationRole(rNode, rd.getSink(), factory);
        }
    }

    private void storeEjbRelationRole(ElementNode ejbRelationNode, RelationRoleDescriptor rrd, XMLUtils factory) {
        ElementNode roleNode = factory.getNode("ejb-relationship-role");
        String desc = rrd.getDescription();
        if (desc != null && !desc.equals("")) {
            roleNode.appendChild((Node)factory.getTextNode("description", desc));
        }
        roleNode.appendChild((Node)factory.getTextNode("ejb-relationship-role-name", rrd.getName()));
        roleNode.appendChild((Node)factory.getTextNode("multiplicity", rrd.getIsMany() ? "Many" : "One"));
        if (rrd.getCascadeDelete()) {
            roleNode.appendChild((Node)factory.getNode("cascade-delete"));
        }
        ElementNode roleSourceNode = factory.getNode("relationship-role-source");
        if (!rrd.getRoleSourceDescription().equals("")) {
            roleNode.appendChild((Node)factory.getTextNode("description", rrd.getRoleSourceDescription()));
        }
        roleSourceNode.appendChild((Node)factory.getTextNode("ejb-name", rrd.getOwner().getName()));
        roleNode.appendChild((Node)roleSourceNode);
        if (rrd.getCMRField() != null) {
            ElementNode cmrFieldNode = factory.getNode("cmr-field");
            if (!rrd.getCMRFieldDescription().equals("")) {
                cmrFieldNode.appendChild((Node)factory.getTextNode("description", rrd.getCMRFieldDescription()));
            }
            cmrFieldNode.appendChild((Node)factory.getTextNode("cmr-field-name", rrd.getCMRField()));
            String type = rrd.getCMRFieldType();
            if (type != null && !type.equals("")) {
                cmrFieldNode.appendChild((Node)factory.getTextNode("cmr-field-type", type));
            }
            roleNode.appendChild((Node)cmrFieldNode);
        }
        ejbRelationNode.appendChild((Node)roleNode);
    }

    private void getRelationships(EjbBundleDescriptor bundleDescriptor) {
        ElementNode relnsNode = XMLUtils.getFirstNodeUnder((Node)((Object)this), "relationships");
        if (relnsNode == null) {
            return;
        }
        if (XMLUtils.hasNodesUnder((Node)relnsNode, "description")) {
            String d = XMLUtils.getTextFor(relnsNode, "description");
            bundleDescriptor.setRelationshipsDescription(d);
        }
        Enumeration e2 = XMLUtils.getNodesUnder((Node)relnsNode, "ejb-relation");
        while (e2.hasMoreElements()) {
            ElementNode rNode = (ElementNode)e2.nextElement();
            RelationshipDescriptor relnDesc = new RelationshipDescriptor();
            if (XMLUtils.hasNodesUnder((Node)rNode, "description")) {
                String d = XMLUtils.getTextFor(rNode, "description");
                relnDesc.setDescription(d);
            }
            if (XMLUtils.hasNodesUnder((Node)rNode, "ejb-relation-name")) {
                String rname = XMLUtils.getTextFor(rNode, "ejb-relation-name");
                relnDesc.setName(rname);
            }
            Enumeration roles = XMLUtils.getNodesUnder((Node)rNode, "ejb-relationship-role");
            ElementNode roleNode = (ElementNode)roles.nextElement();
            RelationRoleDescriptor source = this.loadEjbRelationRole(roleNode, bundleDescriptor);
            roleNode = (ElementNode)roles.nextElement();
            RelationRoleDescriptor sink = this.loadEjbRelationRole(roleNode, bundleDescriptor);
            source.setPartner(sink);
            sink.setPartner(source);
            relnDesc.setSource(source);
            source.setRelationshipDescriptor(relnDesc);
            relnDesc.setSink(sink);
            sink.setRelationshipDescriptor(relnDesc);
            if (source.getCMRField() != null && sink.getCMRField() != null) {
                relnDesc.setIsBidirectional(true);
            } else {
                relnDesc.setIsBidirectional(false);
            }
            String msg1 = "ERROR: Cascade-delete can only be specified if the other role has a multiplicity of ONE";
            if (source.getCascadeDelete() && sink.getIsMany()) {
                throw new EJBException(msg1);
            }
            if (sink.getCascadeDelete() && source.getIsMany()) {
                throw new EJBException(msg1);
            }
            bundleDescriptor.addRelationship(relnDesc);
        }
    }

    private RelationRoleDescriptor loadEjbRelationRole(ElementNode roleNode, EjbBundleDescriptor bundleDesc) {
        ElementNode fieldNode;
        RelationRoleDescriptor role = new RelationRoleDescriptor();
        if (XMLUtils.hasNodesUnder((Node)roleNode, "description")) {
            String d = XMLUtils.getTextFor(roleNode, "description");
            role.setDescription(d);
        }
        String rname = XMLUtils.getTextFor(roleNode, "ejb-relationship-role-name");
        role.setName(rname);
        String mul = XMLUtils.getTextFor(roleNode, "multiplicity");
        if (mul.equals("Many")) {
            role.setIsMany(true);
        } else if (mul.equals("One")) {
            role.setIsMany(false);
        } else if (mul.equals("many")) {
            role.setIsMany(true);
        } else if (mul.equals("one")) {
            role.setIsMany(false);
        } else {
            throw new RuntimeException("Error in value of multiplicity element in EJB deployment descriptor XML: the value must be One or Many");
        }
        ElementNode sourceNode = XMLUtils.getFirstNodeUnder((Node)roleNode, "relationship-role-source");
        if (XMLUtils.hasNodesUnder((Node)sourceNode, "description")) {
            String d = XMLUtils.getTextFor(sourceNode, "description");
            role.setRoleSourceDescription(d);
        }
        String ejbName = XMLUtils.getTextFor(sourceNode, "ejb-name");
        EjbCMPEntityDescriptor desc = (EjbCMPEntityDescriptor)bundleDesc.getEjbByName(ejbName);
        role.setPersistenceDescriptor(desc.getPersistenceDescriptor());
        if (XMLUtils.hasNodesUnder((Node)roleNode, "cascade-delete")) {
            role.setCascadeDelete(true);
        }
        if ((fieldNode = XMLUtils.getFirstNodeUnder((Node)roleNode, "cmr-field")) != null) {
            if (XMLUtils.hasNodesUnder((Node)fieldNode, "description")) {
                String d = XMLUtils.getTextFor(fieldNode, "description");
                role.setCMRFieldDescription(d);
            }
            role.setCMRField(XMLUtils.getTextFor(fieldNode, "cmr-field-name"));
            if (XMLUtils.hasNodesUnder((Node)fieldNode, "cmr-field-type")) {
                role.setCMRFieldType(XMLUtils.getTextFor(fieldNode, "cmr-field-type"));
            }
        }
        return role;
    }

    public static Vector readEjbBundleNodes(InputStream is) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("ejb-jar", "com.sun.enterprise.deployment.xml.EjbBundleNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(EjbBundleNode.class, nodeToClass, is);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ParseException(t.getMessage());
        }
    }

    public static Vector readEjbBundleNodes(InputStream is, EntityResolver er) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("ejb-jar", "com.sun.enterprise.deployment.xml.EjbBundleNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("message-driven", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(EjbBundleNode.class, nodeToClass, is, er);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ParseException(t.getMessage());
        }
    }

    public static XmlDocument getDocument(EjbBundleDescriptor ejbBundleDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        EjbBundleNode n = new EjbBundleNode();
        xmlDocument.appendChild((Node)((Object)n));
        n.setDescriptor(ejbBundleDescriptor);
        return xmlDocument;
    }

    public static EjbBundleNode read(InputStream is) throws ParseException {
        Vector ejbBundleNodes = EjbBundleNode.readEjbBundleNodes(is);
        if (ejbBundleNodes.size() > 0) {
            return (EjbBundleNode)((Object)ejbBundleNodes.elementAt(0));
        }
        return null;
    }

    public static EjbBundleNode read(InputStream is, EntityResolver er) throws ParseException {
        Vector ejbBundleNodes = EjbBundleNode.readEjbBundleNodes(is, er);
        if (ejbBundleNodes.size() > 0) {
            return (EjbBundleNode)((Object)ejbBundleNodes.elementAt(0));
        }
        return null;
    }
}

