/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.transaction.xa.Xid;

class FileStorePooledFileChannel {
    private FileOutputStream m_fout;
    private FileChannel m_fileChannel;
    private Xid m_xid;
    private long m_timeCreated;
    private String m_fileName;

    FileStorePooledFileChannel(Xid xid, FileOutputStream fout, String fileName) {
        this.m_fout = fout;
        this.m_fileChannel = this.m_fout.getChannel();
        this.m_xid = xid;
        this.m_timeCreated = System.currentTimeMillis();
        this.m_fileName = fileName;
    }

    FileOutputStream getFileOutputStream() {
        return this.m_fout;
    }

    Xid getXid() {
        return this.m_xid;
    }

    long getTimeCreated() {
        return this.m_timeCreated;
    }

    String getFileName() {
        return this.m_fileName;
    }

    void closeFileOutputStream() throws IOException {
        this.m_fout.close();
    }

    FileChannel truncate(long size) throws IOException {
        return this.m_fileChannel.truncate(size);
    }

    long write(ByteBuffer[] src) throws IOException {
        return this.m_fileChannel.write(src);
    }

    void force(boolean metaData) throws IOException {
        this.m_fileChannel.force(metaData);
    }

    FileChannel position(long newPosition) throws IOException {
        return this.m_fileChannel.position(newPosition);
    }

    long size() throws IOException {
        return this.m_fileChannel.size();
    }
}

