/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.server.ApplicationServerTransactionManager;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.LogPresumption;
import oracle.as.j2ee.transaction.tpc.RecoverableSinglePhaseResourceReaperTask;
import oracle.as.j2ee.transaction.tpc.Store;

public class PresumedNothingStrategy
implements LogPresumption {
    private Store m_store;
    private boolean m_wasPreparing = true;
    private boolean m_usingRLRC = false;

    public PresumedNothingStrategy(Store store) {
        this.m_store = store;
    }

    public void creationEvent(GlobalTransaction tx) throws Store.StoreException {
        if (tx.is(3)) {
            this.m_wasPreparing = false;
        } else {
            this.m_store.noteTransaction(tx, tx.getTransactionState());
        }
    }

    public void stateEvent(GlobalTransaction tx, int newState) throws Store.StoreException {
        switch (newState) {
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                if (!tx.is(9)) break;
            }
            default: {
                if (!this.m_wasPreparing || this.m_usingRLRC) break;
                this.m_store.noteState(tx, newState);
            }
        }
    }

    public void forgetEvent(GlobalTransaction tx) throws Store.StoreException {
        if (this.m_usingRLRC) {
            RecoverableSinglePhaseResourceReaperTask recoverableSinglePhaseResourceReaperTask = ApplicationServerTransactionManager.getRecoverableSinglePhaseResourceReaperTask();
            if (recoverableSinglePhaseResourceReaperTask != null) {
                recoverableSinglePhaseResourceReaperTask.add(tx);
            }
        } else if (this.m_wasPreparing) {
            this.m_store.noteForget(tx);
        }
    }

    public Store getStore() {
        return this.m_store;
    }

    public void useRLRCOptimization() {
        this.m_usingRLRC = true;
    }
}

