/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import oracle.as.j2ee.transaction.tpc.ProtocolErrorWithNotification;

public class XAState {
    public static final int XAS_ACTIVE = 1;
    public static final int XAS_PREPARED = 2;
    public static final int XAS_HEURISTIC_COMMITTED = 4;
    public static final int XAS_HEURISTIC_ROLLEDBACK = 8;
    public static final int XAS_HEURISTIC_MIXED = 16;
    public static final int XAS_COMPLETED_COMMITTED = 32;
    public static final int XAS_COMPLETED_ROLLEDBACK = 64;
    public static final int XAS_COMPLETED_RDONLY = 128;
    public static final int XAS_COMPLETED_MIXED = 256;
    public static final int NSTATES = 9;
    public static final int XAS_ALL = 511;
    public static final int XAS_COMPLETED = 480;
    public static final int XAS_HEURISTIC = 28;
    public static final int XAS_CAN_COMMIT = 30;
    public static final int XAS_CAN_ROLLBACK = 31;
    public static final int XAS_CAN_FORGET = 28;
    public static final int XAS_SPONTANEOUS = 92;
    public static final int ACTION_PREPARE = 0;
    public static final int ACTION_COMMIT = 1;
    public static final int ACTION_COMMIT1 = 2;
    public static final int ACTION_ROLLBACK = 3;
    public static final int ACTION_FORGET = 4;
    public static final int ACTION_NOOP = 5;
    public static final int ACTION_MAX = 5;
    private int m_state;

    public XAState(int state) {
        this.m_state = state;
    }

    public int getState() {
        return this.m_state;
    }

    public boolean is(int state) {
        return (this.m_state & state) == state;
    }

    public boolean couldBe(int state) {
        return (this.m_state & state) != 0;
    }

    public boolean isNot(int state) {
        return (this.m_state & state) == 0;
    }

    public void model(int action) {
        int newState = 0;
        for (int xBit = 0; xBit < 9; ++xBit) {
            int state1 = 1 << xBit;
            if (!this.is(state1)) continue;
            newState |= this.modelState(state1, action);
        }
        this.m_state = newState;
    }

    static int effective(int action) {
        int xas = 0;
        switch (action) {
            case 0: {
                xas = 1;
                break;
            }
            case 3: {
                xas = 3;
                break;
            }
            case 1: {
                xas = 2;
                break;
            }
            case 2: {
                xas = 1;
                break;
            }
            case 4: {
                xas = 28;
            }
        }
        return xas;
    }

    private int modelState(int state, int action) {
        int newState;
        switch (state) {
            case 1: {
                newState = this.modelActive(action);
                break;
            }
            case 2: {
                newState = this.modelPrepared(action);
                break;
            }
            case 4: {
                newState = this.modelHeuristic(state, action);
                break;
            }
            case 8: {
                newState = this.modelHeuristic(state, action);
                break;
            }
            case 16: {
                newState = this.modelHeuristic(state, action);
                break;
            }
            case 64: {
                newState = this.modelCompleted(state);
                break;
            }
            case 128: {
                newState = this.modelCompleted(state);
                break;
            }
            case 256: {
                newState = this.modelCompleted(state);
                break;
            }
            case 32: {
                newState = this.modelCompleted(state);
                break;
            }
            default: {
                newState = 0;
            }
        }
        return newState;
    }

    /*
     * WARNING - void declaration
     */
    private int modelActive(int action) {
        void var2_2;
        int newState;
        if (action == 0) {
            newState = 130;
        } else if (action == 2) {
            newState = 96;
        } else if (action == 3) {
            newState = 64;
        } else {
            throw new ProtocolErrorWithNotification("Action " + XAState.actionToString(action));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int modelPrepared(int action) {
        void var2_2;
        int newState;
        if (action == 1) {
            newState = 32;
        } else if (action == 3) {
            newState = 64;
        } else {
            throw new ProtocolErrorWithNotification("Action " + XAState.actionToString(action));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int modelHeuristic(int state, int action) {
        void var3_3;
        if (action == 4) {
            switch (state) {
                case 4: {
                    int newState = 32;
                    break;
                }
                case 8: {
                    int newState = 64;
                    break;
                }
                case 16: {
                    int newState = 256;
                    break;
                }
                default: {
                    int newState = state;
                    break;
                }
            }
        } else {
            throw new ProtocolErrorWithNotification("Action " + XAState.actionToString(action));
        }
        return (int)var3_3;
    }

    private int modelCompleted(int state) {
        return state;
    }

    void modelPresumption() {
        int result = this.m_state & 0x1E0;
        if (this.couldBe(1)) {
            result |= 0x40;
        }
        this.m_state &= 0x1C;
        if (this.couldBe(28)) {
            this.model(4);
        }
        if ((result |= this.m_state) == 0) {
            result = 64;
        }
        this.m_state = result;
    }

    public void spontaneous() {
        if (this.couldBe(1)) {
            this.m_state |= 0x40;
        }
        if (this.couldBe(2)) {
            this.m_state |= 0x1C;
        }
        if (this.couldBe(64)) {
            // empty if block
        }
    }

    public String toString() {
        return XAState.toString(this.m_state);
    }

    public static String toString(int state) {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        block12: for (int xBit = 0; xBit < 9; ++xBit) {
            int s = 1 << xBit;
            if ((state & s) != s) continue;
            if (buf.length() > 1) {
                buf.append(',');
            }
            switch (s) {
                default: {
                    buf.append("XA state-" + xBit);
                    continue block12;
                }
                case 0: {
                    buf.append("UNKNOWN");
                    continue block12;
                }
                case 1: {
                    buf.append("ACTIVE");
                    continue block12;
                }
                case 2: {
                    buf.append("PREPARED");
                    continue block12;
                }
                case 4: {
                    buf.append("HEURISTIC_COMMITTED");
                    continue block12;
                }
                case 8: {
                    buf.append("HEURISTIC_ROLLEDBACK");
                    continue block12;
                }
                case 16: {
                    buf.append("HEURISTIC_MIXED");
                    continue block12;
                }
                case 32: {
                    buf.append("COMPLETED_COMMITTED");
                    continue block12;
                }
                case 64: {
                    buf.append("COMPLETED_ROLLEDBACK");
                    continue block12;
                }
                case 128: {
                    buf.append("COMPLETED_RDONLY");
                    continue block12;
                }
                case 256: {
                    buf.append("COMPLETED_MIXED");
                }
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public static String actionToString(int action) {
        switch (action) {
            default: {
                return "Action-" + action;
            }
            case 0: {
                return "ACTION_PREPARE";
            }
            case 1: {
                return "ACTION_COMMIT";
            }
            case 2: {
                return "ACTION_COMMIT1";
            }
            case 3: {
                return "ACTION_ROLLBACK";
            }
            case 4: {
                return "ACTION_FORGET";
            }
            case 5: 
        }
        return "ACTION_NOOP";
    }
}

