/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container;

import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import com.evermind.util.ServicesProperties;
import java.util.logging.Logger;
import oracle.ias.container.ContainerServiceManager;
import oracle.ias.container.Service;
import oracle.ias.container.logging.ContainerServiceTraceLogger;

public abstract class ContainerService
implements Service {
    protected String m_name;
    protected int m_status;
    protected Object m_threadLock = new Object();
    protected Thread m_thread;
    protected int m_serviceId;
    protected boolean m_threaded = true;
    protected String m_serviceThreadName = null;
    protected Object lockObject = null;
    protected boolean _running = false;
    private final Latch _latch;
    private CyclicBarrier _barrier;
    protected long _defaultInterval = ServicesProperties.getContainerServiceInterval();
    private static Logger m_logger = ContainerServiceTraceLogger.getTraceLogger(ContainerService.class);

    public ContainerService(String name) {
        this.m_name = name;
        this.m_status = 2;
        this._running = false;
        this._latch = ContainerServiceManager.instance().getLatch();
        this._barrier = ContainerServiceManager.instance().getBarrier();
        this.m_serviceId = 0;
        this.lockObject = new Object();
    }

    public Object getLockObject() {
        return this.lockObject;
    }

    public String getName() {
        return this.m_name;
    }

    public int status() {
        return this.m_status;
    }

    public int getServiceId() {
        return this.m_serviceId;
    }

    public String statusMessage() {
        StringBuffer message = new StringBuffer(25);
        message.append("Service ");
        message.append(this.m_name);
        message.append(" is ");
        switch (this.m_status) {
            case 1: {
                message.append("started.");
                break;
            }
            case 2: {
                message.append("paused.");
                break;
            }
            case 0: {
                message.append("stopped.");
            }
        }
        return message.toString();
    }

    public boolean initialize() {
        this.m_status = 2;
        return true;
    }

    public boolean postInit() {
        return true;
    }

    public boolean start() {
        this.m_status = 1;
        this.wake();
        m_logger.finest("Container service : " + this + " has been started.");
        return true;
    }

    public boolean stop() {
        this.m_status = 0;
        this.wake();
        m_logger.finest("Container service : " + this + " has been stopped.");
        return true;
    }

    public boolean pause() {
        this.m_status = 2;
        this.wake();
        m_logger.finest("Container service : " + this + " is paused.");
        return true;
    }

    public boolean resume() {
        this.m_status = 1;
        this.wake();
        m_logger.finest("Container service : " + this + " has resumed.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        block9: {
            m_logger.finest("Shutting down container service : " + this);
            this.m_status = 0;
            this.wake();
            try {
                int count = 0;
                boolean notFinishedYet = this._running;
                Thread t = this.getServiceThread();
                while (notFinishedYet && t != null) {
                    t = this.getServiceThread();
                    if (this._running && t != null) {
                        Thread thread = t;
                        synchronized (thread) {
                            t.join(300L);
                        }
                    }
                    if (this._running) {
                        notFinishedYet = false;
                        continue;
                    }
                    notFinishedYet = count++ < 1000;
                }
                if (ServicesProperties.getContainerServiceDebug()) {
                    m_logger.fine("Service: " + this + " shutdown " + Thread.currentThread().getName());
                }
            }
            catch (InterruptedException e) {
                if (!ServicesProperties.getContainerServiceDebug()) break block9;
                m_logger.warning("Service: " + this + " on thread " + Thread.currentThread().getName() + " InterruptedException " + Thread.currentThread().getName() + " " + e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getServiceThread() {
        Object object = this.m_threadLock;
        synchronized (object) {
            return this.m_thread;
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    public boolean isThreaded() {
        return this.m_threaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long ms) {
        block8: {
            if (ms == 0L) {
                return;
            }
            try {
                Object object = this.lockObject;
                synchronized (object) {
                    this.lockObject.wait(ms);
                }
            }
            catch (IllegalMonitorStateException e) {
                if (ServicesProperties.getContainerServiceDebug()) {
                    m_logger.warning("Service: " + this + " on thread " + this.getServiceThreadName() + " IllegalMonitorStateException " + Thread.currentThread().getName() + " " + e);
                }
            }
            catch (InterruptedException e) {
                if (!ServicesProperties.getContainerServiceDebug()) break block8;
                m_logger.warning("Service: " + this + " on thread " + this.getServiceThreadName() + " InterruptedException " + Thread.currentThread().getName() + " " + e);
            }
        }
    }

    private String getServiceThreadName() {
        return this.m_serviceThreadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        block5: {
            try {
                Object object = this.lockObject;
                synchronized (object) {
                    this.lockObject.notify();
                }
            }
            catch (IllegalMonitorStateException e) {
                if (!ServicesProperties.getContainerServiceDebug()) break block5;
                m_logger.warning("Service: " + this + " on thread " + this.getServiceThreadName() + " IllegalMonitorStateException " + Thread.currentThread().getName() + " " + e);
            }
        }
    }

    public abstract void doRun() throws InterruptedException;

    public abstract void doStop() throws InterruptedException;

    public abstract void doPause() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            if (!this.m_threaded) {
                throw new RuntimeException("Trying to run a non threaded service named " + this.m_name);
            }
            this.m_status = 1;
            this.m_thread = Thread.currentThread();
            this.m_thread.setName(this.m_name + "Thread");
            this._running = true;
            if (ServicesProperties.getContainerServiceDebug()) {
                m_logger.fine("Service: " + this + " on thread " + this.getServiceThreadName() + " ready ...");
            }
            try {
                this._barrier = ContainerServiceManager.instance().getBarrier();
                this._barrier.barrier();
                this._latch.acquire();
            }
            catch (InterruptedException e) {
                if (!ServicesProperties.getContainerServiceDebug()) break block13;
                m_logger.warning("Service: " + this + " on thread " + this.getServiceThreadName() + " interrupted ...");
            }
        }
        while (this.m_status != 0) {
            try {
                if (this.m_status == 2) {
                    this.doPause();
                    continue;
                }
                if (this.m_status == 0) {
                    this.doStop();
                    break;
                }
                if (this.m_status != 1) continue;
                this.doRun();
            }
            catch (InterruptedException e) {
                if (!ServicesProperties.getContainerServiceDebug()) continue;
                m_logger.warning("Service: " + this + " on thread " + this.getServiceThreadName() + " interrupted ..." + e);
            }
        }
        if (ServicesProperties.getContainerServiceDebug()) {
            m_logger.fine("Service: " + this + " on thread " + this.getServiceThreadName() + " exit");
        }
        Object object = this.m_threadLock;
        synchronized (object) {
            this.m_thread = null;
        }
        this._running = false;
    }
}

