/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.container.timer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import oracle.ias.container.timer.Timer;
import oracle.ias.container.timer.TimerService;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.TimerServiceCallBackIf;

public class TimerServiceMBeanProxy
implements TimerServiceCallBackIf {
    private static TimerServiceMBeanProxy instance = null;
    private TimerService timerService;
    private int state_ = 1;
    private long startTime_ = System.currentTimeMillis();

    protected TimerServiceMBeanProxy() {
        instance = this;
        this.timerService = TimerService.instance();
        this.start();
    }

    public static TimerServiceMBeanProxy instance() {
        if (instance == null) {
            instance = new TimerServiceMBeanProxy();
        }
        return instance;
    }

    public List getTimers() throws IllegalStateException {
        ArrayList<Timer> list = new ArrayList<Timer>();
        Collection listTimers = this.getTimerService().getTimers();
        Iterator iterator = listTimers.iterator();
        while (iterator.hasNext()) {
            Timer aTimer = (Timer)iterator.next();
            list.add(aTimer);
        }
        return list;
    }

    public List getTimers(String fullBeanName) throws IllegalStateException {
        ArrayList<Timer> list = new ArrayList<Timer>();
        Collection listTimers = this.getTimerService().getTimers();
        Iterator iterator = listTimers.iterator();
        while (iterator.hasNext()) {
            Timer aTimer = (Timer)iterator.next();
            if (!aTimer.getTimerEntry().getFullClassName().equals(fullBeanName)) continue;
            list.add(aTimer);
        }
        return list;
    }

    public List getExpiringTimers(long startTime, long endTime) {
        ArrayList<Timer> list = new ArrayList<Timer>();
        Collection listTimers = this.getTimerService().getTimers();
        Iterator iterator = listTimers.iterator();
        while (iterator.hasNext()) {
            Timer aTimer = (Timer)iterator.next();
            if (startTime >= aTimer.getNextTimeout().getTime() || endTime <= aTimer.getNextTimeout().getTime()) continue;
            list.add(aTimer);
        }
        return list;
    }

    public List getEJBTimers() throws IllegalStateException {
        ArrayList<Timer> list = new ArrayList<Timer>();
        Collection listTimers = this.getTimerService().getTimeBasedTimers();
        Iterator iterator = listTimers.iterator();
        while (iterator.hasNext()) {
            Timer aTimer = (Timer)iterator.next();
            list.add(aTimer);
        }
        return list;
    }

    public oracle.oc4j.admin.management.shared.Timer findTimerById(long containerID, long timerID) {
        Timer internalTimer = this.getTimerService().getTimerFromId(containerID, timerID);
        if (internalTimer != null) {
            return internalTimer;
        }
        return null;
    }

    public void cancel(oracle.oc4j.admin.management.shared.Timer timer) {
        Timer internalTimer = this.getTimerService().getTimerFromId(timer.getTimerId());
        internalTimer.cancel();
    }

    public String getEJBName(oracle.oc4j.admin.management.shared.Timer timer) {
        Timer internalTimer = this.getTimerService().getTimerFromId(timer.getTimerId());
        if (internalTimer != null) {
            return internalTimer.getTimerEntry().getBeanName();
        }
        return null;
    }

    public String getEJBApplication(oracle.oc4j.admin.management.shared.Timer timer) {
        Timer internalTimer = this.getTimerService().getTimerFromId(timer.getTimerId());
        if (internalTimer != null) {
            return internalTimer.getTimerEntry().getApplication();
        }
        return null;
    }

    public String getEJBJar(oracle.oc4j.admin.management.shared.Timer timer) {
        Timer internalTimer = this.getTimerService().getTimerFromId(timer.getTimerId());
        if (internalTimer != null) {
            return internalTimer.getTimerEntry().getJar();
        }
        return null;
    }

    public String getNextExecution(oracle.oc4j.admin.management.shared.Timer timer) {
        Timer internalTimer = this.getTimerService().getTimerFromId(timer.getTimerId());
        if (internalTimer != null) {
            return internalTimer.getNextTimeout().toString();
        }
        return null;
    }

    public String getLastExecution(oracle.oc4j.admin.management.shared.Timer timer) {
        Timer internalTimer = this.getTimerService().getTimerFromId(timer.getTimerId());
        if (internalTimer != null) {
            return internalTimer.getLastExecutionTime().toString();
        }
        return null;
    }

    private TimerService getTimerService() {
        return this.timerService;
    }

    public String getproprietaryDeploymentDescriptor() {
        return "";
    }

    public String getdeploymentDescriptor() {
        return "";
    }

    public final void registerTimerServiceMbean() {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        oracle.oc4j.admin.management.mbeans.TimerService mbean = new oracle.oc4j.admin.management.mbeans.TimerService(this);
        try {
            if (oc4jMBeanServer.isRegistered(mbean.getObjectName())) {
                oc4jMBeanServer.unregisterMBean(mbean.getObjectName());
            }
            oc4jMBeanServer.registerMBean(ModelMBeanFactory.getModelMBean(mbean), mbean.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final void start() {
        try {
            this.state_ = 0;
            this.startTime_ = System.currentTimeMillis();
            this.state_ = 1;
        }
        catch (Exception e) {
            this.state_ = 4;
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final void stop() {
        try {
            this.state_ = 2;
            this.destroy();
            this.state_ = 3;
        }
        catch (Exception e) {
            this.state_ = 4;
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void stop(Map params) {
        this.stop();
    }

    public final void startRecursive() {
        this.start();
    }

    public final long getstartTime() {
        return this.startTime_;
    }

    public final int getstate() {
        return this.state_;
    }

    private final void destroy() {
        instance = null;
        this.timerService = null;
    }
}

