/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.clustering;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessageBundle;
import oracle.j2ee.util.CustomerLogger;

public class ClusteringMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.cluster", ClusteringMessageBundle.class.getName());

    public static void warningInOpmnGetServers(String host, int port, Throwable reason) {
        if (ClusteringMessages.isLoggable(Level.WARNING)) {
            Object[] arrayOfParameters = new Object[]{host, "" + port};
            m_logger.log(Level.WARNING, "J2EE CLSTR-00001", arrayOfParameters);
        }
        ClusteringMessages.finerLogException(reason);
    }

    public static boolean isLoggable(Level logLevel) {
        return m_logger.isLoggable(logLevel);
    }

    public static void finerLogException(Throwable reason) {
        m_logger.log(Level.FINER, "J2EE CLSTR-00002", reason);
    }

    public static void fineClusterConfig(Object config) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            Object[] arrayOfParameters = new Object[]{config};
            m_logger.log(Level.FINE, "J2EE CLSTR-00003", arrayOfParameters);
        }
    }

    public static void infoSessionManagerStarted(String sessionType, String appName, String channelName, String protocol, String address, String port) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00004", new String[]{sessionType, appName, channelName, protocol, address, port});
        }
    }

    public static void infoPersistenceSessionManagerStarted(String sessionType, String appName, String dataSourceName, String protocol) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00022", new String[]{sessionType, appName, dataSourceName, protocol});
        }
    }

    public static void fineHttpSessionCreatedWithId(String id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00005", id);
        }
    }

    public static void fineEjbSessionCreatedWithId(long id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00006", Long.toString(id));
        }
    }

    public static void finePersistenceSessionCreatedWithId(long id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00007", Long.toString(id));
        }
    }

    public static void finestHttpSessionUpdatedWithId(String id) {
        if (ClusteringMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE CLSTR-00008", id);
        }
    }

    public static void finestEjbSessionUpdatedWithId(long id) {
        if (ClusteringMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE CLSTR-00009", Long.toString(id));
        }
    }

    public static void fineHttpSessionFailover(Serializable id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00010", id);
        }
    }

    public static void fineEjbSessionFailover(Serializable id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00011", id);
        }
    }

    public static void fineInvalidateEjbSession(Serializable id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00013", id);
        }
    }

    public static void fineInvalidateHttpSession(String id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00012", id);
        }
    }

    public static void finestSessionPersistedWithId(Serializable id) {
        if (ClusteringMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE CLSTR-00014", id);
        }
    }

    public static void finePersistentSessionRetrieval(Serializable id) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00015", id);
        }
    }

    public static void fineORMIPeerInfo(String peers) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00016", peers);
        }
    }

    public static void fineSecureORMIPeerInfo(String peers) {
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE CLSTR-00017", peers);
        }
    }
}

