/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector;

import com.evermind.server.connector.ConnectionContext;
import javax.resource.ResourceException;
import javax.transaction.Transaction;
import oracle.j2ee.connector.ConnectorProxyBuilder;
import oracle.j2ee.connector.ConnectorProxyConstructionData;
import oracle.j2ee.connector.OracleConnectionManager;
import oracle.j2ee.connector.proxy.AbstractProxy;
import oracle.j2ee.connector.proxy.ProxyBuilder;
import oracle.j2ee.connector.proxy.ProxyInterceptException;

public class ConnectorProxy
extends AbstractProxy {
    private ConnectorProxyConstructionData m_data;
    private ConnectionContext m_connectionContext = null;
    private Transaction m_tx = null;

    public ConnectorProxy(Object target, ConnectorProxyConstructionData data) {
        super(target);
        this.oc4j_setData(data);
    }

    protected void oc4j_intercept() throws ProxyInterceptException {
        if (this.oc4j_isClosed()) {
            return;
        }
        AbstractProxy parent = this.oc4j_getParent();
        if (parent != null) {
            ((ConnectorProxy)parent).oc4j_intercept();
        } else {
            OracleConnectionManager connectionManager = this.m_data.getConnectionManager();
            try {
                Transaction currentTx = connectionManager.getTransaction();
                if (currentTx != this.m_tx) {
                    this.m_connectionContext = connectionManager.reassociateIfRequired(this.oc4j_getTarget(), this.m_connectionContext, this.m_data.getManagedConnectionFactory(), this.m_data.getConnectionRequestInfo());
                    if (!this.m_connectionContext.isEnlistedInTransaction(currentTx) && !this.m_connectionContext.isLazyEnlistable()) {
                        this.m_connectionContext.setupForTransaction();
                    }
                }
                this.m_tx = currentTx;
            }
            catch (ResourceException e) {
                throw new ProxyInterceptException(e.toString(), e);
            }
        }
    }

    public void oc4j_setData(ConnectorProxyConstructionData data) {
        this.m_data = data;
        if (this.m_data != null) {
            this.m_connectionContext = this.m_data.getContext();
        }
    }

    public ProxyBuilder oc4j_getNewBuilder(Object target, String requiredInterfaceName) {
        return new ConnectorProxyBuilder(target, this, this.m_data, requiredInterfaceName);
    }

    public void oc4j_resetConnectionContext() {
        this.m_connectionContext = null;
    }
}

