/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.iiop;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.util.OpmnHelper;
import com.oracle.iiop.server.IIOPContext;
import com.sun.jndi.url.corbaname.corbanameURLContextFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import oracle.j2ee.corba.iiop.IIOPMessages;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.corba.ClientOrbManager;

public class IIOPInitialContextFactory
implements InitialContextFactory {
    public static final int DEFAULT_IIOP_PORT = 900;
    public static final int OC4J_IIOP_PORT = 5555;
    public static final int OC4J_IIOP_SSL_PORT = 5556;
    public static final int OC4J_IIOP_SSL_CLIENT_SERVER_AUTH_PORT = 5557;
    private static corbanameURLContextFactory factory = new corbanameURLContextFactory();
    private static final Map contexts = new HashMap();
    private static String OPMN_IIOP_LOOKUP_URL = "opmn:corbaname::";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        String contextKey;
        IIOPContext context;
        IIOPMessages.finestMsg("In IIOPInitialContextFactory getInitialContext..");
        String urlString = environment == null ? null : (String)environment.get("java.naming.provider.url");
        this.checkProviderURLFormat(urlString);
        this.setOrbProperties(environment);
        String userName = (String)environment.get("java.naming.security.principal");
        String passWord = (String)environment.get("java.naming.security.credentials");
        if (this.userNameAndPasswordNotEmpty(userName, passWord)) {
            ClientOrbManager.setClientCredentials(userName, passWord);
        }
        int hashPos = urlString.indexOf("#");
        String application = null;
        if (hashPos > 0) {
            application = urlString.substring(hashPos + 1);
        }
        if ((context = this.getCachedContexts(contextKey = urlString.trim() + (userName == null ? "" : userName.trim()) + (passWord == null ? "" : passWord.trim()) + application)) != null) {
            return context;
        }
        try {
            Context ctx = urlString.startsWith(OPMN_IIOP_LOOKUP_URL) ? this.createOPMNBasedContext(urlString, hashPos, application, environment) : (Context)factory.getObjectInstance((Object)urlString, null, null, environment);
            if (ctx == null) {
                throw new NamingException("Underlying factory returned null context. Factory is:" + factory.getClass());
            }
            context = new IIOPContext(ctx, environment);
            contexts.put(contextKey, context);
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception ex) {
            IIOPMessages.finerThrowableNoMsg(ex);
            throw new NamingException(ex.getMessage());
        }
        return context;
    }

    private boolean userNameAndPasswordNotEmpty(String userName, String passWord) {
        boolean retVal = false;
        if (userName != null && userName.trim().length() > 0 && passWord != null && passWord.trim().length() > 0) {
            retVal = true;
        }
        return retVal;
    }

    public static void resetContexts() {
        contexts.clear();
    }

    public static Context getCorbanameContext(Hashtable env) throws Exception {
        Context ctx = (Context)factory.getObjectInstance(null, null, null, env);
        return ctx;
    }

    private IIOPContext getCachedContexts(String contextKey) {
        IIOPContext context = (IIOPContext)contexts.get(contextKey);
        return context;
    }

    private void checkProviderURLFormat(String urlString) throws NamingException {
        if (urlString == null) {
            throw new NamingException("Environment is missing a java.naming.provider.url attribute - nowhere to connect");
        }
        if (!urlString.startsWith("corbaname:") && !urlString.startsWith(OPMN_IIOP_LOOKUP_URL)) {
            throw new NamingException("Provider URL must be of the form [opmn:]corbaname::host:port#/appname ");
        }
    }

    private Context createOPMNBasedContext(String urlString, int hashPos, String application, Hashtable environment) throws Exception {
        ServerIdentification[] servers = this.parseURLAndQueryOPMN(urlString, hashPos, application);
        Context ctx = this.createContextOPMN(servers, application, environment);
        return ctx;
    }

    private ServerIdentification[] parseURLAndQueryOPMN(String urlString, int hashPos, String applicationName) {
        String host;
        int opmnAddrStart = OPMN_IIOP_LOOKUP_URL.length();
        String port = "6003";
        String oc4jInstanceName = "home";
        int colonPos = urlString.indexOf(":", opmnAddrStart + 1);
        if (colonPos > 0) {
            host = urlString.substring(opmnAddrStart, colonPos);
            int nextColonPos = urlString.indexOf(":", colonPos + 1);
            if (nextColonPos > 0) {
                port = urlString.substring(colonPos + 1, nextColonPos);
                if (hashPos > 0) {
                    oc4jInstanceName = urlString.substring(nextColonPos + 1, hashPos);
                }
            } else {
                port = hashPos > 0 ? urlString.substring(colonPos + 1, hashPos) : urlString.substring(colonPos + 1);
            }
        } else {
            host = hashPos > 0 ? urlString.substring(opmnAddrStart, hashPos) : urlString.substring(opmnAddrStart);
        }
        return this.getServersFromOpmn(host, port, oc4jInstanceName, applicationName);
    }

    ServerIdentification[] getServersFromOpmn(String host, String port, String oc4jInstanceName, String applicationName) {
        return OpmnHelper.getOc4jServers(host, Integer.parseInt(port), oc4jInstanceName, "iiop", applicationName);
    }

    private Context createContextOPMN(ServerIdentification[] servers, String application, Hashtable environment) throws Exception {
        Context ctx;
        if (servers.length > 0) {
            StringBuffer buf = new StringBuffer("corbaname::");
            ctx = servers.length == 1 ? this.getContextOPMNOneServer(buf, servers, application, environment) : this.getContextOPMNManyServers(buf, servers, application, environment);
        } else {
            throw new NamingException("No OC4J instances found");
        }
        return ctx;
    }

    Context getContextOPMNManyServers(StringBuffer buf, ServerIdentification[] servers, String application, Hashtable environment) throws Exception {
        String[] urls = new String[servers.length];
        for (int i = 0; i < urls.length; ++i) {
            buf.append(servers[i].getAddress());
            buf.append(":");
            buf.append(servers[i].getPort());
            if (application != null) {
                buf.append("#");
                buf.append(application);
            }
            urls[i] = buf.toString();
            buf.delete(11, buf.length());
        }
        Context ctx = (Context)factory.getObjectInstance((Object)urls, null, null, environment);
        return ctx;
    }

    Context getContextOPMNOneServer(StringBuffer buf, ServerIdentification[] servers, String application, Hashtable environment) throws Exception {
        buf.append(servers[0].getAddress());
        buf.append(":");
        buf.append(servers[0].getPort());
        if (application != null) {
            buf.append("#");
            buf.append(application);
        }
        Context ctx = (Context)factory.getObjectInstance((Object)buf.toString(), null, null, environment);
        return ctx;
    }

    private void setOrbProperties(Map environment) {
        if (!CommonThreadState.getCurrent().isApplicationThread() && environment != null) {
            environment.putAll(ClientOrbManager.getClientProperties());
        }
    }
}

