/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.naming;

import com.evermind.io.IOUtils;
import com.evermind.server.ApplicationClientContext;
import com.evermind.server.auth.OC4JLoginModule;
import com.evermind.server.deployment.ApplicationClientArchive;
import com.evermind.server.rmi.RMIContext;
import com.oracle.naming.J2EEContext;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import oracle.j2ee.iiop.IIOPInitialContextFactory;
import oracle.j2ee.rmi.RMIInitialContextFactory;
import oracle.oc4j.deployment.ApplicationClientResourceFinder;
import org.xml.sax.SAXException;

public class ApplicationClientInitialContextFactory
implements InitialContextFactory {
    private static final String STANDARD_DESCRIPTOR_PATH = "META-INF/application-client.xml";
    private static final String PROPRIETARY_DESCRIPTOR_PATH = "META-INF/orion-application-client.xml";
    private static final String STANDARD_DESCRIPTOR_MISSING_ERROR = "see J2EE spec, application-client chapter for requirements and format of the file";
    private static Map m_contextGroups;
    private static HashMap m_descriptorCache;
    private static final ThreadLocal cachedContext;
    private J2EEContextCreationListener m_j2eeContextCreationListener = null;
    private ClassPathFinderStrategy m_finderStrategy;

    public ApplicationClientInitialContextFactory() {
        this(null, new DefaultClassPathFinder());
    }

    public ApplicationClientInitialContextFactory(J2EEContextCreationListener j2eeContextListener) {
        this(j2eeContextListener, new DefaultClassPathFinder());
    }

    protected ApplicationClientInitialContextFactory(J2EEContextCreationListener j2eeContextListener, ClassPathFinderStrategy finderStrategy) {
        this.m_j2eeContextCreationListener = j2eeContextListener;
        this.m_finderStrategy = finderStrategy;
    }

    public static void setContext(ThreadGroup group, Context context) {
        if (m_contextGroups == null) {
            m_contextGroups = new HashMap();
        }
        m_contextGroups.put(group, context);
    }

    public static void reset() {
        if (m_contextGroups != null) {
            m_contextGroups.clear();
        }
        if (m_descriptorCache != null) {
            m_descriptorCache.clear();
        }
        cachedContext.set(null);
    }

    public static Context getThreadLocalContext() {
        return (Context)cachedContext.get();
    }

    protected static void setThreadLocalContext(Context threadLocalContext) {
        cachedContext.set(threadLocalContext);
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        Context context;
        if (environment == null) {
            environment = new Hashtable();
        }
        if (m_contextGroups != null) {
            for (ThreadGroup group = Thread.currentThread().getThreadGroup(); group != null; group = group.getParent()) {
                context = (Context)m_contextGroups.get(group);
                if (context == null) continue;
                return context;
            }
        }
        ApplicationClientArchive descriptor = this.getArchive(environment);
        this.setSecurityProperties(environment);
        context = this.hasIIOPProviderURL(environment) ? this.getIiopContext(environment) : this.getRmiContext(descriptor, environment);
        Context applicationClientContext = this.getApplicationContext(context, descriptor);
        if (J2EEContext.isURLContextFactoryEnabled(environment)) {
            ApplicationClientInitialContextFactory.setThreadLocalContext(applicationClientContext);
        }
        return applicationClientContext;
    }

    private Context getApplicationContext(Context context, ApplicationClientArchive descriptor) throws NamingException {
        try {
            J2EEContext subContext = J2EEContext.create(descriptor, new ApplicationClientResourceFinder(context), context, descriptor.getMailSessions());
            return new ApplicationClientContext(context, subContext, descriptor);
        }
        catch (InstantiationException e) {
            NamingException namingException = new NamingException("Error reading application-client descriptor: " + e.getMessage());
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    private Context getRmiContext(ApplicationClientArchive descriptor, Hashtable environment) throws NamingException {
        String callbackHandlerName = descriptor.getCallbackHandler();
        RMIContext rmiContext = callbackHandlerName != null ? this.getContext(Thread.currentThread().getContextClassLoader(), environment, callbackHandlerName) : (RMIContext)new RMIInitialContextFactory().getInitialContext(environment);
        return rmiContext;
    }

    private Context getIiopContext(Hashtable env) throws NamingException {
        return new IIOPInitialContextFactory().getInitialContext(env);
    }

    private ApplicationClientArchive getArchive(Hashtable environment) throws NamingException {
        ApplicationClientArchive descriptor = new ApplicationClientArchive("the client");
        if (this.m_j2eeContextCreationListener != null) {
            this.m_j2eeContextCreationListener.preJ2EEContextCreation(descriptor);
        }
        byte[] descriptorData = this.getRequiredClasspathResource(STANDARD_DESCRIPTOR_PATH, STANDARD_DESCRIPTOR_MISSING_ERROR, environment);
        byte[] deploymentData = null;
        if (environment.get("application-client.xml") == null) {
            deploymentData = this.getClasspathResource(PROPRIETARY_DESCRIPTOR_PATH);
        }
        try {
            descriptor.init(descriptorData, 0, descriptorData.length, false);
            if (deploymentData != null) {
                descriptor.init(deploymentData, 0, deploymentData.length, true);
            }
        }
        catch (InstantiationException e) {
            throw new NamingException(e.getMessage());
        }
        catch (IOException e) {
            throw new NamingException("IO error: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new NamingException("Parsing error: " + e.getMessage());
        }
        return descriptor;
    }

    private void setSecurityProperties(Hashtable environment) {
        if (environment.get("java.naming.security.principal") == null && System.getProperty("java.naming.security.principal") != null) {
            environment.put("java.naming.security.principal", System.getProperty("java.naming.security.principal"));
        }
        if (environment.get("java.naming.security.credentials") == null && System.getProperty("java.naming.security.credentials") != null) {
            environment.put("java.naming.security.credentials", System.getProperty("java.naming.security.credentials"));
        }
        if (environment.get("java.naming.provider.url") == null && System.getProperty("java.naming.provider.url") != null) {
            environment.put("java.naming.provider.url", System.getProperty("java.naming.provider.url"));
        }
        this.overrideSystemProperty("jmx.java.naming.provider.url", environment);
    }

    protected byte[] getClasspathResource(String resourceName) {
        if (this.m_finderStrategy != null) {
            return this.m_finderStrategy.getClasspathResource(resourceName);
        }
        return null;
    }

    protected byte[] getRequiredClasspathResource(String resourceName, String errorMessage, Hashtable environment) throws NamingException {
        if (environment.get("application-client.xml") != null) {
            return ((String)environment.get("application-client.xml")).getBytes();
        }
        byte[] descriptorData = this.getClasspathResource(resourceName);
        if (descriptorData == null) {
            throw new NamingException(resourceName + " not found (" + errorMessage + ")");
        }
        return descriptorData;
    }

    public RMIContext getContext(ClassLoader loader, Hashtable environment, String callbackHandlerName) throws NamingException {
        try {
            OC4JLoginModule module = new OC4JLoginModule();
            module.initialize(new Subject(), this.getCallbackHandler(callbackHandlerName, loader), (Map)new HashMap(), (Map)environment);
            module.login();
            return module.getRMIContext();
        }
        catch (LoginException e) {
            throw new NamingException(e.getMessage());
        }
    }

    private CallbackHandler getCallbackHandler(String callbackHandlerName, ClassLoader loader) throws NamingException {
        if (callbackHandlerName == null) {
            return null;
        }
        try {
            Class<?> aClass = Class.forName(callbackHandlerName, true, loader);
            return (CallbackHandler)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NamingException("Callback handler class '" + callbackHandlerName + "' not found: " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new NamingException("Defined callback-handler class '" + callbackHandlerName + "' is not an instance of a javax.security.auth.callback.CallbackHandler");
        }
        catch (InstantiationException e) {
            throw new NamingException("Error instantiating callback-handler '" + callbackHandlerName + "' instance: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new NamingException("Error instantiating callback-handler '" + callbackHandlerName + "' instance: " + e.getMessage());
        }
    }

    private boolean hasIIOPProviderURL(Hashtable env) throws NamingException {
        String urlString;
        String string = urlString = env == null ? null : (String)env.get("java.naming.provider.url");
        if (urlString == null) {
            throw new NamingException("Environment is missing a java.naming.provider.url attribute - nowhere to connect");
        }
        return urlString.startsWith("corbaname:") || urlString.startsWith("opmn:corbaname:");
    }

    private void defaultSystemProperty(String propertyName, Map defaults) {
        if (System.getProperty(propertyName) == null && defaults.get(propertyName) != null) {
            System.setProperty(propertyName, defaults.get(propertyName).toString());
        }
    }

    private void overrideSystemProperty(String propertyName, Map defaults) {
        if (defaults.get(propertyName) != null) {
            System.setProperty(propertyName, defaults.get(propertyName).toString());
        }
    }

    public static void main(String[] args) {
        new ApplicationClientInitialContextFactory();
    }

    static {
        m_descriptorCache = new HashMap();
        cachedContext = new ThreadLocal(){

            protected Object initialValue() {
                return null;
            }
        };
    }

    public static interface ClassPathFinderStrategy {
        public byte[] getClasspathResource(String var1);
    }

    public static interface J2EEContextCreationListener {
        public void preJ2EEContextCreation(ApplicationClientArchive var1);
    }

    private static class DefaultClassPathFinder
    implements ClassPathFinderStrategy {
        private DefaultClassPathFinder() {
        }

        public byte[] getClasspathResource(String resourceName) {
            try {
                URL deploymentURL = Thread.currentThread().getContextClassLoader().getResource(resourceName);
                if (deploymentURL == null) {
                    deploymentURL = this.getClass().getClassLoader().getResource(resourceName);
                }
                if (deploymentURL == null) {
                    return null;
                }
                Object descriptorData = m_descriptorCache.get(deploymentURL);
                if (descriptorData == null) {
                    descriptorData = IOUtils.getContent(deploymentURL);
                    m_descriptorCache.put(deploymentURL, descriptorData);
                }
                return (byte[])descriptorData;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

