/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.transaction;

import com.evermind.server.ApplicationServerTransaction;
import java.io.Serializable;
import java.util.HashMap;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.TransactionState;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;

public class TransactionDetail
implements Serializable {
    private String m_state;
    private long m_timeActive;
    private String m_name;
    private Xid m_xid;
    private HashMap m_enlistedResourceNames;
    public static final String RECOVERING_TRANSACTION_NAME = "recovering transaction";

    public TransactionDetail(ApplicationServerTransaction tx) {
        this.m_state = TransactionState.toString(tx.getTransactionState());
        this.m_timeActive = tx.getTimeActive();
        this.m_name = tx.getType();
        this.m_xid = tx.getXid();
        this.m_enlistedResourceNames = tx.getEnlistedResourcesInfo();
    }

    public TransactionDetail(GlobalTransaction tx) {
        this.m_state = tx.getTransactionState() == 5 ? "RECOVERING_COMMITTING" : (tx.getTransactionState() == 3 ? "RECOVERING_ROLLINGBACK" : TransactionState.toString(tx.getTransactionState()));
        this.m_timeActive = tx.getTimeActive();
        this.m_name = RECOVERING_TRANSACTION_NAME;
        this.m_name = tx.getType();
        this.m_xid = tx.getXid();
        this.m_enlistedResourceNames = new HashMap();
        for (int i = 0; i < tx.numberOfBranches(); ++i) {
            Xid xid = tx.getBranch(i).getXid();
            if (xid == null) {
                this.m_enlistedResourceNames.put("unknown xid for branch : " + tx.getBranch(i), tx.getBranch(i).getRmId().getRMFactoryJndiLocation().getJndiLocation());
                continue;
            }
            this.m_enlistedResourceNames.put(xid, tx.getBranch(i).getRmId().getRMFactoryJndiLocation().getJndiLocation());
        }
    }

    public String getState() {
        return this.m_state;
    }

    public long getTimeActive() {
        return this.m_timeActive;
    }

    public String getName() {
        return this.m_name;
    }

    public Xid getId() {
        return this.m_xid;
    }

    public HashMap getEnlistedResourcesInfo() {
        return this.m_enlistedResourceNames;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Name: ");
        res.append(this.getName());
        res.append('\n');
        res.append("Id: ");
        res.append(this.getId());
        res.append('\n');
        res.append("State: ");
        res.append(this.getState());
        res.append('\n');
        res.append("Enlisted Resources Info: ");
        res.append(this.getEnlistedResourcesInfo());
        res.append('\n');
        res.append("Time Active: ");
        res.append(this.getTimeActive());
        res.append('\n');
        return res.toString();
    }
}

