/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.ExecutionContextLogger;
import oracle.j2ee.util.TraceLogger;

public class CustomerLogger {
    public static final String CLUSTERING_LOGGER_NAME = "oracle.j2ee.cluster";
    public static final String CONNECTOR_LOGGER_NAME = "oracle.j2ee.connector";
    public static final String CONNECTOR_COMMON_LOGGER_NAME = "oracle.j2ee.connector.common";
    public static final String CONNECTOR_DEPLOYMENT_LOGGER_NAME = "oracle.j2ee.connector.deployment";
    public static final String CONNECTOR_MESSAGE_INFLOW_LOGGER_NAME = "oracle.j2ee.connector.messageinflow";
    public static final String CONNECTOR_SECURITY_LOGGER_NAME = "oracle.j2ee.connector.security";
    public static final String CONNECTOR_TRANSACTION_LOGGER_NAME = "oracle.j2ee.connector.transaction";
    public static final String CONNECTOR_WORK_LOGGER_NAME = "oracle.j2ee.connector.work";
    public static final String DATASOURCE_LOGGER_NAME = "oracle.j2ee.datasource";
    public static final String DEPLOYMENT_LOGGER_NAME = "oracle.j2ee.deployment";
    public static final String ANNOTATION_LOGGER_NAME = "oracle.j2ee.deployment.annotation";
    public static final String PERSISTENCE_LOGGER_NAME = "oracle.j2ee.persistence";
    public static final String EJB_ANNOTATION_LOGGER_NAME = "oracle.j2ee.deployment.annotation.ejb";
    public static final String EJB_COMPILATION_LOGGER_NAME = "oracle.j2ee.ejb.compilation";
    public static final String EJB_DATABASE_LOGGER_NAME = "oracle.j2ee.ejb.database";
    public static final String EJB_DEPLOYMENT_LOGGER_NAME = "oracle.j2ee.ejb.deployment";
    public static final String EJB_LIFECYCLE_LOGGER_NAME = "oracle.j2ee.ejb.lifecycle";
    public static final String EJB_POOLING_LOGGER_NAME = "oracle.j2ee.ejb.pooling";
    public static final String EJB_RUNTIME_LOGGER_NAME = "oracle.j2ee.ejb.runtime";
    public static final String EJB_TRANSACTION_LOGGER_NAME = "oracle.j2ee.ejb.transaction";
    public static final String EJB_TIMER_LOGGER_NAME = "oracle.j2ee.ejb.timer";
    public static final String EJB_INTERCEPTOR_LOGGER_NAME = "oracle.j2ee.ejb.interceptor";
    public static final String CONTAINER_SERVICE_LOGGER_NAME = "oracle.ias.container";
    public static final String EJB_IIOP_LOGGER_NAME = "oracle.j2ee.ejb.iiop";
    public static final String HTTP_LOGGER_NAME = "oracle.j2ee.http";
    public static final String JMS_LOGGER_NAME = "oracle.j2ee.jms";
    public static final String JNDI_LOGGER_NAME = "oracle.j2ee.jndi";
    public static final String RMI_LOGGER_NAME = "oracle.j2ee.rmi";
    public static final String RMI_TRANSPORT_LOGGER_NAME = "oracle.j2ee.rmi.transport";
    public static final String RUNTIME_LOGGER_NAME = "oracle.j2ee.runtime";
    public static final String SECURITY_LOGGER_NAME = "oracle.j2ee.security.oc4j";
    public static final String SERVLET_LOGGER_NAME = "oracle.j2ee.servlet";
    public static final String TRANSACTION_LOGGER_NAME = "oracle.j2ee.transaction";
    public static final String TRANSACTION_EXCEPTIONS_LOGGER_NAME = "oracle.j2ee.transaction.exceptions";
    public static final String WEBSERVICES_LOGGER_NAME = "oracle.webservices";
    public static final String WEBSERVICES_DEPLOYMENT_LOGGER_NAME = "oracle.webservices.deployment";
    public static final String WEBSERVICES_RUNTIME_LOGGER_NAME = "oracle.webservices.runtime";
    public static final String WEBSERVICES_SERVICE_LOGGER_NAME = "oracle.webservices.service";
    public static final String WEBSERVICES_CLIENT_LOGGER_NAME = "oracle.webservices.client";
    public static final String WEBSERVICES_WSDL_LOGGER_NAME = "oracle.webservices.orawsdl";
    public static final String WEBSERVICES_SAAJ_LOGGER_NAME = "oracle.webservices.saaj";
    public static final String WEBSERVICES_WSIF_LOGGER_NAME = "oracle.webservices.wsif";
    public static final String WEBSERVICES_SECURITY_LOGGER_NAME = "oracle.webservices.security";
    public static final String WEBSERVICES_RELIABILITY_LOGGER_NAME = "oracle.webservices.reliability";
    public static final String WEBSERVICES_REGISTRY_LOGGER_NAME = "oracle.webservices.registry";
    public static final String XML_LOGGER_NAME = "oracle.j2ee.xml";
    public static final String CORBA_LOGGER_NAME = "oracle.j2ee.corba";
    public static final String CORBA_IIOP_LOGGER_NAME = "oracle.j2ee.corba.iiop";
    public static final String CORBA_SECURITY_LOGGER_NAME = "oracle.j2ee.corba.security";
    public static final String CORBA_NAMING_LOGGER_NAME = "oracle.j2ee.corba.naming";
    private static String[] ALL_LOGGER_NAMES = new String[]{"oracle.j2ee.cluster", "oracle.ias.container", "oracle.j2ee.connector", "oracle.j2ee.connector.common", "oracle.j2ee.connector.deployment", "oracle.j2ee.connector.messageinflow", "oracle.j2ee.connector.security", "oracle.j2ee.connector.transaction", "oracle.j2ee.connector.work", "oracle.j2ee.datasource", "oracle.j2ee.deployment", "oracle.j2ee.deployment.annotation.ejb", "oracle.j2ee.ejb.compilation", "oracle.j2ee.ejb.database", "oracle.j2ee.ejb.deployment", "oracle.j2ee.ejb.lifecycle", "oracle.j2ee.ejb.pooling", "oracle.j2ee.ejb.runtime", "oracle.j2ee.ejb.transaction", "oracle.j2ee.ejb.iiop", "oracle.j2ee.persistence", "oracle.j2ee.deployment.annotation", "oracle.j2ee.http", "oracle.j2ee.jms", "oracle.j2ee.jndi", "oracle.j2ee.rmi", "oracle.j2ee.rmi.transport", "oracle.j2ee.runtime", "oracle.j2ee.security.oc4j", "oracle.j2ee.servlet", "oracle.j2ee.transaction", "oracle.j2ee.transaction.exceptions", "oracle.j2ee.xml", "oracle.j2ee.corba", "oracle.j2ee.corba.iiop", "oracle.j2ee.corba.security", "oracle.j2ee.corba.naming", "oracle.webservices", "oracle.webservices.runtime", "oracle.webservices.service", "oracle.webservices.client", "oracle.webservices.orawsdl", "oracle.webservices.saaj", "oracle.webservices.wsif", "oracle.webservices.security", "oracle.webservices.reliability", "oracle.webservices.registry"};
    private static HashMap _loggerCache = new HashMap();
    private static String[] _severeLoggers;
    private static String[] _warningLoggers;
    private static String[] _infoLoggers;
    private static String[] _configLoggers;
    private static String[] _fineLoggers;
    private static String[] _finerLoggers;
    private static String[] _finestLoggers;
    static /* synthetic */ Class class$java$util$logging$ConsoleHandler;
    static /* synthetic */ Class class$oracle$j2ee$util$TraceLogger$TraceLoggerHandler;

    static void clearCaches() {
        _loggerCache = new HashMap();
        _fineLoggers = null;
    }

    public static void loadAllLoggers() {
        for (int i = 0; i < ALL_LOGGER_NAMES.length; ++i) {
            String loggerName = ALL_LOGGER_NAMES[i];
            if (loggerName.startsWith(WEBSERVICES_LOGGER_NAME)) {
                ExecutionContextLogger.getLogger(loggerName);
                continue;
            }
            Logger.getLogger(loggerName);
        }
    }

    public static Logger getLogger(String loggerName, String resourceBundleName) {
        if (_loggerCache.get(loggerName) != null) {
            return (Logger)_loggerCache.get(loggerName);
        }
        Logger logger = Logger.getLogger(loggerName, resourceBundleName);
        _loggerCache.put(loggerName, logger);
        Level level = CustomerLogger.getDynamicLevel(logger.getName());
        if (level != null) {
            logger.setLevel(level);
            Handler handler = CustomerLogger.getCompatibleHandler(logger);
            if (level.intValue() < handler.getLevel().intValue()) {
                handler.setLevel(level);
            }
        }
        return logger;
    }

    private static Handler getCompatibleHandler(Logger logger) {
        Logger controlledLogger = logger;
        Handler[] handlers = controlledLogger.getHandlers();
        if (handlers.length != 0) {
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                if (handler.getClass().equals(class$java$util$logging$ConsoleHandler == null ? CustomerLogger.class$("java.util.logging.ConsoleHandler") : class$java$util$logging$ConsoleHandler)) {
                    return handler;
                }
                if (!handler.getClass().equals(class$oracle$j2ee$util$TraceLogger$TraceLoggerHandler == null ? CustomerLogger.class$("oracle.j2ee.util.TraceLogger$TraceLoggerHandler") : class$oracle$j2ee$util$TraceLogger$TraceLoggerHandler)) continue;
                return handler;
            }
        }
        TraceLogger.TraceLoggerHandler handler = new TraceLogger.TraceLoggerHandler();
        logger.addHandler(handler);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Level getDynamicLevel(String loggerName) {
        HashMap hashMap = _loggerCache;
        synchronized (hashMap) {
            if (_fineLoggers == null) {
                _severeLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.severe");
                _warningLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.warning");
                _infoLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.info");
                _configLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.config");
                _fineLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.fine");
                _finerLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.finer");
                _finestLoggers = CustomerLogger.getEnabledLoggers("oracle.j2ee.logging.finest");
            }
        }
        if (CustomerLogger.isDynamicallyEnabled(_finestLoggers, loggerName)) {
            return Level.FINEST;
        }
        if (CustomerLogger.isDynamicallyEnabled(_finerLoggers, loggerName)) {
            return Level.FINER;
        }
        if (CustomerLogger.isDynamicallyEnabled(_fineLoggers, loggerName)) {
            return Level.FINE;
        }
        if (CustomerLogger.isDynamicallyEnabled(_configLoggers, loggerName)) {
            return Level.CONFIG;
        }
        if (CustomerLogger.isDynamicallyEnabled(_infoLoggers, loggerName)) {
            return Level.INFO;
        }
        if (CustomerLogger.isDynamicallyEnabled(_warningLoggers, loggerName)) {
            return Level.WARNING;
        }
        if (CustomerLogger.isDynamicallyEnabled(_severeLoggers, loggerName)) {
            return Level.SEVERE;
        }
        return null;
    }

    private static boolean isDynamicallyEnabled(String[] loggerNames, String loggerName) {
        for (int i = 0; i < loggerNames.length; ++i) {
            String name = loggerNames[i];
            if (name.equals(loggerName)) {
                return true;
            }
            if (!loggerName.startsWith(name + '.')) continue;
            return true;
        }
        return false;
    }

    private static String[] getEnabledLoggers(final String propertyName) {
        ArrayList<String> enable = new ArrayList<String>();
        String propertyVal = "";
        propertyVal = null == System.getSecurityManager() ? System.getProperty(propertyName, "") : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName, "");
            }
        });
        StringTokenizer st = new StringTokenizer(propertyVal, ",");
        while (st.hasMoreTokens()) {
            String loggerName = st.nextToken();
            if (loggerName.length() <= 0) continue;
            if (!loggerName.startsWith("oracle")) {
                loggerName = CustomerLogger.selectKnownLoggerName(loggerName);
            }
            enable.add(loggerName);
        }
        String[] list = enable.toArray(new String[enable.size()]);
        return list;
    }

    private static String selectKnownLoggerName(String suffix) {
        for (int i = 0; i < ALL_LOGGER_NAMES.length; ++i) {
            String candidate = ALL_LOGGER_NAMES[i];
            if (!candidate.endsWith(suffix)) continue;
            return candidate;
        }
        return suffix;
    }
}

