/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.ws.server.deployment;

import com.evermind.xml.XMLUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebServiceHandler {
    private Collection portNames = new HashSet();
    private Collection soapHeaders = new HashSet();
    private Collection soapRoles = new HashSet();
    private Map initParams = new HashMap();
    private Map xmlNamespace;
    private String handlerClass = null;
    private String handlerName = null;

    public WebServiceHandler(Node node) {
        this.parseAssemblyNode(node);
    }

    public void postInit() throws InstantiationException {
        if (this.getHandlerName() == null) {
            throw new InstantiationException("handler-name tag is missing from handler group");
        }
        if (this.getHandlerClass() == null) {
            throw new InstantiationException("handler-class tag is missing from handler group");
        }
    }

    private void parseAssemblyNode(Node parent) {
        String parentNode = parent.getParentNode().getNodeName();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("handler-name")) {
                this.handlerName = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("handler-class")) {
                this.handlerClass = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("init-param")) {
                this.parseInitParam(node);
                continue;
            }
            if (name.equals("soap-header")) {
                String value = XMLUtils.getStringValue(node);
                if (value.length() != 0) {
                    this.soapHeaders.add(this.getSoapHeader(node, value));
                    continue;
                }
                this.parseSoapHeader(node);
                continue;
            }
            if (name.equals("soap-role")) {
                this.soapRoles.add(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("port-name")) continue;
            if (parentNode.equals("port-component")) {
                System.out.println("warn:tag <port-name> is not expected inside group handler in webservices.xml ");
                continue;
            }
            this.portNames.add(XMLUtils.getStringValue(node));
        }
    }

    private QName getSoapHeader(Node node, String value) {
        QName soapHeader;
        String ns;
        String localPart = value;
        if (value.indexOf(":") != -1) {
            ns = value.substring(0, value.indexOf(":"));
            localPart = value.substring(value.indexOf(":") + 1);
        } else {
            ns = "";
        }
        if (node instanceof XMLNode) {
            soapHeader = new QName(((XMLElement)node).resolveNamespacePrefix(ns), localPart);
        } else {
            this.parseNodeAttributes(node);
            soapHeader = new QName(this.getXmlNamespace(ns), localPart);
        }
        return soapHeader;
    }

    private void parseInitParam(Node parent) {
        NodeList nodes = parent.getChildNodes();
        String paramName = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("param-name")) {
                paramName = XMLUtils.getStringValue(node);
                continue;
            }
            if (!name.equals("param-value")) continue;
            value = XMLUtils.getStringValue(node);
            this.initParams.put(paramName, value);
        }
    }

    private void parseSoapHeader(Node parent) {
        NodeList nodes = parent.getChildNodes();
        String namespaceUri = "";
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("namespaceURI")) {
                namespaceUri = value = XMLUtils.getStringValue(node);
                continue;
            }
            if (!name.equals("localpart")) continue;
            value = XMLUtils.getStringValue(node);
            QName soapHeader = new QName(namespaceUri, value);
            this.soapHeaders.add(soapHeader);
        }
    }

    public String getHandlerClass() {
        return this.handlerClass;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public Map getInitParams() {
        return this.initParams;
    }

    public Collection getSoapHeaders() {
        return this.soapHeaders;
    }

    public Collection getSoapRoles() {
        return this.soapRoles;
    }

    public Collection getPortNames() {
        return this.portNames;
    }

    private void parseNodeAttributes(Node node) {
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String value = item.getNodeValue();
                if (name.startsWith("xmlns:")) {
                    name = name.substring(name.indexOf(":") + 1);
                    this.setXmlNamespace(name, value);
                    continue;
                }
                if (!name.startsWith("xmlns")) continue;
                name = "";
                this.setXmlNamespace(name, value);
            }
        }
    }

    private void setXmlNamespace(String name, String value) {
        if (this.xmlNamespace == null) {
            this.xmlNamespace = new HashMap();
        }
        this.xmlNamespace.put(name, value);
    }

    private String getXmlNamespace(String name) {
        if (this.xmlNamespace == null) {
            return "";
        }
        return (String)this.xmlNamespace.get(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n[debug]\tHandler name = " + this.handlerName);
        sb.append("\n[debug]\tHandler class name = " + this.handlerClass);
        Iterator i = this.getInitParams().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            sb.append("\n[debug]\tInit param: name= " + me.getKey().toString() + "    value= " + me.getValue().toString());
        }
        i = this.getSoapHeaders().iterator();
        while (i.hasNext()) {
            sb.append("\n[debug]\tSOAP Header QName =" + i.next().toString());
        }
        i = this.getSoapRoles().iterator();
        while (i.hasNext()) {
            sb.append("\n[debug]\tSOAP Role  =" + (String)((Object)i.next()));
        }
        i = this.getPortNames().iterator();
        while (i.hasNext()) {
            sb.append("\n[debug]\tPort name  =" + (String)((Object)i.next()));
        }
        return sb.toString();
    }
}

