/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.UploaderStateKeeper;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.IdGenerator;
import oracle.oc4j.util.FileUtils;

public class InternalUploader {
    private static Hashtable _uploaders = new Hashtable();

    public static Integer beginUpload(String fileName) throws IOException {
        File tmpDir = FileUtils.createTempDir();
        File uploadFile = new File(tmpDir, fileName);
        Integer id = IdGenerator.getId();
        UploaderStateKeeper.addState(id, uploadFile);
        FileOutputStream fout = new FileOutputStream(uploadFile);
        _uploaders.put(id, fout);
        return id;
    }

    public static void endUpload(Integer id) throws IOException {
        FileOutputStream fout = (FileOutputStream)_uploaders.get(id);
        if (fout == null) {
            throw new IOException("endUpload(), cannot find record for id " + id);
        }
        fout.close();
    }

    public static void upload(Integer id, byte[] data) throws IOException {
        FileOutputStream fout = (FileOutputStream)_uploaders.get(id);
        if (fout == null) {
            throw new IOException("upload(), cannot find record for id " + id);
        }
        fout.write(data);
    }

    public static void install(Integer id, ObjectName mbean, String operation, Object[] params, String[] sigs) throws DeployerException {
        try {
            File uploadFile = (File)UploaderStateKeeper.getState(id);
            DataSink sink = new DataSink(uploadFile.getAbsolutePath());
            sink.setUploadId(id);
            InternalUploader.internalInstall(sink, mbean, operation, params, sigs);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    public static void install(String filePath, ObjectName mbean, String operation, Object[] params, String[] sigs) throws DeployerException {
        try {
            DataSink sink = new DataSink(filePath);
            InternalUploader.internalInstall(sink, mbean, operation, params, sigs);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    private static void internalInstall(DataSink sink, ObjectName mbean, String operation, Object[] params, String[] sigs) throws DeployerException {
        try {
            params[0] = sink;
            sigs[0] = "oracle.oc4j.admin.jmx.shared.util.DataSink";
            MBeanServer mbeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            mbeanServer.invoke(mbean, operation, params, sigs);
        }
        catch (Throwable t) {
            throw new DeployerException(t);
        }
    }

    public static void clean(Integer id) throws IOException {
        FileOutputStream fout = (FileOutputStream)_uploaders.get(id);
        if (fout == null) {
            throw new IOException("clean(), cannot find record for id " + id);
        }
        fout.close();
        File uploadFile = (File)UploaderStateKeeper.getState(id);
        File tmpDir = uploadFile.getParentFile();
        FileUtils.recursiveRemove(tmpDir);
        UploaderStateKeeper.removeState(id);
    }
}

