/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.model.DefaultMBeanFactory;
import oracle.oc4j.admin.jmx.model.MBeanFactory;
import oracle.oc4j.admin.jmx.model.ModelMBeanProvider;

public class DefaultModelMBeanProvider
extends MessageLocalizationHelper
implements ModelMBeanProvider,
PersistentMBean {
    private static Logger logger_ = TraceLogger.getLogger(DefaultModelMBeanProvider.class);
    private Set constructors_ = null;
    private Set operations_ = null;
    private Set attributes_ = null;
    private Set notifications_ = null;
    private Map mbeanDescriptorProperties_ = null;
    private NotificationBroadcaster broadcaster_ = null;
    private boolean needInitializationAfterBeingUnregistered_ = false;
    private static final String commonResourceBundleLocation_ = "oracle.oc4j.admin.jmx.model.Messages";
    private MessageLocalizationHelper commonLocalizationHelper_ = null;
    private ObjectName registerObjectName_ = null;
    private MBeanServer mbeanServer_ = null;

    protected DefaultModelMBeanProvider(String resourceBundleLocation) {
        this(resourceBundleLocation, Locale.getDefault());
    }

    protected DefaultModelMBeanProvider(String resourceBundleLocation, Locale loc) {
        super(resourceBundleLocation, loc);
        this.commonLocalizationHelper_ = new MessageLocalizationHelper(commonResourceBundleLocation_, loc);
        this.init();
    }

    protected DefaultModelMBeanProvider(ResourceBundle resourceBundle, Locale loc) {
        super(resourceBundle, loc);
        this.commonLocalizationHelper_ = new MessageLocalizationHelper(commonResourceBundleLocation_, loc);
        this.init();
    }

    public final Locale getLocale() {
        return JMXStateFactory.getJMXState().getLocale();
    }

    public final void addMBeanDescriptorProperty(String name, Object value) {
        this.mbeanDescriptorProperties_.put(name, value);
    }

    public final synchronized void addModelMBeanAttributeInfo(ModelMBeanAttributeInfo info) {
        if (info == null) {
            return;
        }
        this.preventDuplicate(this.attributes_, info);
        this.attributes_.add(info);
    }

    public final synchronized void addModelMBeanOperationInfo(ModelMBeanOperationInfo info) {
        if (info == null) {
            return;
        }
        this.preventDuplicate(this.operations_, info);
        this.operations_.add(info);
    }

    public final synchronized void addModelMBeanAttributeInfo(ModelMBeanAttributeInfo info, Map extraDescriptorProperty) {
        if (info == null) {
            return;
        }
        this.preventDuplicate(this.attributes_, info);
        if (extraDescriptorProperty == null) {
            this.attributes_.add(info);
            return;
        }
        Descriptor desc = info.getDescriptor();
        Iterator iter = extraDescriptorProperty.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry val = iter.next();
            desc.setField((String)val.getKey(), val.getValue());
        }
        info.setDescriptor(desc);
        this.attributes_.add(info);
    }

    public final synchronized void addModelMBeanOperationInfo(ModelMBeanOperationInfo info, Map extraDescriptorProperty) {
        if (info == null) {
            return;
        }
        this.preventDuplicate(this.operations_, info);
        if (extraDescriptorProperty == null) {
            this.operations_.add(info);
            return;
        }
        Descriptor desc = info.getDescriptor();
        Iterator iter = extraDescriptorProperty.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry val = iter.next();
            desc.setField((String)val.getKey(), val.getValue());
        }
        info.setDescriptor(desc);
        this.operations_.add(info);
    }

    public final synchronized void addModelMBeanNotificationInfo(ModelMBeanNotificationInfo info) {
        this.notifications_.add(info);
    }

    public final synchronized void addModelMBeanConstructorInfo(ModelMBeanConstructorInfo info) {
        this.constructors_.add(info);
    }

    protected final ModelMBeanProvider getModelMBeanProvider(Locale loc) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> classInst = this.getClass();
        Class[] paramtypes = new Class[]{loc.getClass()};
        Constructor<?> locCons = classInst.getDeclaredConstructor(paramtypes);
        Object[] params = new Object[]{loc};
        Object inst = locCons.newInstance(params);
        return (ModelMBeanProvider)inst;
    }

    public ModelMBeanInfo getMBeanInfo(Locale loc) {
        ModelMBeanProvider provider;
        block9: {
            provider = this;
            try {
                provider = this.getModelMBeanProvider(loc);
            }
            catch (NoSuchMethodException e) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "MBean implementation class: " + this.getClass().getName() + " does not provide a constructor that takes a Locale instance", e);
                }
            }
            catch (InvocationTargetException e) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "MBean implementation class: " + this.getClass().getName() + " throws exception while creating instance using constructor" + " that takes Locale parameter: ", e);
                }
            }
            catch (Throwable t) {
                if (!logger_.isLoggable(Level.WARNING)) break block9;
                logger_.log(Level.WARNING, "MBean implementation class: " + this.getClass().getName() + " throws exception while creating instance using constructor" + " that takes Locale parameter: ", t);
            }
        }
        try {
            MBeanFactory mbeanFactory = DefaultMBeanFactory.getInstance();
            ModelMBeanInfo mbeanInf = mbeanFactory.getMBeanInfo(provider);
            return mbeanInf;
        }
        catch (MBeanException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new RuntimeException(e);
        }
    }

    public final ModelMBeanNotificationBroadcaster getModelMBeanNotificationBroadcaster() {
        return (ModelMBeanNotificationBroadcaster)this.broadcaster_;
    }

    public final NotificationBroadcaster getNotificationBroadcaster() {
        return this.broadcaster_;
    }

    public final void registerNotificationBroadcaster(NotificationBroadcaster broadcaster) {
        this.broadcaster_ = broadcaster;
    }

    public final Set getModelMBeanAttributeInfos() {
        return this.attributes_;
    }

    public final Set getModelMBeanOperationInfos() {
        return this.operations_;
    }

    public final Set getModelMBeanNotificationInfos() {
        return this.notifications_;
    }

    public final Set getModelMBeanConstructorInfos() {
        return this.constructors_;
    }

    public Descriptor getDescriptor() {
        return null;
    }

    public Map getDescriptorProperties() {
        return this.mbeanDescriptorProperties_;
    }

    public String getDescription() {
        return this.getCommonLocalizationHelper().getLocalizedMessage("defaultmbeanprovider_description");
    }

    public final void registerModelMBeanNotificationBroadcaster(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster_ = broadcaster;
    }

    public void postDeregister() {
        this.registerObjectName_ = null;
        this.constructors_ = null;
        this.operations_ = null;
        this.attributes_ = null;
        this.notifications_ = null;
        this.mbeanDescriptorProperties_ = null;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.registerObjectName_ = null;
        }
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.registerObjectName_ = name;
        this.mbeanServer_ = server;
        return name;
    }

    protected MBeanServer getMBeanServer() {
        return this.mbeanServer_;
    }

    public void addNotificationListenerCallBack(NotificationListener listener, NotificationFilter filter, Object handback, long listenerCount) {
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
    }

    public void removeNotificationListenerCallBack(NotificationListener listener, NotificationFilter filter, Object handback, long listenerCount) {
    }

    protected final ObjectName getRegisteredObjectName() {
        return this.registerObjectName_;
    }

    protected final MessageLocalizationHelper getCommonLocalizationHelper() {
        return this.commonLocalizationHelper_;
    }

    protected final void addStateManageableInfo() {
        String[] notifType = new String[]{"j2ee.state.starting", "j2ee.state.running", "j2ee.state.stopped", "j2ee.state.stopping", "j2ee.state.failed"};
        this.addModelMBeanNotificationInfo(new ModelMBeanNotificationInfo(notifType, "javax.management.Notification", this.getCommonLocalizationHelper().getLocalizedMessage("statemanageable_notifications")));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("start", this.getCommonLocalizationHelper().getLocalizedMessage("statemanageable_start"), null, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("stop", this.getCommonLocalizationHelper().getLocalizedMessage("statemanageable_stop"), null, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("startRecursive", this.getCommonLocalizationHelper().getLocalizedMessage("statemanageable_startrecursive"), null, "void", 1));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("startTime", "long", this.getCommonLocalizationHelper().getLocalizedMessage("statemanageable_startTime"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("state", "int", this.getCommonLocalizationHelper().getLocalizedMessage("statemanageable_state"), true, false, false));
    }

    protected void fireEvent(Notification event) {
        try {
            ModelMBeanNotificationBroadcaster broadcaster = this.getModelMBeanNotificationBroadcaster();
            if (broadcaster != null) {
                broadcaster.sendNotification(event);
            }
        }
        catch (MBeanException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            throw new RuntimeException(e);
        }
    }

    private void preventDuplicate(Set metaData, MBeanFeatureInfo info) {
        String name = info.getName();
        Iterator it = metaData.iterator();
        while (it.hasNext()) {
            MBeanFeatureInfo finfo = (MBeanFeatureInfo)it.next();
            String mname = finfo.getName();
            if (!mname.equals(name)) continue;
            if (info instanceof ModelMBeanOperationInfo) {
                ModelMBeanOperationInfo mboinf = (ModelMBeanOperationInfo)info;
                ModelMBeanOperationInfo mboinfNew = (ModelMBeanOperationInfo)finfo;
                MBeanParameterInfo[] mboinfParams = mboinf.getSignature();
                MBeanParameterInfo[] mboinfNewParams = mboinfNew.getSignature();
                if (mboinfParams == null && mboinfNewParams == null || mboinfParams.length == 0 && mboinfNewParams.length == 0) {
                    it.remove();
                    return;
                }
                if (mboinfParams != null && mboinfNewParams != null && mboinfParams.length == mboinfNewParams.length) {
                    boolean isSameOper = true;
                    for (int cpt = 0; cpt < mboinfParams.length; ++cpt) {
                        if (mboinfParams[cpt].getType().equals(mboinfNewParams[cpt].getType())) continue;
                        isSameOper = false;
                        break;
                    }
                    if (isSameOper) {
                        it.remove();
                    }
                }
            } else {
                it.remove();
            }
            return;
        }
    }

    private void init() {
        this.constructors_ = new HashSet();
        this.operations_ = new HashSet();
        this.attributes_ = new HashSet();
        this.notifications_ = new HashSet();
        this.mbeanDescriptorProperties_ = new HashMap();
        this.mbeanDescriptorProperties_.put("currencyTimeLimit", new Integer(-1));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("locale", "java.util.Locale", this.getCommonLocalizationHelper().getLocalizedMessage("defaultmbeanprovider_getMBeanInfo_locale"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getMBeanInfo", this.getCommonLocalizationHelper().getLocalizedMessage("defaultmbeanprovider_getMBeanInfo"), params, "javax.management.modelmbean.ModelMBeanInfo", 0));
    }
}

