/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.oc4j.admin.jmx.web.HandlingException;

public class CompositeDataItem
implements Serializable {
    private String name_;
    private String desc_;
    private String type_;
    private Object value_;

    public CompositeDataItem(String name, String desc, String type, Object value) {
        this.name_ = name;
        this.desc_ = desc;
        this.type_ = type;
        this.value_ = value;
    }

    public String getName() {
        return this.name_;
    }

    public String getDesc() {
        return this.desc_;
    }

    public String getType() {
        return this.type_;
    }

    public Object getValue() {
        return this.value_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void setDesc(String desc) {
        this.desc_ = desc;
    }

    public void setType(String type) {
        this.type_ = type;
    }

    public void setValue(Object value) {
        this.value_ = value;
    }

    public static CompositeDataItem[] compactCompositeDataItems(CompositeDataItem[] datas) {
        if (datas == null) {
            return null;
        }
        ArrayList<CompositeDataItem> list = new ArrayList<CompositeDataItem>();
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i] == null || datas[i].getName() == null || datas[i].getDesc() == null) continue;
            list.add(datas[i]);
        }
        CompositeDataItem[] compact = new CompositeDataItem[list.size()];
        compact = list.toArray(compact);
        for (int i = 0; i < compact.length; ++i) {
            CompositeDataItem item = compact[i];
            Object tmpValue = item.getValue();
            if (!(tmpValue instanceof CompositeDataItem[])) continue;
            item.setValue(CompositeDataItem.compactCompositeDataItems((CompositeDataItem[])tmpValue));
        }
        return compact;
    }

    public static CompositeData convertToCompositeDataSupport(String typeName, String typeDesc, CompositeDataItem[] datas) throws HandlingException {
        return CompositeDataItem.convertToCompositeDataSupport(typeName, typeDesc, datas, new Vector());
    }

    private static CompositeData convertToCompositeDataSupport(String typeName, String typeDesc, CompositeDataItem[] datas, Vector pos) throws HandlingException {
        try {
            String[] names = new String[datas.length];
            String[] descs = new String[datas.length];
            OpenType[] types = new OpenType[datas.length];
            Object[] values = new Object[datas.length];
            pos = (Vector)pos.clone();
            pos.add(new Integer(0));
            for (int i = 0; i < datas.length; ++i) {
                pos.set(pos.size() - 1, new Integer(i));
                names[i] = datas[i].getName();
                descs[i] = datas[i].getDesc();
                String typeStr = datas[i].getType();
                if (typeStr.equals("javax.management.openmbean.CompositeData")) {
                    String subTypeName = CompositeDataItem.genTypeName(pos);
                    String subTypeDesc = subTypeName + " typeDesc";
                    values[i] = CompositeDataItem.convertToCompositeDataSupport(subTypeName, subTypeDesc, (CompositeDataItem[])datas[i].getValue(), pos);
                    types[i] = ((CompositeData)values[i]).getCompositeType();
                    continue;
                }
                types[i] = SimpleType.STRING;
                values[i] = (String)datas[i].getValue();
            }
            if (typeDesc == null || typeDesc.length() == 0) {
                typeDesc = typeName + " description";
            }
            CompositeType resultType = new CompositeType(typeName, typeDesc, names, descs, types);
            CompositeDataSupport result = new CompositeDataSupport(resultType, names, values);
            return result;
        }
        catch (Exception ode) {
            StringBuffer msgBuf = new StringBuffer("can't covert the following to a CompositeData\n");
            msgBuf.append("processing node: ").append(pos).append("\n");
            msgBuf.append(CompositeDataItem.toStringWithIndex(datas));
            throw new HandlingException(ode, msgBuf.toString());
        }
    }

    private static String genTypeName(Vector pos) {
        StringBuffer buf = new StringBuffer("CompositeType");
        for (int i = 0; i < pos.size(); ++i) {
            buf.append('-').append(pos.get(i));
        }
        return buf.toString();
    }

    public String toString() {
        CompositeDataItem[] items = new CompositeDataItem[]{this};
        return CompositeDataItem.toString(items);
    }

    public static String toString(CompositeDataItem[] items) {
        return CompositeDataItem.toStringWithIndex(items, new Vector(), false);
    }

    public static String toStringWithIndex(CompositeDataItem[] items) {
        return CompositeDataItem.toStringWithIndex(items, new Vector(), true);
    }

    public static String toStringWithIndex(CompositeDataItem[] items, boolean showIndex) {
        return CompositeDataItem.toStringWithIndex(items, new Vector(), showIndex);
    }

    private static String toStringWithIndex(CompositeDataItem[] items, Vector pos, boolean showIndex) {
        if (items == null) {
            return "";
        }
        pos = (Vector)pos.clone();
        pos.add(new Integer(0));
        String indent = "";
        for (int i = 0; i < pos.size() - 1; ++i) {
            indent = indent + "  ";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getName() == null || items[i].getValue() == null || items[i].getDesc() == null) continue;
            pos.set(pos.size() - 1, new Integer(i));
            boolean isComposite = items[i].getValue() instanceof CompositeDataItem[];
            buf.append(indent);
            if (showIndex) {
                buf.append(pos).append(' ');
            }
            buf.append(items[i].getName()).append(',').append(isComposite ? "<CompositeData>" : items[i].getValue()).append(',').append(CompositeDataItem.shortenType(items[i].getType())).append(',').append(items[i].getDesc()).append('\n');
            if (!isComposite) continue;
            buf.append(CompositeDataItem.toStringWithIndex((CompositeDataItem[])items[i].getValue(), pos, showIndex));
        }
        return buf.toString();
    }

    public static String toString(CompositeData data) {
        return CompositeDataItem.toStringWithIndex(data, new Vector(), false);
    }

    public static String toStringWithIndex(CompositeData data) {
        return CompositeDataItem.toStringWithIndex(data, new Vector(), true);
    }

    private static String toStringWithIndex(CompositeData data, Vector pos, boolean showIndex) {
        CompositeType dataType = data.getCompositeType();
        Object[] nameObjs = dataType.keySet().toArray();
        String[] names = new String[nameObjs.length];
        String[] descs = new String[names.length];
        String[] types = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = nameObjs[i].toString();
            descs[i] = dataType.getDescription(names[i]);
            types[i] = dataType.getType(names[i]).getClassName();
        }
        Object[] values = data.getAll(names);
        pos = (Vector)pos.clone();
        pos.add(new Integer(0));
        String indent = "";
        for (int i = 0; i < pos.size() - 1; ++i) {
            indent = indent + "  ";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            pos.set(pos.size() - 1, new Integer(i));
            boolean isComposite = types[i].endsWith("CompositeData");
            buf.append(indent);
            if (showIndex) {
                buf.append(pos).append(' ');
            }
            buf.append(names[i]).append(',').append(isComposite ? "<CompositeData>" : values[i]).append(',').append(CompositeDataItem.shortenType(types[i])).append(',').append(descs[i]).append('\n');
            if (!isComposite) continue;
            buf.append(CompositeDataItem.toStringWithIndex((CompositeData)values[i], pos, showIndex));
        }
        return buf.toString();
    }

    private static String shortenType(String type) {
        int lastIndex = type.lastIndexOf(46);
        if (lastIndex > 0) {
            return type.substring(lastIndex + 1);
        }
        return type;
    }
}

