/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.web.RequestHandler;

public class JMXGenericServlet
extends HttpServlet {
    private static Logger logger_ = TraceLogger.getLogger(JMXGenericServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block3: {
            String domain = req.getParameter("domain");
            if (domain == null) {
                throw new ServletException("Domain identifying MBeanServer cannot be null");
            }
            String extraParam = "domain=" + domain;
            try {
                RequestHandler reqHandler = new RequestHandler(req, res, this.getMBeanServer(domain), this.getDomainName(), extraParam);
                reqHandler.handleRequest();
            }
            catch (Throwable t) {
                if (!logger_.isLoggable(Level.SEVERE)) break block3;
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
        }
    }

    protected MBeanServer getMBeanServer(String domain) throws ServletException {
        ArrayList<MBeanServer> allMBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (allMBeanServers == null || allMBeanServers.size() == 0) {
            throw new ServletException("No MBeanServer registered for domain: " + domain);
        }
        Iterator it = allMBeanServers.iterator();
        while (it.hasNext()) {
            MBeanServer mbsrv = (MBeanServer)it.next();
            String defaultDomain = mbsrv.getDefaultDomain();
            if (!domain.equals(defaultDomain)) continue;
            return mbsrv;
        }
        throw new ServletException("No MBeanServer registered for domain: " + domain);
    }

    protected String getDomainName() {
        return "generic";
    }
}

