/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationType;
import oracle.classloader.MBean;
import oracle.classloader.MBeanTarget;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.util.ArrayUtils;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.ClassLoaderMBean;
import oracle.oc4j.admin.management.mbeans.ClassLoadingMBeanBase;
import oracle.oc4j.admin.management.mbeans.CodeSource;

public class ClassLoader
extends ClassLoadingMBeanBase
implements ClassLoaderMBean {
    private WeakReference ref;

    public static synchronized ObjectName getObjectNameFor(PolicyClassLoader loader, boolean createMBean) {
        ObjectName result = null;
        try {
            MBean mBean = loader.getMBean();
            if (mBean != null) {
                result = (ObjectName)mBean.getName();
            } else if (createMBean) {
                ClassLoader newBean = new ClassLoader(loader);
                result = newBean.objectName();
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
        return result;
    }

    public static ObjectName[] getObjectNamesFor(PolicyClassLoader[] loaders, boolean createMBeans) {
        ObjectName[] result = EMPTY_OBJECT_NAME_ARRAY;
        if (loaders != null) {
            int nullCount = ArrayUtils.countNull((Object[])loaders, (int)loaders.length);
            if (nullCount > 0) {
                loaders = (PolicyClassLoader[])ArrayUtils.copyAndCompress((Object[])loaders, (int)loaders.length);
            }
            int count = loaders.length;
            result = new ObjectName[count];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ClassLoader.getObjectNameFor(loaders[i], createMBeans);
            }
        }
        return result;
    }

    public static ObjectName[] getObjectNamesFor(List loaders, boolean createMBeans) {
        ObjectName[] result = EMPTY_OBJECT_NAME_ARRAY;
        if (loaders != null) {
            int count = loaders.size();
            result = new ObjectName[count];
            int index = 0;
            Iterator iterator = loaders.iterator();
            while (iterator.hasNext()) {
                PolicyClassLoader loader = (PolicyClassLoader)iterator.next();
                result[index++] = ClassLoader.getObjectNameFor(loader, createMBeans);
            }
        }
        return result;
    }

    private ClassLoader(PolicyClassLoader loader) {
        super("ClassLoader", loader.getName() + '-' + loader.getVersionNumber().toString(), (MBeanTarget)loader);
        this.ref = new WeakReference<PolicyClassLoader>(loader);
    }

    public ClassLoader(Locale loc) {
        super("ClassLoader", loc);
    }

    private PolicyClassLoader getLoader() {
        PolicyClassLoader loader = (PolicyClassLoader)this.ref.get();
        if (loader == null) {
            throw new JMXRuntimeException("Loader was GC'd!");
        }
        return loader;
    }

    protected void initMetaData() {
        super.initMetaData();
        this.initReadOnlyAttribute("origin", "java.lang.String");
        this.initReadOnlyAttribute("scope", "java.lang.String");
        this.initReadOnlyIsAttribute("shared", "boolean");
        this.initReadOnlyIsAttribute("system", "boolean");
        this.initReadOnlyIsAttribute("application", "boolean");
        this.initReadOnlyAttribute("searchPolicyDescription", "java.lang.String");
        this.initReadOnlyAttribute("configurationOptions", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("parent", "javax.management.ObjectName");
        this.initReadOnlyAttribute("children", "[Ljavax.management.ObjectName;");
        this.initReadOnlyAttribute("sharedLibraries", "[Ljavax.management.ObjectName;");
        this.initReadOnlyAttribute("codeSources", "[Ljavax.management.ObjectName;");
        this.initReadOnlyAttribute("nativeCodeSources", "[Ljavax.management.ObjectName;");
        this.initReadOnlyAttribute("loadedClasses", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("loadedPackages", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("classPath", "[Ljava.lang.String;");
        this.initReadOnlyAttribute("bufferSize", "int");
        this.initReadOnlyAttribute("importedBy", "[Ljavax.management.ObjectName;");
    }

    public String getorigin() {
        return this.getLoader().getOrigin().toString();
    }

    public String getscope() {
        return this.getLoader().getScope().toString();
    }

    public boolean getshared() {
        return this.getLoader().isSharedLoader();
    }

    public boolean getsystem() {
        return this.getLoader().isSystemLoader();
    }

    public boolean getapplication() {
        return this.getLoader().isApplicationLoader();
    }

    public String getsearchPolicyDescription() {
        return this.getLoader().getSearchPolicy().toString();
    }

    public String[] getconfigurationOptions() {
        ConfigurationType[] types = this.getLoader().getConfigurationPolicy().getTypes();
        int count = types.length;
        String[] result = new String[count];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i].toString();
        }
        return result;
    }

    public ObjectName getparent() {
        PolicyClassLoader parent = this.getLoader().parent();
        if (parent != null) {
            return ClassLoader.getObjectNameFor(parent, true);
        }
        return null;
    }

    public ObjectName[] getchildren() {
        return ClassLoader.getObjectNamesFor(this.getLoader().getChildren(), true);
    }

    public ObjectName[] getsharedLibraries() {
        return ClassLoader.getObjectNamesFor(this.getLoader().getImports(), true);
    }

    public ObjectName[] getcodeSources() {
        SharedCodeSource[] sources = this.getLoader().getCodeSources(true);
        int count = sources.length;
        ObjectName[] result = new ObjectName[count];
        for (int i = 0; i < sources.length; ++i) {
            result[i] = CodeSource.getObjectNameFor(sources[i], true);
        }
        return result;
    }

    public ObjectName[] getnativeCodeSources() {
        ObjectName[] result = EMPTY_OBJECT_NAME_ARRAY;
        SharedCodeSource[] sources = this.getLoader().getNativeCodeSources();
        if (sources != null) {
            int count = sources.length;
            result = new ObjectName[count];
            for (int i = 0; i < sources.length; ++i) {
                result[i] = CodeSource.getObjectNameFor(sources[i], true);
            }
        }
        return result;
    }

    public String[] getloadedClasses() {
        List list = this.getLoader().getLoadedClasses();
        int count = list.size();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            Class clz = (Class)list.get(i);
            result[i] = clz.getName();
        }
        return result;
    }

    public String[] getloadedPackages() {
        Map map = this.getLoader().getLoadedPackages();
        Set list = map.keySet();
        return (String[])ArrayUtils.toArray((Class)String.class, list, (boolean)true);
    }

    public String[] getclassPath() {
        List list = ClassLoaderQuery.getClassPathAsList((PolicyClassLoader)this.getLoader(), (boolean)true);
        return (String[])ArrayUtils.toArray((Class)String.class, (Collection)list, (boolean)true);
    }

    public int getbufferSize() {
        return this.getLoader().getBufferSize();
    }

    public ObjectName[] getimportedBy() {
        ObjectName[] result = EMPTY_OBJECT_NAME_ARRAY;
        PolicyClassLoader loader = this.getLoader();
        if (loader.isSharedLoader()) {
            PolicyClassLoader[] subscribers = loader.getSubscribers().getSubscribers();
            result = ClassLoader.getObjectNamesFor(subscribers, true);
        }
        return result;
    }
}

