/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.server.connector.deployment.PrincipalHolder;
import com.evermind.server.connector.deployment.PrincipalMappingEntries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionFactoryCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionFactoryMetricCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JCAConnectionFactoryMBean;
import oracle.oc4j.admin.management.shared.JCAConfigurationProperty;
import oracle.oc4j.admin.management.shared.JCAPrincipal;
import oracle.oc4j.admin.management.shared.statistic.JCAConnectionFactoryStatsImpl;

public class JCAConnectionFactory
extends J2EEServerDependentObjectBase
implements JCAConnectionFactoryMBean {
    JCAConnectionFactoryCallBackIf callBackIf_ = null;
    String stdSearchSuffix = null;

    public JCAConnectionFactory(JCAConnectionFactoryCallBackIf callBackIf, String connectorName, String moduleName, String j2eeAppName, String j2eeServerName, String domain) {
        super(domain, j2eeServerName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=JCAConnectionFactory,name=" + this.callBackIf_.getJndiLocation() + ",JCAResource=JCAResource,ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName);
        this.stdSearchSuffix = ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + j2eeServerName + ",*";
        this.init();
    }

    public JCAConnectionFactory(JCAConnectionFactoryCallBackIf callBackIf, String connectorName, String moduleName, String j2eeAppName) {
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=JCAConnectionFactory,name=" + this.callBackIf_.getJndiLocation() + ",JCAResource=JCAResource,ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName());
        this.stdSearchSuffix = ",ResourceAdapter=" + connectorName + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName() + ",*";
        this.init();
    }

    public JCAConnectionFactory(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("stats", "javax.management.j2ee.statistics.Stats", this.getLocalizedMessage("connectionfactory_stats"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionFactoryInterface", "java.lang.String", this.getLocalizedMessage("connectionfactory_connectionFactoryInterface"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionInterface", "java.lang.String", this.getLocalizedMessage("connectionfactory_connectionInterface"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("managedConnectionFactory", "java.lang.String", this.getLocalizedMessage("connectionfactory_managedConnectionFactory"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("managedConnectionFactoryClass", "java.lang.String", this.getLocalizedMessage("connectionfactory_managedConnectionFactoryClass"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("configProperties", "java.util.List", this.getLocalizedMessage("connectionfactory_configProperties"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("inUseConnectionPool", "java.lang.String", this.getLocalizedMessage("connectionfactory_inUseConnectionPool"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("privateConnectionPool", "java.lang.String", this.getLocalizedMessage("connectionfactory_privateConnectionPool"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("log", "java.lang.String", this.getLocalizedMessage("connectionfactory_log"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("securityConfig", "java.lang.String", this.getLocalizedMessage("connectionfactory_securityConfig"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("xaRecoveryConfig", "java.util.List", this.getLocalizedMessage("connectionfactory_xaRecoveryConfig"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("defaultResourceUser", "java.lang.String", this.getLocalizedMessage("connectionfactory_defaultResourceUser"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("defaultResourcePassword", "java.lang.String", this.getLocalizedMessage("connectionfactory_defaultResourcePassword"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getPrincipalMappings", this.getLocalizedMessage("connectionfactory_getPrincipalMappings"), new MBeanParameterInfo[0], "java.util.Map", 0));
        MBeanParameterInfo[] setPrincipalMappingsParams = new MBeanParameterInfo[]{new MBeanParameterInfo("mappings", "java.util.Map", this.getLocalizedMessage("connectionfactory_principalMappings"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setPrincipalMappings", this.getLocalizedMessage("connectionfactory_setPrincipalMappings"), setPrincipalMappingsParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] setDefaultPrincipalMappingParams = new MBeanParameterInfo[]{new MBeanParameterInfo("userName", "java.lang.String", this.getLocalizedMessage("connectionfactory_resourceUserName")), new MBeanParameterInfo("password", "java.lang.String", this.getLocalizedMessage("connectionfactory_resourcePassword"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setDefaultPrincipalMapping", this.getLocalizedMessage("connectionfactory_setDefaultPrincipalMapping"), setDefaultPrincipalMappingParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] addPrincipalMappingParams = new MBeanParameterInfo[]{new MBeanParameterInfo("initiatingUser", "java.lang.String", this.getLocalizedMessage("connectionfactory_initiatingUser")), new MBeanParameterInfo("resourceUser", "java.lang.String", this.getLocalizedMessage("connectionfactory_resourceUser")), new MBeanParameterInfo("resourcePassword", "java.lang.String", this.getLocalizedMessage("connectionfactory_resourcePassword"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addPrincipalMapping", this.getLocalizedMessage("connectionfactory_addPrincipalMapping"), addPrincipalMappingParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] removePrincipalMappingParams = new MBeanParameterInfo[]{new MBeanParameterInfo("initiatingUser", "java.lang.String", this.getLocalizedMessage("connectionfactory_initiatingUser"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removePrincipalMapping", this.getLocalizedMessage("connectionfactory_removePrincipalMapping"), removePrincipalMappingParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] setEISSignOnSchemeParams = new MBeanParameterInfo[]{new MBeanParameterInfo("scheme", "java.lang.String", this.getLocalizedMessage("connectionfactory_scheme"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("setEISSignOnScheme", this.getLocalizedMessage("connectionfactory_setEISSignOnScheme"), setEISSignOnSchemeParams, "void", 1), persistenceDescriptorProperties);
        String[] attributeChangeNotif = new String[]{AttributeChangeNotification.ATTRIBUTE_CHANGE};
        this.addModelMBeanNotificationInfo(new ModelMBeanNotificationInfo(attributeChangeNotif, "javax.management.AttributeChangeNotification", this.getLocalizedMessage("connectionfactory_attributeChangeNotification")));
    }

    public String getconnectionFactoryInterface() throws JMXException {
        return this.callBackIf_.getConnectionFactoryInterface();
    }

    public String getconnectionInterface() throws JMXException {
        return this.callBackIf_.getConnectionInterface();
    }

    public String getmanagedConnectionFactory() throws JMXException {
        ObjectName[] res = null;
        String managedConnectionFactoryPattern = "*:j2eeType=JCAManagedConnectionFactory,name=" + this.getmanagedConnectionFactoryClass() + this.stdSearchSuffix;
        res = this.getObjectNameForPattern(managedConnectionFactoryPattern);
        if (res.length == 1) {
            return res[0].toString();
        }
        return null;
    }

    public String getmanagedConnectionFactoryClass() throws JMXException {
        return this.callBackIf_.getManagedConnectionFactoryClass();
    }

    public List getconfigProperties() throws JMXException {
        List incomingProps = this.callBackIf_.getConnectionFactoryConfigProperties();
        if (incomingProps != null) {
            ArrayList<JCAConfigurationProperty> outgoingList = new ArrayList<JCAConfigurationProperty>(incomingProps.size());
            Iterator iter = incomingProps.iterator();
            while (iter.hasNext()) {
                ConfigurationProperty prop = (ConfigurationProperty)iter.next();
                JCAConfigurationProperty entry = new JCAConfigurationProperty(prop);
                outgoingList.add(entry);
            }
            return outgoingList;
        }
        return Collections.EMPTY_LIST;
    }

    public void setconfigProperties(List incomingProps) throws JMXException {
        if (incomingProps != null) {
            JCAConfigurationProperty entry;
            Iterator iter = incomingProps.iterator();
            while (iter.hasNext()) {
                try {
                    entry = (JCAConfigurationProperty)iter.next();
                }
                catch (ClassCastException e) {
                    throw new JMXException((Throwable)e, "Unable to set configuration properties on connection factory via MBean.");
                }
            }
            iter = incomingProps.iterator();
            while (iter.hasNext()) {
                try {
                    entry = (JCAConfigurationProperty)iter.next();
                    this.callBackIf_.setConnectionFactoryConfigProperty(entry.getName(), entry.getDeployedValue());
                }
                catch (InstantiationException e) {
                    throw new JMXException((Throwable)e, "Unable to set configuration properties on connection factory via MBean.");
                }
            }
        }
    }

    public String getinUseConnectionPool() throws JMXException {
        if (this.callBackIf_.isSharedConnectionPoolUsed()) {
            ObjectName[] res = null;
            String sharedPoolPattern = "*:j2eeType=JCASharedConnectionPool,name=" + this.callBackIf_.getSharedConnectionPoolName() + this.stdSearchSuffix;
            res = this.getObjectNameForPattern(sharedPoolPattern);
            if (res.length == 1) {
                return res[0].toString();
            }
        }
        return null;
    }

    public String getprivateConnectionPool() throws JMXException {
        if (this.callBackIf_.isPrivateConnectionPoolDefined()) {
            ObjectName[] res = null;
            String privatePoolPattern = "*:j2eeType=JCAConnectionPool,name=" + this.callBackIf_.getJndiLocation() + "-private" + this.stdSearchSuffix;
            res = this.getObjectNameForPattern(privatePoolPattern);
            if (res.length == 1) {
                return res[0].toString();
            }
        }
        return null;
    }

    public String getlog() throws JMXException {
        return this.callBackIf_.getConnectionFactoryLogLocation();
    }

    public void setlog(String newLog) throws JMXException {
        this.callBackIf_.setConnectionFactoryLogLocation(newLog);
    }

    public String getsecurityConfig() throws JMXException {
        if (this.callBackIf_.isPrincipalMappingEntriesDefined()) {
            return "principal-mapping-entries";
        }
        return "none";
    }

    public String getprincipalMappingInterface() throws JMXException {
        if (this.callBackIf_.isPrincipalMappingInterfaceDefined()) {
            return this.callBackIf_.getPrincipalMappingInterface();
        }
        return null;
    }

    public String getjaasModule() throws JMXException {
        return this.callBackIf_.getJaasModule();
    }

    public List getxaRecoveryConfig() throws JMXException {
        List xaCredList = this.callBackIf_.getXARecoveryCredentials();
        if (xaCredList != null) {
            ArrayList<JCAPrincipal> retVal = new ArrayList<JCAPrincipal>(xaCredList.size());
            Iterator itr = xaCredList.iterator();
            while (itr.hasNext()) {
                PrincipalHolder ph = (PrincipalHolder)itr.next();
                JCAPrincipal entry = new JCAPrincipal(ph);
                retVal.add(entry);
            }
            return retVal;
        }
        return Collections.EMPTY_LIST;
    }

    public void setxaRecoveryConfig(String user, String passwd) throws JMXException {
        try {
            this.callBackIf_.setXARecoveryCredential(user, passwd);
        }
        catch (Exception e) {
            throw new JMXException((Throwable)e, "Unable to set XA recovery credential user=" + user + ", password=" + passwd + ".");
        }
    }

    public void setxaRecoveryConfig(List config) throws JMXException {
        JCAPrincipal entry;
        if (config == null) {
            return;
        }
        Iterator itr = config.iterator();
        while (itr.hasNext()) {
            try {
                entry = (JCAPrincipal)itr.next();
            }
            catch (ClassCastException e) {
                throw new JMXException("Malformed configuration data. Unable to set XA recovery user/password via JMX");
            }
        }
        this.callBackIf_.clearXARecoveryCredentials();
        itr = config.iterator();
        while (itr.hasNext()) {
            entry = (JCAPrincipal)itr.next();
            this.setxaRecoveryConfig(entry.getUser(), entry.getPasswordInUse());
        }
    }

    public String getdefaultResourceUser() throws JMXException {
        if (this.callBackIf_.getPrincipalMappingEntries() != null) {
            return this.callBackIf_.getPrincipalMappingEntries().getDefaultResourceUser();
        }
        return null;
    }

    public String getdefaultResourcePassword() throws JMXException {
        if (this.callBackIf_.getPrincipalMappingEntries() != null) {
            return this.callBackIf_.getPrincipalMappingEntries().getDefaultResourcePassword();
        }
        return null;
    }

    public void setDefaultPrincipalMapping(String user, String password) throws JMXException {
        if (user != null && password != null) {
            PrincipalMappingEntries prinMapEntries = this.callBackIf_.getPrincipalMappingEntries();
            if (prinMapEntries == null) {
                prinMapEntries = this.callBackIf_.createPrincipalMappingEntries();
            }
            prinMapEntries.setDefaultMapping(user, password);
            this.callBackIf_.initPrincipalMappingProperties();
        }
    }

    public Map getPrincipalMappings() throws JMXException {
        if (!this.callBackIf_.isPrincipalMappingEntriesDefined()) {
            return Collections.EMPTY_MAP;
        }
        Map mappings = this.callBackIf_.getPrincipalMappingEntries().getMappings();
        if (mappings != null) {
            HashMap<String, JCAPrincipal> retVal = new HashMap<String, JCAPrincipal>(mappings.size());
            Iterator iter = mappings.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String initUser = (String)entry.getKey();
                PrincipalHolder resUser = (PrincipalHolder)entry.getValue();
                JCAPrincipal outgoingEntry = new JCAPrincipal(resUser);
                retVal.put(initUser, outgoingEntry);
            }
            return retVal;
        }
        return Collections.EMPTY_MAP;
    }

    public void setPrincipalMappings(Map incomingMap) throws JMXException {
        if (incomingMap != null) {
            HashMap<String, PrincipalHolder> outgoingMap = new HashMap<String, PrincipalHolder>(incomingMap.size());
            Iterator iter = incomingMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String initUser = (String)entry.getKey();
                try {
                    JCAPrincipal resUser = (JCAPrincipal)entry.getValue();
                    outgoingMap.put(initUser, new PrincipalHolder(resUser.getUser(), resUser.getPasswordInUse()));
                }
                catch (ClassCastException e) {
                    throw new JMXException("Malformed configuration data. Unable to set principal mappings via JMX");
                }
            }
            PrincipalMappingEntries prinMapEntries = this.callBackIf_.getPrincipalMappingEntries();
            if (prinMapEntries == null) {
                prinMapEntries = this.callBackIf_.createPrincipalMappingEntries();
            }
            prinMapEntries.setMappings(outgoingMap);
            this.callBackIf_.initPrincipalMappingProperties();
        }
    }

    public void addPrincipalMapping(String initiatingUser, String resourceUser, String resourcePassword) throws JMXException {
        try {
            PrincipalMappingEntries prinMapEntries = this.callBackIf_.getPrincipalMappingEntries();
            if (prinMapEntries == null) {
                prinMapEntries = this.callBackIf_.createPrincipalMappingEntries();
            }
            prinMapEntries.addPrincipalMapping(initiatingUser, resourceUser, resourcePassword);
            this.callBackIf_.initPrincipalMappingProperties();
        }
        catch (Exception e) {
            throw new JMXException((Throwable)e, "Unable to add principal mappingvia MBean.");
        }
    }

    public void removePrincipalMapping(String initiatingUser) throws JMXException {
        if (this.callBackIf_.getPrincipalMappingEntries() == null) {
            throw new JMXException("No PrincipalMapping entries exist.");
        }
        try {
            this.callBackIf_.getPrincipalMappingEntries().removePrincipalMapping(initiatingUser);
            this.callBackIf_.initPrincipalMappingProperties();
        }
        catch (Exception e) {
            throw new JMXException((Throwable)e, "Unable to remove principal mappingvia MBean.");
        }
    }

    public void setPrincipalMappingInterfaceClass(String clazz) throws JMXException {
        this.callBackIf_.setPrincipalMappingInterfaceClass(clazz);
    }

    public void setJaasModule(String name) throws JMXException {
        this.callBackIf_.setJaasModule(name);
    }

    public void useConnectionPool(String name) throws JMXException {
        if (name != null && !name.equalsIgnoreCase("none")) {
            this.callBackIf_.useConnectionPool(name);
        } else {
            this.callBackIf_.disableConnectionPooling();
        }
    }

    public void addConnectionPool(Map properties) throws JMXException {
        this.callBackIf_.addPrivateConnectionPool(properties);
    }

    public void setEISSignOnScheme(String scheme) throws JMXException {
        if (!scheme.equals("principal-mapping-entries") && !scheme.equals("none")) {
            throw new JMXException("Invalid scheme " + scheme + ". Only one of " + " two schemes allowed: principal-mapping-entries, " + "none.");
        }
        this.callBackIf_.setEISSignOnScheme(scheme);
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.callBackIf_.persistConfigChange();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private String getObjectNameAsString() {
        try {
            return this.getObjectName().toString();
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public boolean getstatisticsProvider() {
        return true;
    }

    public Stats getstats() {
        JCAConnectionFactoryMetricCallBackIf metricCallBack = this.callBackIf_.getFactoryMetrics();
        String mcf = null;
        try {
            mcf = this.getmanagedConnectionFactory();
        }
        catch (JMXException jMXException) {
            // empty catch block
        }
        return new JCAConnectionFactoryStatsImpl(J2EEManagedObjectBase.getLocaleForCall(), metricCallBack, this.getObjectNameAsString(), mcf);
    }
}

