/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.UnSupportedMBeanOperationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.management.callbackinterfaces.J2EEApplicationCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEResourceBase;
import oracle.oc4j.sql.DataSourceUtils;

public abstract class JDBCBase
extends J2EEResourceBase {
    private static Logger m_logger = Logger.getLogger(JDBCBase.class.getName());
    private String m_applicationName = null;
    private J2EEApplicationCallBackIf m_applicationCallBack = null;
    public static final Map ON_UPDATE_PERSISTENCE_PROPERTIES = new HashMap();
    public static final Map NEVER_PERSISTENCE_PROPERTIES = new HashMap();
    public static final Map ON_APPLICATION_RESTART_ONUPDATE_PERSISTENCE_PROPERTIES = new HashMap();

    public JDBCBase(String name, J2EEApplicationCallBackIf applicationCallBack) throws IllegalArgumentException {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("The Name cannot be null.");
        }
        if (applicationCallBack == null) {
            throw new IllegalArgumentException("The Application call back object cannot be null.");
        }
        this.m_applicationCallBack = applicationCallBack;
        this.m_applicationName = applicationCallBack.getName();
        this.setBaseObjectName();
    }

    public JDBCBase(Locale loc) {
        super(loc);
    }

    protected abstract void setBaseObjectName();

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void setProperty(Object target, String propertyName, String propertyValue) throws MBeanException {
        try {
            DataSourceUtils.setProperty(target, propertyName, propertyValue, true);
        }
        catch (Exception exception) {
            String msg = "Error occurred setting property '" + propertyName + "' to '" + propertyValue + "' on: '" + target.getClass().getName() + "'.  Exception was: " + exception;
            throw new MBeanException(exception, msg);
        }
    }

    public void registerMBean() throws MBeanException {
        ObjectName mbean = null;
        try {
            mbean = this.getObjectName();
        }
        catch (Exception exception) {
            String msg = "Exception occurred registerring '" + this.getName() + "'.  Exception: " + exception;
            m_logger.warning(msg);
            throw new MBeanException(exception, msg);
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        if (mbeanServer.isRegistered(mbean)) {
            try {
                mbeanServer.unregisterMBean(mbean);
            }
            catch (Exception exception) {
                String msg = "Exception occurred unregisterring '" + this.getName() + "'.  Exception: " + exception;
                m_logger.warning(msg);
                throw new MBeanException(exception, msg);
            }
        }
        try {
            mbeanServer.registerMBean(ModelMBeanFactory.getModelMBean(this), mbean);
        }
        catch (Exception exception) {
            String msg = "Exception occurred registerring '" + this.getName() + "'.  Exception: " + exception;
            m_logger.warning(msg);
            throw new MBeanException(exception, msg);
        }
    }

    public void unregisterMBean() throws MBeanException {
        try {
            MBeanServer mbeanServer = this.getMBeanServer();
            ObjectName mbean = this.getObjectName();
            if (mbeanServer.isRegistered(mbean)) {
                mbeanServer.unregisterMBean(mbean);
            }
        }
        catch (Exception exception) {
            String msg = "Exception occurred unregisterring '" + this.getName() + "'.  Exception: " + exception;
            m_logger.warning(msg);
            throw new MBeanException(exception, msg);
        }
        this.unregisterDependents();
    }

    public void unregisterDependents() {
    }

    public void unregisterMBeans(ObjectName mbeans) {
        MBeanServer mbeanServer = this.getMBeanServer();
        Iterator<ObjectName> iter = mbeanServer.queryNames(mbeans, null).iterator();
        while (iter.hasNext()) {
            ObjectName objectName = iter.next();
            if (!mbeanServer.isRegistered(objectName)) continue;
            try {
                mbeanServer.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                m_logger.warning("Exception occurred unregistering mbean '" + objectName.getCanonicalName() + "'.  Exception: " + exception.getMessage());
            }
        }
    }

    public J2EEApplicationCallBackIf getApplicationCallBack() {
        return this.m_applicationCallBack;
    }

    public void store() throws MBeanException {
        try {
            this.m_applicationCallBack.persistDataSourceConfig();
        }
        catch (IOException ioException) {
            throw new MBeanException(ioException);
        }
        catch (UnSupportedMBeanOperationException e) {
            throw new MBeanException(e);
        }
    }

    static {
        ON_UPDATE_PERSISTENCE_PROPERTIES.put("persistPolicy", "OnUpdate");
        NEVER_PERSISTENCE_PROPERTIES.put("persistPolicy", "Never");
        ON_APPLICATION_RESTART_ONUPDATE_PERSISTENCE_PROPERTIES.put("requireRestart", "applicationRestart");
        ON_APPLICATION_RESTART_ONUPDATE_PERSISTENCE_PROPERTIES.put("persistPolicy", "OnUpdate");
    }
}

