/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.MessageDrivenBeanCallBackIf;
import oracle.oc4j.admin.management.mbeans.EjbBase;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.MessageDrivenBeanMBean;
import oracle.oc4j.admin.management.shared.statistic.MessageDrivenBeanStatsImpl;

public class MessageDrivenBean
extends EjbBase
implements MessageDrivenBeanMBean {
    private static Logger logger_ = TraceLogger.getLogger(MessageDrivenBean.class);
    private String name_ = null;
    private MessageDrivenBeanCallBackIf callBackIf_ = null;

    public MessageDrivenBean(MessageDrivenBeanCallBackIf callBackIf, String domain, String j2eeServerName, String j2eeAppName, String moduleName, String compName) {
        super(callBackIf, domain, j2eeServerName, j2eeAppName, moduleName, compName, 2);
        this.name_ = compName;
        this.callBackIf_ = callBackIf;
        this.init();
    }

    public MessageDrivenBean(MessageDrivenBeanCallBackIf callBackIf, String j2eeServerName, String j2eeAppName, String moduleName, String compName) {
        super(callBackIf, j2eeServerName, j2eeAppName, moduleName, compName, 2);
        this.name_ = compName;
        this.callBackIf_ = callBackIf;
        this.init();
    }

    public MessageDrivenBean(MessageDrivenBeanCallBackIf callBackIf, String j2eeAppName, String moduleName, String compName) {
        super(callBackIf, "standalone", j2eeAppName, moduleName, compName, 2);
        this.name_ = compName;
        this.callBackIf_ = callBackIf;
        this.init();
    }

    public MessageDrivenBean(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addStateManageableInfo();
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transactionType", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_transactionType"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transactionAttribute", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_transactionAttribute"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("raEnabled", "java.lang.Boolean", this.getLocalizedMessage("messagedrivenbean_raEnabled"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("destination", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_destination"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionFactory", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_connectionFactory"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("messagingType", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_messagingType"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("destinationType", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_destinationType"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("subscriptionName", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_subscriptionName"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("listenerThreads", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_listenerThreads"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transactionTimeout", "java.lang.Integer", this.getLocalizedMessage("messagedrivenbean_transactionTimeout"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("messageSelector", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_messageSelector"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("acknowledgeMode", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_acknowledgeMode"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("subscriptionDurability", "java.lang.String", this.getLocalizedMessage("messagedrivenbean_subscriptionDurability"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("start", this.getLocalizedMessage("messagedrivenbean_start"), null, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("stop", this.getLocalizedMessage("messagedrivenbean_stop"), null, "void", 1));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("activeInstancesHighWaterMark", Integer.TYPE.getName(), this.getLocalizedMessage("messagedrivenbean_active_instances_high_water_mark"), true, false, false), null);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("activeInstances", Integer.TYPE.getName(), this.getLocalizedMessage("messagedrivenbean_active_instances"), true, false, false), null);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("enabled", Boolean.TYPE.getName(), this.getLocalizedMessage("messagedrivenbean_enabled"), true, true, false), null);
    }

    public String getDescription() {
        return this.getLocalizedMessage("messagedrivenbean_description");
    }

    protected final MessageDrivenBeanCallBackIf getMessageDrivenBeanCallBackIf() {
        return (MessageDrivenBeanCallBackIf)this.getCallBackIf();
    }

    public final boolean getstateManageable() {
        return true;
    }

    public final boolean geteventProvider() {
        return true;
    }

    public final void start() {
        block11: {
            MessageLocalizationHelper locHelp;
            block10: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                if (this.getstate() == 1 || this.getstate() == 0) {
                    this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
                    return;
                }
                if (this.getstate() == 2) {
                    ObjectName thisObj = null;
                    try {
                        thisObj = this.getObjectName();
                    }
                    catch (MalformedObjectNameException e) {
                        // empty catch block
                    }
                    throw new JMXRuntimeException("MDB: " + thisObj + " currently stopping. It cannot be started until stop operation completes.");
                }
                try {
                    Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.getMessageDrivenBeanCallBackIf().start();
                this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
            }
            catch (Throwable t) {
                try {
                    Notification notification = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_start") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block11;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public final void startRecursive() {
        this.start();
    }

    public final void stop() {
        block11: {
            MessageLocalizationHelper locHelp;
            block10: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                if (this.getstate() == 3 || this.getstate() == 2) {
                    this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
                    return;
                }
                if (this.getstate() == 0) {
                    ObjectName thisObj = null;
                    try {
                        thisObj = this.getObjectName();
                    }
                    catch (MalformedObjectNameException e) {
                        // empty catch block
                    }
                    throw new JMXRuntimeException("MDB: " + thisObj + " currently starting. It cannot be stopped until start operation completes.");
                }
                try {
                    Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_stopping") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.getMessageDrivenBeanCallBackIf().stop();
                this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
            }
            catch (Throwable t) {
                try {
                    Notification notification = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block11;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void stop(Map params) {
        this.stop();
    }

    public final long getstartTime() {
        return this.getMessageDrivenBeanCallBackIf().getstartTime();
    }

    public final int getstate() {
        return this.getMessageDrivenBeanCallBackIf().getstate();
    }

    private void reportStateManagementSuccess(String nofifType, String notifMsg) {
        block2: {
            try {
                Notification notification = new Notification(nofifType, this.getObjectName(), 0L, new Date().getTime(), notifMsg + this.getObjectName());
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public final void reportStop() {
        block2: {
            ResourceBundle bundle = this.getResourceBundle();
            MessageLocalizationHelper locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
            try {
                Notification notification = new Notification("j2ee.state.stopped", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("messagedrivenbean_statemanageable_mdb_stopped") + this.getobjectName());
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public Stats getstats() {
        return new MessageDrivenBeanStatsImpl(this.getApplicationName(), this.getDmsModuleId(), this.getComponentName(), J2EEManagedObjectBase.getLocaleForCall(), this.callBackIf_);
    }

    public String getname() {
        return this.callBackIf_.getName();
    }

    public String gettransactionType() {
        return this.callBackIf_.getTransactionType();
    }

    public String gettransactionAttribute() {
        return this.callBackIf_.getTransactionAttribute();
    }

    public Boolean getraEnabled() {
        return new Boolean(this.callBackIf_.getRAEnabled());
    }

    public String getdestination() {
        return this.callBackIf_.getDestination();
    }

    public String getconnectionFactory() {
        return this.callBackIf_.getConnectionFactory();
    }

    public String getmessagingType() {
        return this.callBackIf_.getMessagingType();
    }

    public String getdestinationType() {
        return this.callBackIf_.getDestinationType();
    }

    public String getsubscriptionName() {
        return this.callBackIf_.getSubscriptionName();
    }

    public int getlistenerThreads() {
        return this.callBackIf_.getListenerThreads();
    }

    public int gettransactionTimeout() {
        return this.callBackIf_.getTransactionTimeout();
    }

    public String getmessageSelector() {
        return this.callBackIf_.getMessageSelector();
    }

    public String getacknowledgeMode() {
        return this.callBackIf_.getAcknowledgeMode();
    }

    public String getsubscriptionDurability() {
        return this.callBackIf_.getSubscriptionDurability();
    }

    public boolean getenabled() {
        return this.callBackIf_.getEnabled();
    }

    public void setenabled(boolean enabled) {
        this.callBackIf_.setEnabled(enabled);
    }

    public void persistConfigChange() {
        this.callBackIf_.persistConfigChange();
    }
}

