/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.OpmnCompOc4jGroupCallBack;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompOc4jGroupCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnProcOc4jCallBackIf;
import oracle.oc4j.admin.management.mbeans.OpmnComp;
import oracle.oc4j.admin.management.mbeans.OpmnCompOc4jGroupMBean;
import oracle.oc4j.admin.management.mbeans.OpmnProc;
import oracle.oc4j.admin.management.mbeans.OpmnProcOc4j;

public class OpmnCompOc4jGroup
extends OpmnComp
implements OpmnCompOc4jGroupMBean {
    private static Logger logger_ = TraceLogger.getLogger(OpmnCompOc4jGroup.class);

    public OpmnCompOc4jGroup(OpmnCompCallBackIf callBackIf, String domain, String j2eeServerName) {
        super((OpmnCompOc4jGroupCallBackIf)callBackIf, domain, j2eeServerName);
    }

    public OpmnCompOc4jGroup(OpmnCompCallBackIf callBackIf) {
        super((OpmnCompOc4jGroupCallBackIf)callBackIf);
    }

    public OpmnCompOc4jGroup(Locale loc) {
        super(loc);
    }

    protected OpmnCompOc4jGroup(String domain) {
        super(domain);
    }

    protected void initPrivate() {
        HashMap<String, String> persistenceOnUpdate = new HashMap<String, String>();
        persistenceOnUpdate.put("persistPolicy", "OnUpdate");
        HashMap<String, String> persistenceNever = new HashMap<String, String>();
        persistenceNever.put("persistPolicy", "Never");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("removable", "boolean", this.getLocalizedMessage("opmncompoc4jgrp_removable"), true, false, true), persistenceNever);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("routingId", "java.lang.String", this.getLocalizedMessage("opmncompoc4jgrp_routingId"), true, true, false), persistenceOnUpdate);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("oc4jName", "java.lang.String", this.getLocalizedMessage("opmn_param_oc4jName")), new MBeanParameterInfo("password", "java.lang.String", this.getLocalizedMessage("opmn_param_password")), new MBeanParameterInfo("start", "boolean", this.getLocalizedMessage("opmncompoc4jgrp_param_start")), new MBeanParameterInfo("extraParams", "java.util.Map", this.getLocalizedMessage("opmncompoc4jgrp_param_extraParam"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("createOc4j", this.getLocalizedMessage("opmncompoc4jgrp_createOc4j"), params, "javax.management.ObjectName", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("oc4jName", "java.lang.String", this.getLocalizedMessage("opmn_param_oc4jName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeOc4j", this.getLocalizedMessage("opmncompoc4jgrp_removeOc4j"), params, "void", 1), persistenceOnUpdate);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("oc4jName", "java.lang.String", this.getLocalizedMessage("opmn_param_oc4jName")), new MBeanParameterInfo("groupName", "java.lang.String", this.getLocalizedMessage("opmn_param_oc4jGroupName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("moveOc4j", this.getLocalizedMessage("opmncompoc4jgrp_moveOc4j"), params, "javax.management.ObjectName", 1), persistenceOnUpdate);
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getOc4jProcs", this.getLocalizedMessage("opmncompoc4jgrp_getOc4jProcs"), null, "[Ljavax.management.ObjectName;", 0), persistenceNever);
    }

    public String getDescription() {
        return this.getLocalizedMessage("opmncompoc4jgrp_Oc4jGroup_desc");
    }

    public ObjectName[] getOc4jProcs() {
        if (this.procMBeans_ == null || this.procMBeans_.size() == 0) {
            return new ObjectName[0];
        }
        ArrayList<ObjectName> names = new ArrayList<ObjectName>();
        try {
            for (int i = 0; i < this.procMBeans_.size(); ++i) {
                ObjectName name = ((OpmnProc)this.procMBeans_.get(i)).getObjectName();
                if (!"OpmnProcOc4j".equals(name.getKeyProperty("type"))) continue;
                names.add(name);
            }
        }
        catch (MalformedObjectNameException mfe) {
            logger_.log(Level.WARNING, "proc mbean list contains non-ProcMBean type", mfe);
        }
        return names.toArray(new ObjectName[names.size()]);
    }

    public ObjectName createOc4j(String oc4jName, String password, boolean start, Map extraParams) throws ConfigMBeanException {
        OpmnProcCallBackIf oc4j = ((OpmnCompOc4jGroupCallBackIf)this.callBackIf_).createOc4j(oc4jName, password, start, extraParams);
        try {
            OpmnProc mbean = this.registerProcMBean(oc4j);
            return mbean.getObjectName();
        }
        catch (ConfigMBeanException e) {
            if (e.getErrorCode() == 66) {
                logger_.log(Level.SEVERE, "start oc4j instance fails: " + oc4jName, e);
            } else {
                logger_.log(Level.SEVERE, "create oc4j instance fails: " + oc4jName, e);
            }
            throw e;
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "create oc4j instance fails: " + oc4jName, e);
            throw ConfigMBeanExceptionHelper.getException(59, oc4jName, (Throwable)e, JMXStateFactory.getJMXState().getLocale());
        }
    }

    public void removeOc4j(String oc4jName) throws ConfigMBeanException {
        OpmnProcOc4j oc4jMBean = null;
        for (int i = 0; i < this.procMBeans_.size(); ++i) {
            OpmnProc mbean = (OpmnProc)this.procMBeans_.get(i);
            if (!mbean.getname().equals(oc4jName)) continue;
            try {
                oc4jMBean = (OpmnProcOc4j)mbean;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
            break;
        }
        if (oc4jMBean == null) {
            logger_.severe("couldn't find mbean for oc4j instance " + oc4jName);
            throw ConfigMBeanExceptionHelper.getException(56, oc4jName, this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        if (!oc4jMBean.isremovable()) {
            throw ConfigMBeanExceptionHelper.getException(60, oc4jName, JMXStateFactory.getJMXState().getLocale());
        }
        ((OpmnCompOc4jGroupCallBackIf)this.callBackIf_).removeOc4j(oc4jName, true);
        this.unregisterProcMBean(oc4jMBean);
    }

    public void removeAllOc4js() throws ConfigMBeanException {
        if (!this.isremovable()) {
            throw ConfigMBeanExceptionHelper.getException(54, this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        for (int i = this.procMBeans_.size() - 1; i >= 0; --i) {
            OpmnProcOc4j oc4jMBean = (OpmnProcOc4j)this.procMBeans_.get(i);
            this.removeOc4j(oc4jMBean.getname());
        }
    }

    public String getroutingId() {
        try {
            return this.getParameter("start-parameters", "routing-id");
        }
        catch (ConfigMBeanException e) {
            logger_.log(Level.SEVERE, "get oc4j group routing-id failed", e);
            return null;
        }
    }

    public void setroutingId(String routingId) throws ConfigMBeanException {
        ((OpmnCompOc4jGroupCallBackIf)this.callBackIf_).setRoutingId(routingId);
    }

    public boolean isremovable() {
        if (!((OpmnCompOc4jGroupCallBackIf)this.callBackIf_).isPureOc4jGroup()) {
            return false;
        }
        for (int i = 0; i < this.procMBeans_.size(); ++i) {
            OpmnProcOc4j oc4jMBean = (OpmnProcOc4j)this.procMBeans_.get(i);
            if (oc4jMBean.isremovable()) continue;
            return false;
        }
        return true;
    }

    public boolean getremovable() {
        return this.isremovable();
    }

    public ObjectName moveOc4j(String oc4jName, String groupName) throws ConfigMBeanException {
        OpmnProcOc4j oc4jMBean = this.getOc4jMBean(oc4jName);
        if (this.callBackIf_.getname().equals(groupName)) {
            throw ConfigMBeanExceptionHelper.getException(61, groupName, JMXStateFactory.getJMXState().getLocale());
        }
        if (((OpmnCompOc4jGroupCallBack)this.callBackIf_).isOc4jProcAlive(oc4jName)) {
            throw ConfigMBeanExceptionHelper.getException(70, oc4jName, JMXStateFactory.getJMXState().getLocale());
        }
        OpmnCompOc4jGroup tgtGroupMBean = this.getOc4jGroupMBean(groupName);
        OpmnProcOc4jCallBackIf oc4jCallBack = ((OpmnCompOc4jGroupCallBackIf)this.callBackIf_).removeOc4j(oc4jName, false);
        this.unregisterProcMBean(oc4jMBean);
        tgtGroupMBean.addOc4j(oc4jCallBack);
        try {
            OpmnProc mbean = tgtGroupMBean.registerProcMBean(oc4jCallBack);
            mbean.setParent(tgtGroupMBean);
            return mbean.getObjectName();
        }
        catch (Exception e) {
            logger_.log(Level.SEVERE, "register proc mbean failed", e);
            throw ConfigMBeanExceptionHelper.getException(3, e.getMessage(), JMXStateFactory.getJMXState().getLocale());
        }
    }

    protected OpmnProcOc4j getOc4jMBean(String oc4jName) throws ConfigMBeanException {
        OpmnProcOc4j oc4jMBean = null;
        for (int i = 0; i < this.procMBeans_.size(); ++i) {
            OpmnProc procMBean = (OpmnProc)this.procMBeans_.get(i);
            if (!procMBean.getname().equals(oc4jName)) continue;
            try {
                oc4jMBean = (OpmnProcOc4j)procMBean;
                continue;
            }
            catch (ClassCastException e) {
                throw ConfigMBeanExceptionHelper.getException(58, oc4jName, JMXStateFactory.getJMXState().getLocale());
            }
        }
        if (oc4jMBean == null) {
            throw ConfigMBeanExceptionHelper.getException(56, oc4jName, this.getname(), JMXStateFactory.getJMXState().getLocale());
        }
        return oc4jMBean;
    }

    OpmnCompOc4jGroup getOc4jGroupMBean(String grpName) throws ConfigMBeanException {
        OpmnCompOc4jGroup grpMBean = null;
        try {
            grpMBean = (OpmnCompOc4jGroup)this.parent_.getCompMBean(grpName);
        }
        catch (ClassCastException e) {
            throw ConfigMBeanExceptionHelper.getException(61, grpName, JMXStateFactory.getJMXState().getLocale());
        }
        if (grpMBean == null) {
            throw ConfigMBeanExceptionHelper.getException(51, grpName, JMXStateFactory.getJMXState().getLocale());
        }
        return grpMBean;
    }

    void addOc4j(OpmnProcOc4jCallBackIf oc4jCallBack) {
        ((OpmnCompOc4jGroupCallBackIf)this.callBackIf_).addOc4j(oc4jCallBack);
    }
}

