/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.appclient;

import [Ljava.lang.String;;
import com.evermind.server.ApplicationClientContext;
import com.evermind.server.DependencyManager;
import com.evermind.server.deployment.ApplicationClientArchive;
import com.evermind.server.deployment.J2EEContextAnnotationParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.naming.ApplicationClientInitialContextFactory;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.appclient.AppClientLauncher;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;

public class ApplicationClientLauncherImpl
implements AppClientLauncher,
ApplicationClientInitialContextFactory.J2EEContextCreationListener {
    private static Logger traceLogger = TraceLogger.getLogger(ApplicationClientLauncherImpl.class);
    private static final String PLAIN_CLIENT_DESCRIPTOR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><application-client xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2eehttp://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd\" version=\"1.4\"/>";
    protected Class m_mainClass;
    protected Method m_mainMethod;
    protected Context m_environmentContext;
    protected String m_mainClassName;
    private URLClassLoader m_classloader;
    private ApplicationClientContext m_appClientContext;

    public String getMainClassName() {
        return this.m_mainClassName;
    }

    public void init(String pathToClientJar) throws InstantiationException {
        ApplicationClientLauncherImpl.validateInput(pathToClientJar);
        try {
            JarFile jarFile = new JarFile(new File(pathToClientJar));
            this.m_mainClassName = ApplicationClientLauncherImpl.getMainClassName(jarFile.getManifest());
            this.m_classloader = new URLClassLoader(new URL[]{new File(jarFile.getName()).toURL()});
            this.m_mainClass = this.getMainClass(this.m_mainClassName, this.m_classloader);
        }
        catch (IOException e) {
            traceLogger.log(Level.FINE, "Error opening client archive");
            InstantiationException ie = new InstantiationException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (ClassNotFoundException e) {
            traceLogger.log(Level.FINE, "Can't find ApplicationClient's main class");
            InstantiationException ie = new InstantiationException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void initServices() throws InstantiationException {
        this.initializeJNDIService();
    }

    public Class getMainClass() {
        return this.m_mainClass;
    }

    public void injectDependencies() throws InstantiationException {
        this.injectDependenciesIntoContext();
    }

    public void launch(String[] parameters) {
        try {
            Method m = this.getMainMethod(this.m_mainClass);
            try {
                m.invoke(null, new Object[]{parameters});
            }
            catch (IllegalAccessException e) {
                traceLogger.log(Level.SEVERE, "Exception invoking Application Client's main class " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                traceLogger.log(Level.SEVERE, "Exception invoking Application Client's main class " + e.getMessage(), e);
            }
        }
        catch (NoSuchMethodException e) {
            traceLogger.log(Level.FINE, " Application Client's main class may not have a main method defined " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            traceLogger.log(Level.FINE, e.getMessage(), e);
        }
    }

    public void preLaunch() {
    }

    public void postLaunch() {
    }

    public void preJ2EEContextCreation(ApplicationClientArchive archive) {
        if (ApplicationClientLauncherImpl.isJDK1_5()) {
            try {
                this.parseAnnotations(archive);
            }
            catch (InstantiationException instantiationException) {
                traceLogger.log(Level.WARNING, "Exception during Annotation Parsing.  Injection points specified using annotations may not be available", instantiationException);
            }
        } else {
            traceLogger.log(Level.INFO, "ApplicationClientLauncher has not been started with JDK 1.5, annotation parsing will be skipped");
        }
    }

    protected static String getMainClassName(Manifest manifest) throws InstantiationException {
        String mainClassName = "";
        if (manifest != null) {
            mainClassName = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        }
        if (mainClassName == null) {
            throw new InstantiationException("Main Class not found");
        }
        return mainClassName.replace('/', '.');
    }

    protected Class getMainClass(String mainClassName, ClassLoader classLoader) throws InstantiationException, ClassNotFoundException {
        Class<?> clazz = Class.forName(mainClassName, true, classLoader);
        return clazz;
    }

    protected Method getMainMethod(Class clazz) throws NoSuchMethodException, InstantiationException {
        if (clazz == null) {
            throw new InstantiationException("Main Class not found, can't invoke main method");
        }
        return clazz.getMethod("main", String;.class);
    }

    private void initializeJNDIService() throws InstantiationException {
        InputStream resourceStream = this.m_classloader.getResourceAsStream("jndi.properties");
        if (resourceStream == null) {
            throw new InstantiationException("JNDI init: jndi.properties not found in the client jar");
        }
        Properties jndiProperties = new Properties();
        try {
            jndiProperties.load(resourceStream);
            Thread.currentThread().setContextClassLoader(this.m_classloader);
            LauncherApplicationClientInitialContextFactory appClientInitialContextFactory = new LauncherApplicationClientInitialContextFactory(this);
            this.m_appClientContext = (ApplicationClientContext)appClientInitialContextFactory.getInitialContext((Hashtable)jndiProperties);
            ApplicationClientInitialContextFactory.setContext(Thread.currentThread().getThreadGroup(), this.m_appClientContext);
            if (appClientInitialContextFactory.isDefaultDescriptorCreated()) {
                this.logWarningAppClientXMLNotFound();
            }
        }
        catch (NamingException ne) {
            InstantiationException ie = new InstantiationException("Exception initializing jndi context, " + ne.getMessage());
            ie.initCause(ne);
            throw ie;
        }
        catch (IOException e) {
            InstantiationException ie = new InstantiationException("Exception loading jndi.properties, " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private void parseAnnotations(ApplicationClientArchive archive) throws InstantiationException {
        J2EEContextConfigDelegate j2eeConfigDelegate = archive.getConfigDelegate();
        J2EEContextAnnotationParser annotationParser = new J2EEContextAnnotationParser();
        annotationParser.parseStaticInjection(j2eeConfigDelegate, this.getMainClass());
    }

    private void injectDependenciesIntoContext() throws InstantiationException {
        DependencyManager dependencyManager = new DependencyManager(this.m_appClientContext.getClientArchive(), this.getMainClass());
        dependencyManager.initialize();
        dependencyManager.resolveDependencies(this.m_appClientContext, null);
    }

    private boolean isDelegateEmpty() {
        J2EEContextConfigDelegate configDelegate = this.m_appClientContext.getClientArchive().getConfigDelegate();
        return configDelegate.isEmpty();
    }

    private static boolean isJDK1_5() {
        try {
            Class.class.getMethod("getDeclaredAnnotations", null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void validateInput(String pathToFile) throws InstantiationException {
        if (pathToFile == null) {
            throw new InstantiationException("Null path to application client jar");
        }
        if (pathToFile.length() == 0) {
            throw new InstantiationException("Empty path to application client jar");
        }
    }

    private void logWarningAppClientXMLNotFound() {
        if (!ApplicationClientLauncherImpl.isJDK1_5()) {
            traceLogger.log(Level.WARNING, "application-client.xml deployment descriptor not found");
        } else if (this.isDelegateEmpty()) {
            traceLogger.log(Level.WARNING, "Neither application-client.xml nor a set of annotations have been defined on this application client.  This means that no J2EE references are defined for this client");
        }
    }

    private static class LauncherApplicationClientInitialContextFactory
    extends ApplicationClientInitialContextFactory {
        private boolean m_defaultDescriptorCreated = false;

        private LauncherApplicationClientInitialContextFactory(ApplicationClientLauncherImpl launcherImpl) {
            super(launcherImpl);
        }

        private boolean isDefaultDescriptorCreated() {
            return this.m_defaultDescriptorCreated;
        }

        protected byte[] getRequiredClasspathResource(String resourceName, String errorMessage, Hashtable environment) throws NamingException {
            byte[] arrayToReturn = null;
            try {
                arrayToReturn = super.getRequiredClasspathResource(resourceName, errorMessage, environment);
                return arrayToReturn;
            }
            catch (NamingException namingException) {
                if (resourceName.equals("META-INF/application-client.xml") && arrayToReturn == null) {
                    this.m_defaultDescriptorCreated = true;
                    return ApplicationClientLauncherImpl.PLAIN_CLIENT_DESCRIPTOR.getBytes();
                }
                return arrayToReturn;
            }
        }
    }
}

