/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.common;

import com.evermind.security.User;
import com.evermind.security.UserManager;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import oracle.oc4j.common.UnsynchronizedStack;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.SecurityServices;

public class CommonThreadState {
    public Thread thread;
    public User user;
    protected User m_propagatedUser;
    protected Subject m_propagatedUserSubject;
    protected boolean m_clientSubjectMerged;
    private static ThreadLocal m_externalThreads;
    private static CommonThreadState m_examplar;
    private boolean m_callerIsORMI = false;
    protected UnsynchronizedStack _users = new UnsynchronizedStack();
    public static final Subject NO_SUBJECT;

    private static Subject createNOSUBJECT() {
        final Subject subject = new Subject();
        if (!OC4JSecurity.isSecurityOn()) {
            subject.setReadOnly();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    subject.setReadOnly();
                    return null;
                }
            });
        }
        return subject;
    }

    public static CommonThreadState getCurrent() {
        OC4JSecurity.assertIsSafe();
        return m_examplar.getCurrentState(Thread.currentThread());
    }

    public boolean isApplicationThread() {
        return false;
    }

    public boolean isServletRequestThread() {
        return false;
    }

    public String getServletRequestPath() {
        return null;
    }

    public void reset() {
    }

    public void resetCallerIsORMI() {
        this.m_callerIsORMI = false;
    }

    public void setCallerIsORMI() {
        this.m_callerIsORMI = true;
    }

    public boolean isCallerORMI() {
        return this.m_callerIsORMI;
    }

    protected static void setExamplar(CommonThreadState examplar) {
        OC4JSecurity.assertIsSafe();
        m_examplar = examplar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommonThreadState getCurrentState(Thread thread) {
        CommonThreadState state;
        if (m_externalThreads == null) {
            Class clazz = CommonThreadState.class;
            synchronized (clazz) {
                if (m_externalThreads == null) {
                    m_externalThreads = new ThreadLocal();
                }
            }
        }
        if ((state = (CommonThreadState)m_externalThreads.get()) == null) {
            state = this.newThreadState(thread);
            m_externalThreads.set(state);
        }
        return state;
    }

    protected CommonThreadState newThreadState(Thread thread) {
        return new CommonThreadState(thread);
    }

    protected CommonThreadState(Thread thread) {
        this.thread = thread;
    }

    public void pushPasswordAuthentication(PasswordAuthentication pa) {
        this._users.push(pa);
    }

    public PasswordAuthentication popPasswordAuthentication() {
        if (this._users.size() > 1) {
            return (PasswordAuthentication)this._users.pop();
        }
        return (PasswordAuthentication)this._users.peek();
    }

    public PasswordAuthentication getCurrentPasswordAuthentication() {
        return (PasswordAuthentication)this._users.peek();
    }

    public Subject getPropagatedSubject() {
        return NO_SUBJECT == this.getRawPropagatedSubject() ? null : this.getRawPropagatedSubject();
    }

    public Subject getRawPropagatedSubject() {
        return this.m_propagatedUserSubject;
    }

    public boolean isPropagatedSubjectMerged() {
        return this.m_clientSubjectMerged;
    }

    public void setPropagatedSubject(Subject subject) {
        this.m_propagatedUserSubject = null == subject ? NO_SUBJECT : subject;
    }

    public void setPropagatedSubject(Subject subject, boolean clientSubjectMerged) {
        this.setPropagatedSubject(subject);
        this.m_clientSubjectMerged = clientSubjectMerged;
    }

    public User getPropagatedUser() {
        return this.m_propagatedUser;
    }

    public void setPropagatedUser(User user) {
        if (this.m_propagatedUser != user || null == user) {
            this.m_propagatedUser = user;
            this.m_propagatedUserSubject = null;
        }
    }

    public Object setSystemContext() {
        return null;
    }

    public void restoreContext(Object context) {
    }

    public UserManager getContextUserManager() throws NamingException {
        return null;
    }

    public boolean isRemoteFatClient() {
        return true;
    }

    public User getUser() {
        return this.getActiveUser();
    }

    public User getActiveUser() {
        return this.user;
    }

    public void setActiveUser(User activeUser) {
        this.user = activeUser;
    }

    public User getRemoteUser() {
        return this.getActiveUser();
    }

    public void setRemoteUser(User remoteUser, Subject remoteUserSubject) {
        this.setActiveUser(remoteUser);
    }

    static {
        m_examplar = new CommonThreadState(null);
        NO_SUBJECT = CommonThreadState.createNOSUBJECT();
        SecurityServices.init(false);
    }
}

