/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.StatelessSessionEJBHome;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;
import oracle.oc4j.corba.ORBConfigurationException;
import oracle.oc4j.corba.ORBInitializationException;
import oracle.oc4j.corba.POAPolicyCreationStrategy;
import oracle.oc4j.corba.transport.AbstractReferenceGenerator;
import oracle.oc4j.corba.transport.BaseServantLocator;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.CorbaEJBObject;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.corba.transport.EntityObjectID;
import oracle.oc4j.corba.transport.StatefulObjectID;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

class EJBObjectReferenceGenerator
extends AbstractReferenceGenerator {
    protected POA m_ejbObjectPoa = null;

    EJBObjectReferenceGenerator(POA rootPoa, POAPolicyCreationStrategy policyStrategy, CorbaEJBHome home) throws ORBInitializationException {
        Policy[] policies;
        try {
            policies = this.createPOAPolicies(home, rootPoa, policyStrategy);
        }
        catch (ORBConfigurationException e) {
            throw new ORBInitializationException(e);
        }
        this.m_ejbObjectPoa = this.createPOA("oc4j.ejb.object." + home.getApplicationName(), rootPoa, policies);
        this.setServantLocator(this.m_ejbObjectPoa, new EjbServantLocator(home.getClassLoader()));
    }

    boolean isIdentical(EJBObject clientReference, CorbaEJBObject ejbObject) {
        if (!(clientReference instanceof Object)) {
            return false;
        }
        return this.equivalentCORBAObjects(ejbObject.getCorbaReference(), clientReference);
    }

    private EJBObject configureEjbReference(EJBObject object, CorbaEJBHome home, EJBObjectID objectID) throws ORBInitializationException {
        Servant servant = this.createServantForWrapper(object);
        home.registerEjbServant(objectID, servant);
        EJBObject ejb = this.createRemoteObjectReference(home, servant, objectID);
        return ejb;
    }

    EJBObject getReference(StatefulSessionEJBHome home, EJBObject object) throws ORBInitializationException {
        StatefulObjectID objectID = new StatefulObjectID(home.getApplicationName(), home.getLocation(), ((StatefulSessionEJBObject)object).OC4J_getId());
        return this.configureEjbReference(object, home, objectID);
    }

    EJBObject getReference(StatelessSessionEJBHome home, EJBObject object) throws ORBInitializationException {
        EJBObjectID objectID = new EJBObjectID(home.getApplicationName(), home.getLocation());
        return this.configureEjbReference(object, home, objectID);
    }

    EJBObject getReference(EntityEJBHome home, EJBObject object) throws ORBInitializationException {
        try {
            return this.configureEjbReference(object, home, new EntityObjectID(home.getApplicationName(), home.getLocation(), object.getPrimaryKey()));
        }
        catch (RemoteException e) {
            throw new ORBInitializationException(e);
        }
    }

    EJBObject getReference(CorbaEJBHome home, EJBObject object) throws ORBInitializationException {
        EJBObjectID objectID = new EJBObjectID(home.getApplicationName(), home.getLocation());
        return this.configureEjbReference(object, home, objectID);
    }

    private EJBObject createRemoteObjectReference(CorbaEJBHome home, Servant servant, EJBObjectID objectId) throws ORBInitializationException {
        try {
            Object obj = this.m_ejbObjectPoa.create_reference_with_id(objectId.toByteArray(), this.getRepositoryID(servant));
            return this.narrowToEJBObject(obj, home.getRemoteClassName(), home);
        }
        catch (IOException e) {
            throw new ORBInitializationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ORBInitializationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EJBObject narrowToEJBObject(java.lang.Object obj, String remoteInterfaceName, CorbaEJBHome contextContainer) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(remoteInterfaceName, true, contextContainer.getClassLoader());
        this.setEjbContextContainerForThread(contextContainer);
        try {
            EJBObject eJBObject = (EJBObject)PortableRemoteObject.narrow((java.lang.Object)obj, clazz);
            return eJBObject;
        }
        finally {
            this.unsetEjbContextContainerForThread();
        }
    }

    public void undeploy() {
        this.m_ejbObjectPoa.destroy(false, true);
    }

    class EjbServantLocator
    extends BaseServantLocator {
        EjbServantLocator(ClassLoader ejbClassLoader) {
            super(ejbClassLoader);
        }

        protected Servant getSelectedServant(CorbaEJBHome home, EJBObjectID objectID) {
            return home.getEjbServant(objectID);
        }
    }
}

