/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.naming.url.opmn;

import java.net.URISyntaxException;
import java.util.StringTokenizer;
import oracle.oc4j.naming.url.URLHandler;

public class opmncorbaURLHandler
implements URLHandler {
    private String m_host = "localhost";
    private int m_port = 6003;
    private String m_oc4jInstanceName = "home";
    private String m_lookupStr = null;

    public opmncorbaURLHandler(String url) throws URISyntaxException {
        if (!url.startsWith("opmn:corbaname::")) {
            throw new URISyntaxException(url, "URL is not an opmn:corbaname URL", 0);
        }
        if ((url = url.substring("opmn:corbaname::".length())).indexOf(35) >= 0) {
            url = this.stripOffLookupName(url, '#');
        } else if (url.indexOf(47) >= 0) {
            url = this.stripOffLookupName(url, '/');
        }
        StringTokenizer st = new StringTokenizer(url, ":");
        if (st.hasMoreTokens()) {
            this.m_host = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            String portOrInstance = st.nextToken();
            try {
                this.m_port = Integer.parseInt(portOrInstance);
                if (st.hasMoreTokens()) {
                    this.m_oc4jInstanceName = st.nextToken();
                }
            }
            catch (NumberFormatException e) {
                this.m_oc4jInstanceName = portOrInstance;
            }
        }
        if (st.hasMoreTokens()) {
            throw new URISyntaxException(url, "Too many colons");
        }
    }

    private String stripOffLookupName(String url, char separator) {
        int pos = url.indexOf(separator);
        this.m_lookupStr = url.substring(pos + 1);
        return url.substring(0, pos);
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getInstanceName() {
        return this.m_oc4jInstanceName;
    }

    public String getLookupString() {
        return this.m_lookupStr;
    }
}

