/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.query.Query;
import oracle.classloader.query.QueryProcessor;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.oc4j.peek.ClassPathAdaptr;
import oracle.oc4j.peek.FindCodeSourceAdaptr;
import oracle.oc4j.peek.FindResourceAdaptr;
import oracle.oc4j.peek.GetResourceAdaptr;
import oracle.oc4j.peek.HelpHandler;
import oracle.oc4j.peek.LoadClassAdaptr;
import oracle.oc4j.peek.Peek;

public class QueryHandler
extends HelpHandler {
    private static final String EMPTY = "Please enter a search string or a query. Select Home from the View menu for details.";
    private static final String UNSUPPORTED = "Unsupported operation.";
    private static final String[] NO_ARGS = new String[0];
    private static final String FIND_RESOURCE_QUERY = "FindResource";
    private static final String FIND_CODE_SOURCE_QUERY = "FindCodeSource";
    private static final String LOAD_CLASS_QUERY = "LoadClass";
    private static final String GET_RESOURCE_QUERY = "GetResource";
    private static final String CLASS_PATH_QUERY = "ClassPath";
    private static Map adapters = new HashMap();
    private static final Map QUERY_DESCRIPTIONS;

    private static Map getQueryDescriptions() {
        String key;
        Map orig = ClassLoadEnvironment.getQueryDescriptions((List)Peek.QUERY_CLASS_NAMES);
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iterator = orig.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            String value = QueryHandler.cleanText((String)orig.get(key));
            result.put(key, value);
        }
        iterator = adapters.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            String className = (String)adapters.get(key);
            try {
                Class clz = QueryHandler.loadQueryClass(className);
                Query q = (Query)clz.newInstance();
                String description = QueryHandler.cleanText(q.getDescription());
                result.put(key, description);
            }
            catch (Throwable e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAdapter(String queryName, String queryAdaptorClassName) {
        Map map = adapters;
        synchronized (map) {
            adapters.put(queryName, queryAdaptorClassName);
        }
    }

    public String getURISuffix() {
        return "query";
    }

    public static String getQueryDescription(String queryName) {
        return (String)QUERY_DESCRIPTIONS.get(queryName);
    }

    protected String getQueryFieldValue(String pathArgument, HttpServletRequest request) {
        if (pathArgument != null) {
            return pathArgument;
        }
        return request.getParameter("q");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class loadQueryClass(String queryClassName) throws Exception {
        Map map = adapters;
        synchronized (map) {
            String adaptor = (String)adapters.get(queryClassName);
            if (adaptor != null) {
                queryClassName = adaptor;
            }
        }
        return QueryProcessor.loadQueryClass((String)queryClassName, (boolean)true);
    }

    protected void pageBody(String query, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        if ((query = QueryHandler.filterQueryString(this.getQueryFieldValue(query, request))) == null || query.length() == 0) {
            ((Writer)out).write(EMPTY);
        } else if (query.startsWith("exit") || query.startsWith("Exit")) {
            ((Writer)out).write(UNSUPPORTED);
        } else {
            String[] args = NO_ARGS;
            String fullQuery = query;
            Query q = null;
            Object result = null;
            if (query.indexOf(32) > 0) {
                StringTokenizer st = new StringTokenizer(query, " ");
                query = st.nextToken();
                int count = st.countTokens();
                args = new String[count];
                for (int i = 0; i < count; ++i) {
                    args[i] = st.nextToken();
                }
            }
            if (query.indexOf(42) < 0 && query.indexOf(126) < 0) {
                try {
                    Class clz = QueryHandler.loadQueryClass(query);
                    if (Query.class.isAssignableFrom(clz)) {
                        q = (Query)clz.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (ClassCastException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (LinkageError e) {
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            if (q == null) {
                result = this.doFind(query);
            } else {
                try {
                    result = q.execute(args);
                }
                catch (Throwable t) {
                    result = t;
                }
            }
            if (result == null) {
                QueryHandler.help(query, out);
            } else {
                String queryResult = result.toString();
                if (queryResult.length() == 0) {
                    QueryHandler.help(query, out);
                } else if (result instanceof ClassNotFoundException) {
                    ((Writer)out).write("Unknown query: '");
                    ((Writer)out).write(query);
                    ((Writer)out).write("'\n");
                } else {
                    ((Writer)out).write("<pre>");
                    ((Writer)out).write(queryResult);
                    ((Writer)out).write("</pre>");
                    request.getSession().setAttribute("last-query", (Object)fullQuery);
                }
            }
        }
    }

    private Object doFind(String queryString) throws Exception {
        Object result = null;
        if (queryString.endsWith(".jar")) {
            result = this.doFind(FIND_CODE_SOURCE_QUERY, queryString);
        } else {
            Object tempResult;
            result = this.doFind(FIND_RESOURCE_QUERY, queryString);
            if (result != null && result.toString().indexOf(" not found") >= 0 && (tempResult = this.doFind(FIND_CODE_SOURCE_QUERY, queryString)) != null && tempResult.toString().indexOf("Found code-source") >= 0) {
                result = tempResult;
            }
        }
        return result;
    }

    private Object doFind(String queryClass, String target) throws Exception {
        Class clz = QueryHandler.loadQueryClass(queryClass);
        Query query = (Query)clz.newInstance();
        String[] args = new String[]{target};
        try {
            return query.execute(args);
        }
        catch (Throwable t) {
            return t;
        }
    }

    static {
        QueryHandler.registerAdapter(FIND_RESOURCE_QUERY, FindResourceAdaptr.class.getName());
        QueryHandler.registerAdapter(FIND_CODE_SOURCE_QUERY, FindCodeSourceAdaptr.class.getName());
        QueryHandler.registerAdapter(LOAD_CLASS_QUERY, LoadClassAdaptr.class.getName());
        QueryHandler.registerAdapter(GET_RESOURCE_QUERY, GetResourceAdaptr.class.getName());
        QueryHandler.registerAdapter(CLASS_PATH_QUERY, ClassPathAdaptr.class.getName());
        QUERY_DESCRIPTIONS = QueryHandler.getQueryDescriptions();
    }
}

