/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.HashSet;
import java.util.Set;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.ClassQuery;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassDependencies;

public class Depends
extends ClassQuery
implements ClassDependencies.Visitor {
    private int targetCount;
    private String[] targets;
    private Set codeSources = new HashSet();

    public String getDescription() {
        return "List all classes that depend on the specified class(s).\n\nArgs: className ... [loaderName]\n\nClass names must be fully qualifed. To specify an entire package, use '*' as the leaf name. If loader name is specified, all classes visible from that loader will be checked. If not specified, checks all classes visible to all loaders from the 'api' downwards.";
    }

    private String getTargetName(String target) {
        if (target.endsWith(".")) {
            return target + "*";
        }
        return target;
    }

    protected void buildReport() {
        this.appendln();
        this.append("Search report for dependencies on");
        if (this.targetCount == 1) {
            this.append(' ');
            this.append(this.getTargetName(this.targets[0]));
            this.appendln('.');
        } else {
            this.appendln(':');
            this.appendln();
            for (int i = 0; i < this.targetCount; ++i) {
                this.indent();
                this.append('D');
                this.append(i);
                this.append(": ");
                this.appendln(this.getTargetName(this.targets[i]));
            }
        }
        this.appendln();
        this.append("Dependent classes found: ");
        this.appendln(this.sortedHits.length);
        this.append(" Dependent code-sources: ");
        this.appendln(this.codeSources.size());
        this.append("   Code-sources checked: ");
        this.appendln(this.codeSourcesCount);
        this.append("        Classes checked: ");
        this.appendln(this.classesCount);
        this.append("     Average class size: ");
        this.appendln(this.classesCount > 0 ? this.totalClassSize / this.classesCount : 48);
        this.append("     Maximum class size: ");
        this.append(this.maxClassSize);
        this.append(" (");
        this.append(this.maxClassName);
        this.appendln(')');
        this.append("            Search time: ");
        this.getReportBuffer().append(System.currentTimeMillis() - this.startTime);
        this.appendln(" ms");
        this.appendln();
        if (this.sortedHits.length == 0) {
            this.appendln("No dependencies found.");
        } else {
            this.appendln("Dependent classes:");
            this.appendln();
            this.appendNumberedList(this.sortedHits);
            this.appendln();
            this.appendln("Dependent code-sources:");
            this.appendln();
            this.appendNumberedList(this.sort(this.codeSources));
        }
        this.appendln();
        if (!this.errors.isEmpty()) {
            this.appendln("Errors:");
            this.appendln();
            this.appendNumberedList(this.errors);
        }
    }

    protected boolean shouldVisitClass(String className) {
        for (int i = 0; i < this.targetCount; ++i) {
            if (!className.startsWith(this.targets[i])) continue;
            return false;
        }
        return true;
    }

    protected void visitClass(String className, byte[] classData, int classSize) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(classData, 0, classSize);
        DataInputStream din = new DataInputStream(in);
        ClassDependencies.visitDependencies((DataInputStream)din, (ClassDependencies.Visitor)this);
    }

    protected void visitArgument(String arg) {
        if (arg.endsWith("*")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        this.targets = (String[])ArrayUtils.append((Class)String.class, (Object[])this.targets, (int)this.targetCount++, (Object)arg);
    }

    protected void prepare() {
    }

    public boolean visitDependency(String dependentClassName) {
        for (int i = 0; i < this.targetCount; ++i) {
            if (!dependentClassName.startsWith(this.targets[i])) continue;
            StringBuffer buf = new StringBuffer();
            buf.append(this.currentClassName);
            if (this.targetCount > 1) {
                buf.append(" (D");
                buf.append(i);
                buf.append(')');
            }
            buf.append(" in ");
            buf.append(Depends.getDisplayPath((SharedCodeSource)this.currentSource));
            buf.append(".");
            this.hits.add(buf.toString());
            this.codeSources.add(this.currentSource.toString());
        }
        return true;
    }
}

