/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.util.OC4JRuntimeProperties;
import com.evermind.util.RMIProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.j2ee.security.SecurityMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.oc4j.security.SSLUtilValues;
import oracle.oc4j.security.SSLUtilsForJSSE;

public class SSLUtils
implements SSLUtilValues {
    private static Logger s_customerFacingLogger = CustomerLogger.getLogger("oracle.j2ee.security.oc4j", SecurityMessageBundle.class.getName());
    public static final String DEFAULT_SECURE_PROPERTIES_FILE_LOCATION = "ejb_sec.properties";
    public static final String DEFAULT_PROP_PREFIX_TAG = "oc4j";
    public static final String KEYSTORE_LOC_PROP = "keyStoreLoc";
    public static final String KEYSTORE_PASS_PROP = "keyStorePass";
    public static final String TRUSTSTORE_LOC_PROP = "trustStoreLoc";
    public static final String TRUSTSTORE_PASS_PROP = "trustStorePass";
    public static final String NEEDS_CLIENT_AUTH_PROP = "enable.clientauth";
    public static final String SSL_PROVIDER_PROP = "ssl.provider";
    public static final String SOCKET_FACTORY_PROP = "ssl.socket.factory";
    public static final String STORE_TYPE_PROP = "ssl.storeType";
    public static final String[] ALL_PROPS = new String[]{"keyStoreLoc", "keyStorePass", "trustStoreLoc", "trustStorePass", "enable.clientauth", "ssl.provider", "ssl.socket.factory", "ssl.storeType"};
    private static String m_cachedEjbSecFileLocation = null;
    private static final String CONFIG_DIR_NAME = "config";

    public static void reset() {
        m_cachedEjbSecFileLocation = null;
    }

    public static Values getDefaultValues() throws IOException {
        return SSLUtils.getDefaultValues(null, true);
    }

    public static Values getDefaultValues(String propCategory, boolean considerEjbSecProperties) throws IOException {
        return SSLUtils.getValues(null, considerEjbSecProperties ? SSLUtils.getDefaultPropertiesFileLocation() : null, DEFAULT_PROP_PREFIX_TAG, propCategory, SSLUtils.getOverrides(propCategory));
    }

    public static Values getDefaultValues(String propCategory) throws IOException {
        return SSLUtils.getValues(null, SSLUtils.getDefaultPropertiesFileLocation(), DEFAULT_PROP_PREFIX_TAG, propCategory, SSLUtils.getOverrides(propCategory));
    }

    public static String getDefaultPropertiesFileLocation() {
        File ejbSecFile;
        StringBuffer buff;
        if (null != m_cachedEjbSecFileLocation) {
            return m_cachedEjbSecFileLocation;
        }
        String defaultLoc = null;
        if (null == OC4JRuntimeProperties.getJ2eeHomeDir()) {
            buff = new StringBuffer(80).append('.').append(File.separator);
            buff.append(DEFAULT_SECURE_PROPERTIES_FILE_LOCATION);
            defaultLoc = buff.toString();
            ejbSecFile = new File(defaultLoc);
            if (!ejbSecFile.exists()) {
                buff.setLength(0);
                buff = new StringBuffer(80).append('.').append(File.separator).append(CONFIG_DIR_NAME).append(File.separator);
                buff.append(DEFAULT_SECURE_PROPERTIES_FILE_LOCATION);
            }
        } else {
            buff = SSLUtils.getJ2eeConfigDir();
            buff.append(DEFAULT_SECURE_PROPERTIES_FILE_LOCATION);
            defaultLoc = buff.toString();
        }
        if ((ejbSecFile = new File(buff.toString())).exists()) {
            m_cachedEjbSecFileLocation = ejbSecFile.getAbsolutePath();
            return m_cachedEjbSecFileLocation;
        }
        return defaultLoc;
    }

    static StringBuffer getJ2eeConfigDir() {
        StringBuffer buff = new StringBuffer(80);
        if (null == OC4JRuntimeProperties.getOracleJ2eeHome()) {
            if (null == OC4JRuntimeProperties.getJ2eeHomeDir()) {
                buff.append('.');
            } else {
                buff.append(OC4JRuntimeProperties.getJ2eeHomeDir());
            }
            buff.append(File.separator).append(CONFIG_DIR_NAME).append(File.separator);
        } else {
            buff.append(OC4JRuntimeProperties.getOracleJ2eeHome()).append(File.separator).append(CONFIG_DIR_NAME).append(File.separator);
        }
        return buff;
    }

    public static SSLUtilValues getOverrides() {
        return new SSLUtilsForJSSE();
    }

    public static SSLUtilValues getOverrides(String propCategory) {
        if (propCategory != null && propCategory.equals("rmi") && !RMIProperties.getRmiSslAllowoverride()) {
            return null;
        }
        return new SSLUtilsForJSSE();
    }

    public static Values getValues(Values values, String fileLocation, String propPrefix, String propCategory, SSLUtilValues overrideValueProvider) throws IOException {
        File file;
        Properties fileProps = new Properties();
        if (null != fileLocation && (file = new File(fileLocation)).exists()) {
            FileInputStream fis = new FileInputStream(file);
            fileProps.load(fis);
            fis.close();
        }
        return SSLUtils.getValues(values, fileProps, propPrefix, propCategory, overrideValueProvider);
    }

    public static Values getValues(Values values, Hashtable props, String propPrefix, String propCategory, SSLUtilValues overrideValueProvider) throws IOException {
        if (null == props) {
            return SSLUtils.getValues(values, SSLUtils.getDefaultPropertiesFileLocation(), propPrefix, propCategory, overrideValueProvider);
        }
        if (null == values) {
            values = new Values();
        }
        if (null == propPrefix) {
            propPrefix = DEFAULT_PROP_PREFIX_TAG;
        }
        StringBuffer propNameBase = new StringBuffer(40);
        if (null != propPrefix && null != propCategory) {
            propNameBase.append(propPrefix).append('.').append(propCategory).append('.');
            SSLUtils.putValues(values, props, propNameBase, overrideValueProvider);
        }
        propNameBase.setLength(0);
        if (null != propPrefix) {
            propNameBase.append(propPrefix).append('.');
        }
        SSLUtils.putValues(values, props, propNameBase, overrideValueProvider);
        SSLUtils.putNonHierarchialValues(values, props, overrideValueProvider);
        return values;
    }

    private static void putNonHierarchialValues(Values values, Hashtable props, SSLUtilValues overrideValueProvider) {
        String propValue = SSLUtils.getProperty(props, SSL_PROVIDER_PROP, null == overrideValueProvider ? null : overrideValueProvider.getProvider());
        if (null == propValue) {
            values.remove(SSL_PROVIDER_PROP);
        } else {
            values.put(SSL_PROVIDER_PROP, propValue);
        }
        propValue = SSLUtils.getProperty(props, SOCKET_FACTORY_PROP, null == overrideValueProvider ? null : overrideValueProvider.getSocketFactory());
        if (null == propValue) {
            values.remove(SOCKET_FACTORY_PROP);
        } else {
            values.put(SOCKET_FACTORY_PROP, propValue);
        }
        propValue = SSLUtils.getProperty(props, STORE_TYPE_PROP, null == overrideValueProvider ? null : overrideValueProvider.getStoreType());
        if (null == propValue) {
            values.remove(STORE_TYPE_PROP);
        } else {
            values.put(STORE_TYPE_PROP, propValue);
        }
    }

    private static String getProperty(Hashtable props, String key, String defaultValue) {
        String propValue = (String)props.get(key);
        if (null == propValue) {
            return defaultValue;
        }
        return propValue;
    }

    private static void putValues(Values values, Hashtable props, StringBuffer propNameBase, SSLUtilValues overrideValueProvider) {
        SSLUtils.put(values, props, propNameBase, KEYSTORE_LOC_PROP, null == overrideValueProvider ? null : overrideValueProvider.getKeyStoreLocation());
        SSLUtils.put(values, props, propNameBase, KEYSTORE_PASS_PROP, null == overrideValueProvider ? null : overrideValueProvider.getKeyStorePassword());
        SSLUtils.put(values, props, propNameBase, TRUSTSTORE_LOC_PROP, null == overrideValueProvider ? null : overrideValueProvider.getTrustStoreLocation());
        SSLUtils.put(values, props, propNameBase, TRUSTSTORE_PASS_PROP, null == overrideValueProvider ? null : overrideValueProvider.getTrustStorePassword());
        SSLUtils.put(values, props, propNameBase, NEEDS_CLIENT_AUTH_PROP, null == overrideValueProvider ? null : overrideValueProvider.getNeedsClientAuth());
    }

    private static void put(Values values, Hashtable props, StringBuffer propNameBase, String propName, String overrideValue) {
        if (values.containsKey(propName)) {
            return;
        }
        if (null != overrideValue) {
            values.put(propName, overrideValue);
            return;
        }
        String propValue = SSLUtils.getProperty(props, propName, null);
        if (null != propValue) {
            values.put(propName, propValue);
            return;
        }
        int baseLen = propNameBase.length();
        propNameBase.append(propName);
        propValue = SSLUtils.getProperty(props, propNameBase.toString(), null);
        propNameBase.setLength(baseLen);
        if (null != propValue) {
            values.put(propName, propValue);
            return;
        }
    }

    public String getKeyStoreLocation() {
        return null;
    }

    public String getKeyStorePassword() {
        return null;
    }

    public String getTrustStoreLocation() {
        return null;
    }

    public String getTrustStorePassword() {
        return null;
    }

    public String getNeedsClientAuth() {
        return "false";
    }

    public String getProvider() {
        return null;
    }

    public String getSocketFactory() {
        return null;
    }

    public String getStoreType() {
        return null;
    }

    public static class Values
    extends Properties
    implements SSLUtilValues {
        public boolean isSpecified() {
            return null != this.getKeyStoreLocation() || null != this.getKeyStorePassword() || null != this.getTrustStoreLocation() || null != this.getTrustStorePassword();
        }

        public String getKeyStoreLocation() {
            return this.getProperty(SSLUtils.KEYSTORE_LOC_PROP);
        }

        public String getKeyStorePassword() {
            return this.getProperty(SSLUtils.KEYSTORE_PASS_PROP);
        }

        public String getTrustStoreLocation() {
            return this.getProperty(SSLUtils.TRUSTSTORE_LOC_PROP);
        }

        public String getTrustStorePassword() {
            return this.getProperty(SSLUtils.TRUSTSTORE_PASS_PROP);
        }

        public String getNeedsClientAuth() {
            return this.getProperty(SSLUtils.NEEDS_CLIENT_AUTH_PROP);
        }

        public String getProvider() {
            return this.getProperty(SSLUtils.SSL_PROVIDER_PROP);
        }

        public String getSocketFactory() {
            return this.getProperty(SSLUtils.SOCKET_FACTORY_PROP);
        }

        public String getStoreType() {
            return this.getProperty(SSLUtils.STORE_TYPE_PROP);
        }

        public Values() {
        }

        public Values(SSLUtilValues another) {
            if (null != another) {
                this.putProperty(SSLUtils.KEYSTORE_LOC_PROP, another.getKeyStoreLocation());
                this.putProperty(SSLUtils.KEYSTORE_PASS_PROP, another.getKeyStorePassword());
                this.putProperty(SSLUtils.TRUSTSTORE_LOC_PROP, another.getTrustStoreLocation());
                this.putProperty(SSLUtils.TRUSTSTORE_PASS_PROP, another.getTrustStorePassword());
                this.putProperty(SSLUtils.NEEDS_CLIENT_AUTH_PROP, another.getNeedsClientAuth());
                this.putProperty(SSLUtils.SSL_PROVIDER_PROP, another.getProvider());
                this.putProperty(SSLUtils.SOCKET_FACTORY_PROP, another.getSocketFactory());
                this.putProperty(SSLUtils.STORE_TYPE_PROP, another.getStoreType());
            }
        }

        void putProperty(String name, String value) {
            if (null == value) {
                this.remove(name);
            } else {
                this.setProperty(name, value);
            }
        }
    }
}

