/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security.acc;

import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import oracle.oc4j.security.acc.AtzContainerContracts;
import oracle.oc4j.security.acc.AtzContainerContractsBasic;
import oracle.oc4j.security.acc.AtzContainerContractsJacc;
import oracle.security.jacc.provider.RoleMappingConfiguration;
import oracle.security.jacc.provider.RoleMappingConfigurationException;
import oracle.security.jacc.provider.RoleMappingConfigurationFactory;

public class AtzContainerContractsJaznJacc
extends AtzContainerContractsJacc {
    public static String JACC_POLICY_PROVIDER = "oracle.security.jacc.provider.J2SEPolicy";
    public static String JAZN_POLICY_CONFIG_FACTORY = "oracle.security.jacc.provider.JACCPolicyConfigurationFactory";
    public static final String ROLE_MAPPING_FACTORY_TAG = "oracle.security.jacc.provider.RoleMappingConfigurationFactory.provider";
    public static final String JAZN_ROLE_MAPPING_FACTORY = "oracle.security.jacc.provider.RoleMappingConfigurationFactoryImpl";
    public static final String POLICY_REPOSITORY_TAG = "oracle.security.jacc.provider.repository";
    public static String JAZN_POLICY_REPOSITORY = "./persistence/jaccrepository";

    protected AtzContainerContractsJaznJacc(String contextId) {
        super(contextId);
    }

    public static AtzContainerContracts create(String contextId) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AtzContainerContractsJaznJacc acc = new AtzContainerContractsJaznJacc(contextId);
        ((AtzContainerContractsJacc)acc).setPolicy(false);
        return acc;
    }

    void establishRoleMappingConfigurationSettings() {
        if (null == System.getProperty(ROLE_MAPPING_FACTORY_TAG)) {
            if (this.getTraceLogger().isLoggable(Level.FINE)) {
                this.getTraceLogger().log(Level.FINE, "system.property {1} is defaulting to {2}", new String[]{ROLE_MAPPING_FACTORY_TAG, JAZN_ROLE_MAPPING_FACTORY});
            }
            System.setProperty(ROLE_MAPPING_FACTORY_TAG, JAZN_ROLE_MAPPING_FACTORY);
        }
    }

    RoleMappingConfiguration getRoleMappingConfiguration() throws RoleMappingConfigurationException, ClassNotFoundException {
        return this.getRoleMappingConfiguration(false);
    }

    RoleMappingConfiguration getRoleMappingConfiguration(boolean overwriteAllRoleMappings) throws RoleMappingConfigurationException, ClassNotFoundException {
        this.establishRoleMappingConfigurationSettings();
        return RoleMappingConfigurationFactory.getRoleMappingConfigurationFactory().getRoleMappingConfiguration(this.getContextId(), overwriteAllRoleMappings);
    }

    void establishPolicyRepositorySettings() {
        if (null == System.getProperty(POLICY_REPOSITORY_TAG)) {
            if (this.getTraceLogger().isLoggable(Level.FINE)) {
                this.getTraceLogger().log(Level.FINE, "system.property {1} is defaulting to {2}", new String[]{POLICY_REPOSITORY_TAG, this.getDefaultRepositoryPath()});
            }
            System.setProperty(POLICY_REPOSITORY_TAG, this.getDefaultRepositoryPath());
        }
    }

    String getDefaultRepositoryPath() {
        String baseDir = OC4JRuntimeProperties.getJ2eeHomeDir();
        if (null == baseDir || baseDir.length() <= 0) {
            return JAZN_POLICY_REPOSITORY;
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append(OC4JRuntimeProperties.getJ2eeHomeDir()).append(File.separator).append(JAZN_POLICY_REPOSITORY);
        return buff.toString();
    }

    public void clearAllContracts() throws Exception {
        this.getRoleMappingConfiguration(true);
        super.clearAllContracts();
    }

    protected AtzContainerContractsBasic.RoleMapping createRoleMapping() {
        return new JaznJaccRoleMapping(this);
    }

    protected static class JaznJaccRoleMapping
    extends AtzContainerContractsBasic.RoleMapping {
        JaznJaccRoleMapping(AtzContainerContractsJaznJacc accSuite) {
            super(accSuite);
        }

        Collection getRolesForPrincipal(Collection principalRoles, Collection roles, Principal p) throws Exception {
            if (null == roles) {
                return null;
            }
            Iterator iter = roles.iterator();
            while (iter.hasNext()) {
                String role = (String)iter.next();
                if (!this.isPrincipalInRole(p, role)) continue;
                principalRoles.add(role);
            }
            return principalRoles;
        }

        public void assignPrincipalToRole(Principal p, String role) throws Exception {
            ((AtzContainerContractsJaznJacc)this.m_accSuite).getRoleMappingConfiguration().assignPrincipalToRole(p, role);
            ((AtzContainerContractsJaznJacc)this.m_accSuite).onRoleMappingPerformed(p, role);
        }

        public boolean isPrincipalInRole(Principal p, String role) throws Exception {
            Collection principals = ((AtzContainerContractsJaznJacc)this.m_accSuite).getRoleMappingConfiguration().getPrincipalsAssignedToRole(role);
            if (null == principals || null == p) {
                return false;
            }
            Iterator iter = principals.iterator();
            while (iter.hasNext()) {
                Principal roledPrincipal = (Principal)iter.next();
                if (!((Object)p).equals(roledPrincipal)) continue;
                return true;
            }
            return false;
        }

        public boolean isSubjectInRole(Subject s, String role) throws Exception {
            if (null == s || null == role) {
                return false;
            }
            Set<Principal> principals = s.getPrincipals();
            if (null != principals) {
                Iterator<Principal> iter = principals.iterator();
                while (iter.hasNext()) {
                    Principal p = iter.next();
                    if (!this.isPrincipalInRole(p, role)) continue;
                    return true;
                }
            }
            return false;
        }

        public Collection getRoles() throws Exception {
            return ((AtzContainerContractsJaznJacc)this.m_accSuite).getRoleMappingConfiguration().getRoles();
        }

        public Collection getRolesForPrincipal(Principal p) throws Exception {
            return this.getRolesForPrincipal(new HashSet(), this.getRoles(), p);
        }

        public Collection getRolesForSubject(Subject s) throws Exception {
            if (null == s) {
                return null;
            }
            Collection roles = this.getRoles();
            if (null == roles) {
                return null;
            }
            HashSet principalRoles = new HashSet();
            Set<Principal> principals = s.getPrincipals();
            if (null != principals) {
                Iterator<Principal> iter = principals.iterator();
                while (iter.hasNext()) {
                    Principal p = iter.next();
                    this.getRolesForPrincipal(principalRoles, roles, p);
                }
            }
            return principalRoles;
        }
    }
}

