/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config.legacy;

import java.util.Map;
import java.util.Vector;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.config.legacy.LegacyOneDataSourceConfig;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LegacyDataSourcesConfig {
    public static final String DATA_SOURCE_NODE_NAME = "data-source";
    private Node m_rootNode;
    private LegacyOneDataSourceConfig[] m_dataSourceConfigs;

    public LegacyDataSourcesConfig(Node rootNode) throws InstantiationException {
        if (rootNode == null) {
            String msg = DataSourceMessages.warningLegacyDataSourcesConfigRootNodeNull();
            throw new InstantiationException(msg);
        }
        this.m_rootNode = rootNode;
        try {
            Vector expandedDataSourceConfigs = this.expandDataSourceConfigs(this.getLegacyDataSourceConfigs());
            this.m_dataSourceConfigs = new LegacyOneDataSourceConfig[expandedDataSourceConfigs.size()];
            for (int i = 0; i < expandedDataSourceConfigs.size(); ++i) {
                this.m_dataSourceConfigs[i] = (LegacyOneDataSourceConfig)expandedDataSourceConfigs.get(i);
            }
        }
        catch (InstantiationException e) {
            DataSourceMessages.warningExceptionParsingLegacyDataSourcesConfig(e);
            throw e;
        }
    }

    public LegacyDataSourcesConfig(Map settings) throws InstantiationException {
        try {
            Vector<LegacyOneDataSourceConfig> expandedDataSourceConfigs = new Vector<LegacyOneDataSourceConfig>();
            expandedDataSourceConfigs.add(new LegacyOneDataSourceConfig(settings));
            this.m_dataSourceConfigs = new LegacyOneDataSourceConfig[expandedDataSourceConfigs.size()];
            for (int i = 0; i < expandedDataSourceConfigs.size(); ++i) {
                this.m_dataSourceConfigs[i] = (LegacyOneDataSourceConfig)expandedDataSourceConfigs.get(i);
            }
        }
        catch (InstantiationException e) {
            DataSourceMessages.warningExceptionParsingLegacyDataSourcesConfigMap(e);
            throw e;
        }
    }

    private Vector getLegacyDataSourceConfigs() throws InstantiationException {
        Vector<LegacyOneDataSourceConfig> children = new Vector<LegacyOneDataSourceConfig>();
        NodeList nodes = this.m_rootNode.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals(DATA_SOURCE_NODE_NAME)) continue;
                LegacyOneDataSourceConfig dataSource = new LegacyOneDataSourceConfig(node);
                children.add(dataSource);
            }
        }
        return children;
    }

    public LegacyOneDataSourceConfig[] getDataSourceConfigs() {
        return this.m_dataSourceConfigs;
    }

    private Vector expandDataSourceConfigs(Vector dataSources) throws InstantiationException {
        Vector<LegacyOneDataSourceConfig> expandedDataSources = new Vector<LegacyOneDataSourceConfig>();
        for (int i = 0; i < dataSources.size(); ++i) {
            LegacyOneDataSourceConfig config = (LegacyOneDataSourceConfig)dataSources.get(i);
            expandedDataSources.add(config);
            if (config.getXALocation() != null) {
                LegacyOneDataSourceConfig xaConfig = new LegacyOneDataSourceConfig();
                xaConfig.setClassName("com.evermind.sql.DriverManagerXADataSource");
                xaConfig.setLocation(config.getXALocation());
                xaConfig.setSourceLocation(config.getLocation());
                xaConfig.setMinConnections(config.getMinConnections());
                xaConfig.setMaxConnections(config.getMaxConnections());
                xaConfig.setCleanAvailableConnectionsThreshold(config.getCleanAvailableConnectionsThreshold());
                xaConfig.setRacEnabled(config.isRacEnabled());
                xaConfig.setInactivityTimeout(config.getInactivityTimeout());
                xaConfig.setMaxConnectionAttempts(config.getMaxConnectionAttempts());
                xaConfig.setConnectionRetryInterval(config.getConnectionRetryInterval());
                xaConfig.setWaitTimeout(config.getWaitTimeout());
                xaConfig.setTaskManagerInterval(config.getTaskManagerInterval());
                expandedDataSources.add(xaConfig);
            }
            if (config.getPooledLocation() != null) {
                LegacyOneDataSourceConfig pooledConfig = new LegacyOneDataSourceConfig();
                pooledConfig.setClassName("com.evermind.sql.OrionPooledDataSource");
                pooledConfig.setLocation(config.getPooledLocation());
                pooledConfig.setSourceLocation(config.getLocation());
                pooledConfig.setMinConnections(config.getMinConnections());
                pooledConfig.setMaxConnections(config.getMaxConnections());
                pooledConfig.setCleanAvailableConnectionsThreshold(config.getCleanAvailableConnectionsThreshold());
                pooledConfig.setRacEnabled(config.isRacEnabled());
                pooledConfig.setInactivityTimeout(config.getInactivityTimeout());
                pooledConfig.setMaxConnectionAttempts(config.getMaxConnectionAttempts());
                pooledConfig.setConnectionRetryInterval(config.getConnectionRetryInterval());
                pooledConfig.setWaitTimeout(config.getWaitTimeout());
                pooledConfig.setTaskManagerInterval(config.getTaskManagerInterval());
                expandedDataSources.add(pooledConfig);
            }
            if (config.getEJBLocation() == null) continue;
            LegacyOneDataSourceConfig ejbConfig = new LegacyOneDataSourceConfig();
            ejbConfig.setClassName("com.evermind.sql.OrionCMTDataSource");
            ejbConfig.setDefault(config.isDefault());
            ejbConfig.setLocation(config.getEJBLocation());
            ejbConfig.setXASourceLocation(config.getXALocation());
            ejbConfig.setPooledLocation(config.getPooledLocation());
            ejbConfig.setMinConnections(config.getMinConnections());
            ejbConfig.setMaxConnections(config.getMaxConnections());
            ejbConfig.setMaxConnectionAttempts(config.getMaxConnectionAttempts());
            ejbConfig.setCleanAvailableConnectionsThreshold(config.getCleanAvailableConnectionsThreshold());
            ejbConfig.setRacEnabled(config.isRacEnabled());
            ejbConfig.setConnectionRetryInterval(config.getConnectionRetryInterval());
            ejbConfig.setWaitTimeout(config.getWaitTimeout());
            ejbConfig.setTaskManagerInterval(config.getTaskManagerInterval());
            if (config.getXALocation() == null) {
                throw new InstantiationException("Cannot specify ejb-location and leave out xa-location");
            }
            ejbConfig.setInactivityTimeout(config.getInactivityTimeout());
            ejbConfig.setURL(config.getURL());
            expandedDataSources.add(ejbConfig);
        }
        return expandedDataSources;
    }
}

